/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import java.util.Arrays;

public class Stack<T> {
    private final Object[] arr;
    private int pos;

    public Stack(int cap) {
        this.arr = new Object[cap];
        this.pos = -1;
    }

    public int getPos() {
        return this.pos;
    }

    public int size() {
        return this.arr.length;
    }

    public boolean isEmpty() {
        return this.pos < 0;
    }

    public boolean isFull() {
        return this.pos >= this.arr.length - 1;
    }

    public void setPos(int p) {
        if (p < this.pos) {
            Arrays.fill(this.arr, p + 1, this.pos + 1, null);
        }
        this.pos = p;
    }

    public void add(T obj) {
        this.arr[++this.pos] = obj;
    }

    public T rem() {
        Object r = this.arr[this.pos];
        this.arr[this.pos--] = null;
        return (T)r;
    }

    public T get() {
        return (T)this.arr[this.pos];
    }

    public void set(T obj) {
        this.arr[this.pos] = obj;
    }

    public T get(int i) {
        return (T)this.arr[i < 0 ? this.pos + i : i];
    }

    public void set(int i, T obj) {
        this.arr[i < 0 ? this.pos + i : i] = obj;
    }

    public void fill(T[] obj) {
        System.arraycopy(obj, 0, this.arr, this.pos + 1, obj.length);
        this.pos += obj.length;
    }

    public void drain(T[] obj) {
        int i = (this.pos -= obj.length) + 1;
        System.arraycopy(this.arr, i, obj, 0, obj.length);
        Arrays.fill(this.arr, i, i + obj.length, null);
    }

    public String toString() {
        String s = "[";
        for (int i = 0; i < this.arr.length; ++i) {
            Object obj = this.arr[i];
            s = s + (obj == null ? "null" : obj.toString()) + (i == this.arr.length - 1 ? "]" : (i == this.pos ? "| " : ", "));
        }
        return s;
    }
}

