/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import java.util.Arrays;

public class CoordMap1D<E>
implements Iterable<E> {
    private Object[] array;
    private int min;
    private int max;
    private int mask;

    public CoordMap1D(int initCapm1) {
        if (initCapm1 < 0) {
            throw new IllegalArgumentException("capacity can't be negative!");
        }
        int i = 1 << 32 - Integer.numberOfLeadingZeros(initCapm1);
        this.mask = i - 1;
        this.array = new Object[i];
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
    }

    public CoordMap1D() {
        this(7);
    }

    public E set(int k, E v) {
        if (v == null) {
            return this.remove(k);
        }
        if (k < this.min || k > this.max) {
            if (this.max == Integer.MIN_VALUE) {
                this.min = this.max = k;
            } else if (k > this.max) {
                if (k - this.min >= this.array.length) {
                    this.grow(k - this.min);
                }
                this.max = k;
            } else {
                if (this.max - k >= this.array.length) {
                    this.grow(this.max - k);
                }
                this.min = k;
            }
        }
        Object prev = this.array[k &= this.mask];
        this.array[k] = v;
        return (E)prev;
    }

    public E get(int k) {
        if (k < this.min || k > this.max) {
            return null;
        }
        return (E)this.array[k & this.mask];
    }

    public E remove(int k) {
        if (k < this.min || k > this.max) {
            return null;
        }
        Object obj = this.array[k & this.mask];
        this.array[k & this.mask] = null;
        if (k == this.min) {
            while (++k <= this.max && this.array[k & this.mask] == null) {
            }
            if (k > this.max) {
                this.min = Integer.MAX_VALUE;
                this.max = Integer.MIN_VALUE;
            } else {
                this.min = k;
            }
        } else if (k == this.max) {
            while (--k >= this.min && this.array[k & this.mask] == null) {
            }
            if (k < this.min) {
                this.min = Integer.MAX_VALUE;
                this.max = Integer.MIN_VALUE;
            } else {
                this.max = k;
            }
        }
        return (E)obj;
    }

    public int range() {
        return this.max == Integer.MIN_VALUE ? 0 : this.max - this.min + 1;
    }

    public boolean isEmpty() {
        return this.max < this.min;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public E getFirst() {
        return (E)(this.min == Integer.MAX_VALUE ? null : this.array[this.min & this.mask]);
    }

    public E getLast() {
        return (E)(this.max == Integer.MIN_VALUE ? null : this.array[this.max & this.mask]);
    }

    private void grow(int minSize) {
        int l = 1 << 32 - Integer.numberOfLeadingZeros(minSize);
        Object[] narr = new Object[l];
        int p0 = this.min & this.mask;
        int p1 = this.max & this.mask;
        int size = this.max - this.min + 1;
        this.mask = l - 1;
        if (this.min == this.max) {
            narr[this.min & this.mask] = this.array[p0];
        } else if (p1 > p0) {
            System.arraycopy(this.array, p0, narr, this.min & this.mask, size);
        } else {
            int m = this.array.length - p0;
            System.arraycopy(this.array, p0, narr, this.min & this.mask, m);
            System.arraycopy(this.array, 0, narr, (this.max & this.mask) + 1 - size + m, size - m);
        }
        this.array = narr;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public void putAll(CoordMap1D<E> map) {
        int nmax;
        int nmin = map.min < this.min ? map.min : this.min;
        int n = nmax = map.max > this.max ? map.max : this.max;
        if (nmax - nmin >= this.array.length) {
            this.grow(nmax - nmin);
        }
        if (map.max < this.min || map.min > this.max) {
            int p0 = map.min & map.mask;
            int p1 = map.max & map.mask;
            int q0 = map.min & this.mask;
            int q1 = map.max & this.mask;
            int size = map.range();
            if (p1 < p0) {
                int m = map.array.length - p0;
                System.arraycopy(map.array, p0, this.array, q0, m);
                System.arraycopy(map.array, 0, this.array, q1 + 1 - size + m, size - m);
            } else if (q1 < q0) {
                int m = this.array.length - q0;
                System.arraycopy(map.array, p0, this.array, q0, m);
                System.arraycopy(map.array, 0, this.array, q1 + 1 - size + m, size - m);
            } else {
                System.arraycopy(map.array, p0, this.array, q0, size);
            }
        } else {
            for (int i = map.min; i <= map.max; ++i) {
                Object o = map.array[i & map.mask];
                if (o == null) continue;
                this.array[i & this.mask] = o;
            }
        }
        this.max = nmax;
        this.min = nmin;
    }

    public void copyInto(int start, int end, CoordMap1D<E> map) {
        if (start < this.min) {
            start = this.min;
        }
        if (end > this.max) {
            end = this.max;
        }
        if (end < start) {
            return;
        }
        int nmin = Math.min(map.min, start);
        int nmax = Math.max(map.max, end);
        int l = nmax - nmin;
        if (l >= map.array.length) {
            super.grow(l);
        }
        for (int i = start; i <= end; ++i) {
            Object o = this.array[i & this.mask];
            if (o == null) continue;
            map.array[i & map.mask] = o;
        }
        map.min = nmin;
        map.max = nmax;
    }

    public void clear(int start, int end) {
        boolean checkEnd;
        boolean checkStart;
        boolean bl = checkStart = start <= this.min;
        if (checkStart) {
            start = this.min;
            this.min = end + 1;
        }
        boolean bl2 = checkEnd = end >= this.max;
        if (checkEnd) {
            end = this.max;
            this.max = start - 1;
        }
        if (this.max < this.min) {
            this.max = Integer.MIN_VALUE;
            this.min = Integer.MAX_VALUE;
        } else if (checkStart) {
            while (this.min < this.max && this.array[this.min & this.mask] == null) {
                ++this.min;
            }
        } else if (checkEnd) {
            while (this.max > this.min && this.array[this.max & this.mask] == null) {
                --this.max;
            }
        }
        if ((end &= this.mask) >= (start &= this.mask)) {
            Arrays.fill(this.array, start, end + 1, null);
        } else {
            Arrays.fill(this.array, start, this.array.length, null);
            Arrays.fill(this.array, 0, end + 1, null);
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[|]";
        }
        String s = "";
        for (Object o : this) {
            s = s + o.toString() + " ,";
        }
        s = "[" + this.min + "| " + s.substring(0, s.length() - 1) + "|" + this.max + "]";
        return s;
    }

    public class Iterator
    implements java.util.Iterator<E> {
        private int idx;

        private Iterator() {
            this.idx = CoordMap1D.this.min;
        }

        @Override
        public boolean hasNext() {
            return this.idx <= CoordMap1D.this.max;
        }

        @Override
        public E next() {
            Object next;
            while ((next = CoordMap1D.this.array[this.idx++ & CoordMap1D.this.mask]) == null && this.idx <= CoordMap1D.this.max) {
            }
            return next;
        }

        public int getKey() {
            return this.idx - 1;
        }
    }
}

