/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.templates;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class NBTRecipe
extends ShapedOreRecipe {
    private final String[] nbtVars;
    private final byte[] addTypes;

    public NBTRecipe(ResourceLocation group, ItemStack out, String nbtTypes, Object ... recipe) {
        super(group, out, recipe);
        this.nbtVars = nbtTypes.split(",");
        this.addTypes = new byte[this.nbtVars.length];
        for (int i = 0; i < this.nbtVars.length; ++i) {
            String s = this.nbtVars[i].trim();
            if (s.startsWith("#")) {
                this.addTypes[i] = 0;
            } else if (s.startsWith("+")) {
                this.addTypes[i] = 1;
            } else if (s.startsWith(">")) {
                this.addTypes[i] = 3;
            } else if (s.startsWith("<")) {
                this.addTypes[i] = 4;
            } else if (s.startsWith("=")) {
                this.addTypes[i] = 5;
            } else {
                this.addTypes[i] = 0;
                this.nbtVars[i] = s;
                continue;
            }
            this.nbtVars[i] = s.substring(1);
        }
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack out = this.func_77571_b().func_77946_l();
        if (!out.func_77942_o()) {
            out.func_77982_d(new NBTTagCompound());
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!stack.func_77942_o()) continue;
            for (int j = 0; j < this.nbtVars.length; ++j) {
                if (!stack.func_77978_p().func_74764_b(this.nbtVars[j]) || this.applyTag(out.func_77978_p(), stack.func_77978_p().func_74781_a(this.nbtVars[j]), j, out.func_190916_E())) continue;
                out.func_77982_d(null);
                return out;
            }
        }
        return out;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean applyTag(NBTTagCompound nbt, NBTBase tag, int idx, int stacksize) {
        String var = this.nbtVars[idx];
        byte type = this.addTypes[idx];
        if (type == 0) {
            if (nbt.func_74764_b(var)) return true;
            nbt.func_74782_a(var, tag);
            return true;
        } else if (type == 5) {
            if (nbt.func_74764_b(var)) return nbt.func_74781_a(var).equals((Object)tag);
            nbt.func_74782_a(var, tag);
            return true;
        } else if (tag instanceof NBTTagByte) {
            nbt.func_74774_a(var, (byte)this.applyValue(nbt.func_74771_c(var), ((NBTTagByte)tag).func_150290_f(), type, stacksize));
            return true;
        } else if (tag instanceof NBTTagShort) {
            nbt.func_74777_a(var, (short)this.applyValue(nbt.func_74765_d(var), ((NBTTagShort)tag).func_150289_e(), type, stacksize));
            return true;
        } else if (tag instanceof NBTTagInt) {
            nbt.func_74768_a(var, (int)this.applyValue(nbt.func_74762_e(var), ((NBTTagInt)tag).func_150287_d(), type, stacksize));
            return true;
        } else if (tag instanceof NBTTagLong) {
            nbt.func_74772_a(var, (long)this.applyValue(nbt.func_74763_f(var), ((NBTTagLong)tag).func_150291_c(), type, stacksize));
            return true;
        } else if (tag instanceof NBTTagFloat) {
            nbt.func_74776_a(var, (float)this.applyValue(nbt.func_74760_g(var), ((NBTTagFloat)tag).func_150288_h(), type, stacksize));
            return true;
        } else if (tag instanceof NBTTagDouble) {
            nbt.func_74780_a(var, this.applyValue(nbt.func_74769_h(var), ((NBTTagDouble)tag).func_150286_g(), type, stacksize));
            return true;
        } else {
            nbt.func_74782_a(var, tag);
        }
        return true;
    }

    private double applyValue(double old, double v, byte type, int stacksize) {
        switch (type) {
            case 1: {
                return old + v / (double)stacksize;
            }
            case 2: {
                return Math.max(old, v);
            }
            case 3: {
                return Math.min(old, v);
            }
        }
        return v;
    }
}

