/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script;

import cd4017be.lib.script.Context;
import cd4017be.lib.script.Module;
import cd4017be.lib.script.Parameters;
import cd4017be.lib.script.Script;
import cd4017be.lib.script.obj.Array;
import cd4017be.lib.script.obj.Error;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Nil;
import cd4017be.lib.script.obj.Number;
import cd4017be.lib.script.obj.Text;
import cd4017be.lib.script.obj.Vector;
import cd4017be.lib.util.Stack;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import javax.script.ScriptException;

public class Function {
    private static final int TICK_LIMIT = 262144;
    private static final int REC_LIMIT = 64;
    public static final byte gloc = 0;
    public static final byte gvar = 1;
    public static final byte sloc = 2;
    public static final byte svar = 3;
    public static final byte cst_N = 4;
    public static final byte cst_T = 5;
    public static final byte cst_true = 6;
    public static final byte cst_false = 7;
    public static final byte cst_nil = 8;
    public static final byte go = 9;
    public static final byte goif = 10;
    public static final byte goifn = 11;
    public static final byte call = 12;
    public static final byte gosucc = 13;
    public static final byte arr_get = 14;
    public static final byte arr_set = 15;
    public static final byte arr_l = 16;
    public static final byte arr_pack = 17;
    public static final byte vec_pack = 18;
    public static final byte text_pack = 19;
    public static final byte add = 20;
    public static final byte sub = 21;
    public static final byte mul = 22;
    public static final byte div = 23;
    public static final byte neg = 24;
    public static final byte inv = 25;
    public static final byte mod = 26;
    public static final byte eq = 27;
    public static final byte neq = 28;
    public static final byte ls = 29;
    public static final byte nls = 30;
    public static final byte gr = 31;
    public static final byte ngr = 32;
    public static final byte and = 33;
    public static final byte or = 34;
    public static final byte nand = 35;
    public static final byte nor = 36;
    public static final byte xor = 37;
    public static final byte xnor = 38;
    public static final byte form = 39;
    public static final byte clear = 40;
    public static final byte iterate = 41;
    public static final byte end = 42;
    public static final byte gofail = 43;
    public static final byte pow = 44;
    public static final byte not = 45;
    private final byte[] code;
    public final int Nparam;
    public final int lineOfs;
    public final int Nstack;
    public final boolean hasReturn;
    public final String name;
    private final short[] codeIndices;
    private final short[] lineNumbers;
    public Script script;

    public Function(int param, int stack, int lineOfs, byte[] code, boolean ret, String name, HashMap<Short, Short> lines) {
        this.Nparam = param;
        this.Nstack = stack;
        this.lineOfs = lineOfs;
        this.code = code;
        this.hasReturn = ret;
        this.name = name;
        this.lineNumbers = new short[lines.size()];
        int i = 0;
        for (short s : lines.keySet()) {
            this.lineNumbers[i++] = s;
        }
        Arrays.sort(this.lineNumbers);
        this.codeIndices = new short[this.lineNumbers.length];
        for (i = 0; i < this.lineNumbers.length; ++i) {
            this.codeIndices[i] = lines.get(this.lineNumbers[i]);
        }
    }

    public Function(String name, DataInputStream dis) throws IOException {
        this.name = name;
        int i = dis.readByte();
        this.Nparam = i & 0x7F;
        this.hasReturn = (i & 0x80) != 0;
        this.Nstack = dis.readByte() & 0xFF;
        this.code = new byte[dis.readShort() & 0xFFFF];
        dis.read(this.code);
        this.lineOfs = dis.readShort() & 0xFFFF;
        i = dis.readShort();
        this.lineNumbers = new short[i];
        this.codeIndices = new short[i];
        for (int j = 0; j < i; ++j) {
            this.codeIndices[j] = dis.readShort();
            this.lineNumbers[j] = dis.readShort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IOperand apply(Parameters param) throws ScriptException {
        if (param.param.length != this.Nparam) {
            throw new ScriptException("wrong number of parameters!", this.name, this.lineOfs);
        }
        Stack<IOperand> stack = new Stack<IOperand>(this.Nstack);
        stack.fill(param.param);
        ByteBuffer code = ByteBuffer.wrap(this.code);
        int tc = 262144;
        try {
            block55: while (code.hasRemaining()) {
                if (--tc < 0) {
                    throw this.err(new Exception("ran for more than 262144 cycles: infinite loop?"), code);
                }
                switch (code.get()) {
                    case 0: {
                        IOperand a = (IOperand)stack.get(code.get());
                        stack.add(a == null ? Nil.NIL : a.onCopy());
                        break;
                    }
                    case 1: {
                        String name = Function.getName(code, false);
                        Module m = name.indexOf(46) < 0 ? this.script : this.script.context;
                        stack.add(m.read(name).onCopy());
                        break;
                    }
                    case 2: {
                        stack.set(code.get(), (IOperand)stack.rem());
                        break;
                    }
                    case 3: {
                        String name = Function.getName(code, false);
                        IOperand a = (IOperand)stack.rem();
                        if (name.indexOf(46) < 0) {
                            this.script.variables.put(name, a);
                            break;
                        }
                        this.script.context.assign(name, a);
                        break;
                    }
                    case 4: {
                        stack.add(new Number(code.getDouble()));
                        break;
                    }
                    case 5: {
                        stack.add(new Text(Function.getName(code, true)));
                        break;
                    }
                    case 6: {
                        stack.add(Number.TRUE);
                        break;
                    }
                    case 7: {
                        stack.add(Number.FALSE);
                        break;
                    }
                    case 8: {
                        stack.add(Nil.NIL);
                        break;
                    }
                    case 9: {
                        code.position(code.getShort() & 0xFFFF);
                        break;
                    }
                    case 10: {
                        int pos = code.getShort() & 0xFFFF;
                        if (!((IOperand)stack.rem()).asBool()) continue block55;
                        code.position(pos);
                        break;
                    }
                    case 11: {
                        int pos = code.getShort() & 0xFFFF;
                        if (((IOperand)stack.rem()).asBool()) continue block55;
                        code.position(pos);
                        break;
                    }
                    case 13: {
                        int pos = code.getShort() & 0xFFFF;
                        if (((IOperand)stack.rem()).isError()) continue block55;
                        code.position(pos);
                        break;
                    }
                    case 43: {
                        int pos = code.getShort() & 0xFFFF;
                        if (!((IOperand)stack.rem()).isError()) continue block55;
                        code.position(pos);
                        break;
                    }
                    case 12: {
                        IOperand a;
                        Context c = this.script.context;
                        String name = Function.getName(code, false);
                        byte n = code.get();
                        boolean doRet = (n & 0x80) != 0;
                        try {
                            if (++c.recursion > 64) {
                                throw new Exception("more than 64 recursive function calls");
                            }
                            IOperand[] param1 = new IOperand[n & 0x7F];
                            stack.drain(param1);
                            Module m = name.indexOf(46) < 0 ? this.script : c;
                            a = m.invoke(name, new Parameters(param1));
                            if (!doRet) continue block55;
                            stack.add(a);
                            continue block55;
                        }
                        catch (Exception e) {
                            ScriptException se = this.err(e, code);
                            c.LOG.error(Context.ERROR, "failed operation '" + name + "' in script " + this.script.fileName, (Throwable)se);
                            if (!doRet) continue block55;
                            stack.add(new Error("failed operation '" + name + "' @ line " + se.getLineNumber() + " in " + se.getFileName()));
                            continue block55;
                        }
                        finally {
                            --c.recursion;
                            continue block55;
                        }
                    }
                    case 14: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(a.get(b));
                        break;
                    }
                    case 15: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        ((IOperand)stack.rem()).put(a, b);
                        break;
                    }
                    case 16: {
                        stack.add(((IOperand)stack.rem()).len());
                        break;
                    }
                    case 17: {
                        Array list = new Array(code.get() & 0xFF);
                        stack.drain(list.array);
                        stack.add(list);
                        break;
                    }
                    case 18: {
                        IOperand[] arr = new IOperand[code.get() & 0xFF];
                        stack.drain(arr);
                        stack.add(new Vector(arr));
                        break;
                    }
                    case 19: {
                        IOperand[] arr = new IOperand[code.get() & 0xFF];
                        stack.drain(arr);
                        StringBuilder s = new StringBuilder();
                        for (IOperand obj : arr) {
                            s.append(obj.toString());
                        }
                        stack.add(new Text(s.toString()));
                        break;
                    }
                    case 20: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(a.addR(b));
                        break;
                    }
                    case 21: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(a.subR(b));
                        break;
                    }
                    case 22: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(a.mulR(b));
                        break;
                    }
                    case 23: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(a.divR(b));
                        break;
                    }
                    case 24: {
                        stack.add(((IOperand)stack.rem()).neg());
                        break;
                    }
                    case 25: {
                        stack.add(((IOperand)stack.rem()).inv());
                        break;
                    }
                    case 26: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(a.modR(b));
                        break;
                    }
                    case 27: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(a.equals(b) ? Number.TRUE : Number.FALSE);
                        break;
                    }
                    case 28: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(a.equals(b) ? Number.FALSE : Number.TRUE);
                        break;
                    }
                    case 29: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(b.grR(a));
                        break;
                    }
                    case 30: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(a.nlsR(b));
                        break;
                    }
                    case 31: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(a.grR(b));
                        break;
                    }
                    case 32: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(b.nlsR(a));
                        break;
                    }
                    case 33: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(a.and(b));
                        break;
                    }
                    case 34: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(a.or(b));
                        break;
                    }
                    case 35: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(a.nand(b));
                        break;
                    }
                    case 36: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(a.nor(b));
                        break;
                    }
                    case 37: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(a.xor(b));
                        break;
                    }
                    case 38: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(a.xnor(b));
                        break;
                    }
                    case 39: {
                        stack.add(new Text(Function.getName(code, false), (IOperand)stack.rem()));
                        break;
                    }
                    case 40: {
                        stack.setPos(code.get());
                        break;
                    }
                    case 41: {
                        IOperand.OperandIterator it;
                        IOperand a = (IOperand)stack.get();
                        if (a instanceof IOperand.OperandIterator) {
                            it = (IOperand.OperandIterator)a;
                        } else {
                            it = a.iterator();
                            stack.set(it);
                        }
                        int p = code.getShort() & 0xFFFF;
                        if (it.hasNext()) {
                            stack.add((IOperand)it.next());
                            break;
                        }
                        stack.rem();
                        code.position(p);
                        break;
                    }
                    case 42: {
                        stack.setPos(code.get());
                        IOperand a = (IOperand)stack.rem();
                        ((IOperand.OperandIterator)stack.get()).set(a);
                        code.position(code.getShort() & 0xFFFF);
                        break;
                    }
                    case 44: {
                        IOperand b = (IOperand)stack.rem();
                        IOperand a = (IOperand)stack.rem();
                        stack.add(a.powR(b));
                        break;
                    }
                    case 45: {
                        stack.add(((IOperand)stack.rem()).not());
                        continue block55;
                    }
                }
            }
            if (!this.hasReturn) return null;
            IOperand iOperand = (IOperand)stack.rem();
            return iOperand;
        }
        catch (Error e) {
            throw this.err(e, code);
        }
    }

    private ScriptException err(Exception ex, ByteBuffer code) {
        int p = Arrays.binarySearch(this.codeIndices, (short)code.position());
        p = p == -1 ? this.lineOfs : this.lineOfs + this.lineNumbers[p < 0 ? -2 - p : p];
        String msg = ex.getMessage();
        return (ScriptException)new ScriptException(ex.getClass().getSimpleName() + (msg == null ? "" : ": " + msg), this.name, p).initCause(ex);
    }

    public void writeData(DataOutputStream dos) throws IOException {
        dos.writeByte(this.Nparam & 0x7F | (this.hasReturn ? 128 : 0));
        dos.writeByte(this.Nstack);
        dos.writeShort(this.code.length);
        dos.write(this.code);
        dos.writeShort(this.lineOfs);
        dos.writeShort(this.lineNumbers.length);
        for (int i = 0; i < this.lineNumbers.length; ++i) {
            dos.writeShort(this.codeIndices[i]);
            dos.writeShort(this.lineNumbers[i]);
        }
    }

    public int size() {
        return this.code.length;
    }

    public static String getName(ByteBuffer code, boolean big) {
        int n = big ? code.getShort() & 0xFFFF : code.get() & 0xFF;
        byte[] data = new byte[n];
        code.get(data);
        return new String(data);
    }

    public static void putName(ByteBuffer code, String name, boolean big) {
        byte[] data = name.getBytes();
        if (big) {
            code.putShort((short)data.length);
        } else {
            code.put((byte)data.length);
        }
        code.put(data);
    }
}

