/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render;

import cd4017be.lib.util.Orientation;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class Util {
    public static final FloatBuffer[] matrices = new FloatBuffer[16];
    public static final Util instance;
    public static int RenderFrame;

    public static void moveAndOrientToBlock(double x, double y, double z, Orientation o) {
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        FloatBuffer mat = matrices[o.ordinal()];
        mat.rewind();
        GL11.glMultMatrix((FloatBuffer)mat);
    }

    public static void rotateTo(Orientation o) {
        FloatBuffer mat = matrices[o.ordinal()];
        mat.rewind();
        GL11.glMultMatrix((FloatBuffer)mat);
    }

    public static void luminate(TileEntity te, EnumFacing side, int b) {
        BlockPos pos = side == null ? te.func_174877_v() : te.func_174877_v().func_177972_a(side);
        World world = te.func_145831_w();
        IBlockState state = world.func_180495_p(pos);
        int l = world.func_175626_b(pos, Math.max(state.getLightValue((IBlockAccess)world, pos), b));
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(l & 0xFFFF), (float)(l >> 16));
    }

    public static int rotateNormal(int n, ModelRotation rot) {
        switch (rot) {
            default: {
                return n;
            }
            case X0_Y90: {
                return n & 0xFF00 | n << 16 & 0xFF0000 | ~n >> 16 & 0xFF;
            }
            case X0_Y180: {
                return n ^ 0xFF00FF;
            }
            case X0_Y270: {
                return n & 0xFF00 | ~n << 16 & 0xFF0000 | n >> 16 & 0xFF;
            }
            case X90_Y0: {
                return n & 0xFF | ~n << 8 & 0xFF0000 | n >> 8 & 0xFF00;
            }
            case X90_Y90: {
                return n << 16 & 0xFF0000 | n >> 8 & 0xFFFF;
            }
            case X90_Y180: {
                return ~n & 0xFF | n << 8 & 0xFF0000 | n >> 8 & 0xFF00;
            }
            case X90_Y270: {
                return ~n << 16 & 0xFF0000 | (n ^ 0xFF00) >> 8 & 0xFFFF;
            }
            case X180_Y0: {
                return n ^ 0xFFFF00;
            }
            case X180_Y90: {
                return ~n & 0xFF00 | n << 16 & 0xFF0000 | n >> 16 & 0xFF;
            }
            case X180_Y180: {
                return n ^ 0xFFFF;
            }
            case X180_Y270: {
                return ~n & 0xFF00 | ~n << 16 & 0xFF0000 | ~n >> 16 & 0xFF;
            }
            case X270_Y0: {
                return n & 0xFF | n << 8 & 0xFF0000 | ~n >> 8 & 0xFF00;
            }
            case X270_Y90: {
                return n << 16 & 0xFF0000 | ~n >> 8 & 0xFFFF;
            }
            case X270_Y180: {
                return ~n & 0xFF | ~n << 8 & 0xFF0000 | ~n >> 8 & 0xFF00;
            }
            case X270_Y270: 
        }
        return ~n << 16 & 0xFF0000 | (n ^ 0xFF0000) >> 8 & 0xFFFF;
    }

    public static void rotate(int[] data, int px, ModelRotation rot) {
        int py = px + 1;
        int pz = px + 2;
        switch (rot) {
            case X0_Y0: {
                return;
            }
            case X0_Y90: {
                int i = data[pz];
                data[pz] = data[px];
                data[px] = Util.neg(i);
                return;
            }
            case X0_Y180: {
                data[px] = Util.neg(data[px]);
                data[pz] = Util.neg(data[pz]);
                return;
            }
            case X0_Y270: {
                int i = data[px];
                data[px] = data[pz];
                data[pz] = Util.neg(i);
                return;
            }
            case X90_Y0: {
                int i = data[py];
                data[py] = data[pz];
                data[pz] = Util.neg(i);
                return;
            }
            case X90_Y90: {
                int i = data[py];
                data[py] = data[pz];
                data[pz] = data[px];
                data[px] = i;
                return;
            }
            case X90_Y180: {
                int i = data[py];
                data[py] = data[pz];
                data[pz] = i;
                data[px] = Util.neg(data[px]);
                return;
            }
            case X90_Y270: {
                int i = data[px];
                data[px] = Util.neg(data[py]);
                data[py] = data[pz];
                data[pz] = Util.neg(i);
                return;
            }
            case X180_Y0: {
                data[py] = Util.neg(data[py]);
                data[pz] = Util.neg(data[pz]);
                return;
            }
            case X180_Y90: {
                data[py] = Util.neg(data[py]);
                int i = data[pz];
                data[pz] = data[px];
                data[px] = i;
                return;
            }
            case X180_Y180: {
                data[px] = Util.neg(data[px]);
                data[py] = Util.neg(data[py]);
                return;
            }
            case X180_Y270: {
                data[py] = Util.neg(data[py]);
                int i = data[px];
                data[px] = Util.neg(data[pz]);
                data[pz] = Util.neg(i);
                return;
            }
            case X270_Y0: {
                int i = data[pz];
                data[pz] = data[py];
                data[py] = Util.neg(i);
                return;
            }
            case X270_Y90: {
                int i = data[py];
                data[py] = Util.neg(data[pz]);
                data[pz] = data[px];
                data[px] = Util.neg(i);
                return;
            }
            case X270_Y180: {
                int i = data[pz];
                data[pz] = Util.neg(data[py]);
                data[py] = Util.neg(i);
                data[px] = Util.neg(data[px]);
                return;
            }
            case X270_Y270: {
                int i = data[pz];
                data[pz] = Util.neg(data[px]);
                data[px] = data[py];
                data[py] = Util.neg(i);
                return;
            }
        }
    }

    private static int neg(int i) {
        return Float.floatToRawIntBits(1.0f - Float.intBitsToFloat(i));
    }

    private Util() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        ++RenderFrame;
    }

    public static int[] texturedRect(float x, float y, float z, float w, float h, float tx, float ty, float tw, float th) {
        return new int[]{Float.floatToIntBits(x), Float.floatToIntBits(y), Float.floatToIntBits(z), Float.floatToIntBits(tx), Float.floatToIntBits(ty), Float.floatToIntBits(x + w), Float.floatToIntBits(y), Float.floatToIntBits(z), Float.floatToIntBits(tx + tw), Float.floatToIntBits(ty), Float.floatToIntBits(x + w), Float.floatToIntBits(y + h), Float.floatToIntBits(z), Float.floatToIntBits(tx + tw), Float.floatToIntBits(ty + th), Float.floatToIntBits(x), Float.floatToIntBits(y + h), Float.floatToIntBits(z), Float.floatToIntBits(tx), Float.floatToIntBits(ty + th)};
    }

    public static int[] texturedRect(Vec3d p, Vec3d w, Vec3d h, Vec2f t0, Vec2f t1, int color, int light) {
        return new int[]{Float.floatToIntBits((float)p.field_72450_a), Float.floatToIntBits((float)p.field_72448_b), Float.floatToIntBits((float)p.field_72449_c), color, Float.floatToIntBits(t0.field_189982_i), Float.floatToIntBits(t0.field_189983_j), light, Float.floatToIntBits((float)(p.field_72450_a + w.field_72450_a)), Float.floatToIntBits((float)(p.field_72448_b + w.field_72448_b)), Float.floatToIntBits((float)(p.field_72449_c + w.field_72449_c)), color, Float.floatToIntBits(t1.field_189982_i), Float.floatToIntBits(t0.field_189983_j), light, Float.floatToIntBits((float)(p.field_72450_a + w.field_72450_a + h.field_72450_a)), Float.floatToIntBits((float)(p.field_72448_b + w.field_72448_b + h.field_72448_b)), Float.floatToIntBits((float)(p.field_72449_c + w.field_72449_c + h.field_72449_c)), color, Float.floatToIntBits(t1.field_189982_i), Float.floatToIntBits(t1.field_189983_j), light, Float.floatToIntBits((float)(p.field_72450_a + h.field_72450_a)), Float.floatToIntBits((float)(p.field_72448_b + h.field_72448_b)), Float.floatToIntBits((float)(p.field_72449_c + h.field_72449_c)), color, Float.floatToIntBits(t0.field_189982_i), Float.floatToIntBits(t1.field_189983_j), light};
    }

    public static void drawQuad(BufferBuilder b, Vec3d p, Vec3d w, Vec3d h, Vec2f t0, Vec2f t1) {
        b.func_178981_a(Util.texturedRect(p, w, h, t0, t1, -1, 0xF000F0));
    }

    public static Vec2f getUV(TextureAtlasSprite tex, float u, float v) {
        return new Vec2f(tex.func_94214_a((double)u), tex.func_94207_b((double)v));
    }

    public static int[] extractData(BufferBuilder b, int from, int to) {
        int l = b.func_178973_g().func_181719_f();
        int[] arr = new int[(to *= l) - (from *= l)];
        ByteBuffer bb = b.func_178966_f();
        int p = bb.position();
        bb.position(from * 4);
        IntBuffer ib = bb.asIntBuffer();
        ib.get(arr);
        bb.position(p);
        return arr;
    }

    public static void renderToolTip(FontRenderer fr, int x, int y, int tc, int bc, String ... lines) {
        int c1;
        GlStateManager.func_179140_f();
        int width = 0;
        int height = lines.length * fr.field_78288_b;
        int[] w = new int[lines.length];
        for (int i = 0; i < w.length; ++i) {
            int l;
            w[i] = l = fr.func_78256_a(lines[i]);
            if (l <= width) continue;
            width = l;
        }
        int x0 = Float.floatToIntBits(x - width / 2 - 5);
        int x1 = Float.floatToIntBits(x - width / 2);
        int x2 = Float.floatToIntBits(x + width / 2);
        int x3 = Float.floatToIntBits(x + width / 2 + 5);
        int y0 = Float.floatToIntBits(y - height - 5);
        int y1 = Float.floatToIntBits(y - height);
        int y2 = Float.floatToIntBits(y);
        int y3 = Float.floatToIntBits(y + 5);
        int z0 = 0;
        int c0 = c1 = bc & 0xFF00FF00 | bc >> 16 & 0xFF | (bc & 0xFF) << 16;
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179143_c((int)519);
        BufferBuilder buff = Tessellator.func_178181_a().func_178180_c();
        buff.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buff.func_178981_a(new int[]{x1, y2, z0, c1, x2, y2, z0, c1, x2, y1, z0, c1, x1, y1, z0, c1, x1, y1, z0, c1, x2, y1, z0, c1, x3, y0, z0, c0, x0, y0, z0, c0, x2, y1, z0, c1, x2, y2, z0, c1, x3, y3, z0, c0, x3, y0, z0, c0, x2, y2, z0, c1, x1, y2, z0, c1, x0, y3, z0, c0, x3, y3, z0, c0, x1, y2, z0, c1, x1, y1, z0, c1, x0, y0, z0, c0, x0, y3, z0, c0});
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
        for (int i = 0; i < w.length; ++i) {
            fr.func_78276_b(lines[i], x - w[i] / 2, y - height + i * fr.field_78288_b, tc);
        }
        GlStateManager.func_179143_c((int)515);
    }

    static {
        Vec3d X = new Vec3d(1.0, 0.0, 0.0);
        Vec3d Y = new Vec3d(0.0, 1.0, 0.0);
        Vec3d Z = new Vec3d(0.0, 0.0, 1.0);
        for (Orientation o : Orientation.values()) {
            Vec3d x1 = o.rotate(X);
            Vec3d y1 = o.rotate(Y);
            Vec3d z1 = o.rotate(Z);
            FloatBuffer buff = BufferUtils.createFloatBuffer((int)16);
            buff.put(new float[]{(float)x1.field_72450_a, (float)x1.field_72448_b, (float)x1.field_72449_c, 0.0f, (float)y1.field_72450_a, (float)y1.field_72448_b, (float)y1.field_72449_c, 0.0f, (float)z1.field_72450_a, (float)z1.field_72448_b, (float)z1.field_72449_c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
            buff.flip();
            Util.matrices[o.ordinal()] = buff;
        }
        instance = new Util();
        RenderFrame = 0;
    }
}

