/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render;

import cd4017be.lib.Gui.inWorld.InWorldUITile;
import cd4017be.lib.render.Util;
import cd4017be.lib.util.Orientation;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class InWorldUIRenderer
extends TileEntitySpecialRenderer<InWorldUITile> {
    public static final InWorldUIRenderer instance = new InWorldUIRenderer();
    public static final HashMap<Class<?>, Gui<?>> registry = new HashMap();
    public static float TOOLTIP_SCALE = 0.00390625f;
    public RenderItem itemRenderer;

    public static <T extends InWorldUITile> void register(Class<T> tile, Gui<T> gui) {
        registry.put(tile, gui);
        ClientRegistry.bindTileEntitySpecialRenderer(tile, (TileEntitySpecialRenderer)instance);
    }

    private <T extends InWorldUITile> Gui<T> getGui(T tile) {
        return registry.get(tile.getClass());
    }

    public void render(InWorldUITile tile, double x, double y, double z, float t, int destroyStage, float alpha) {
        String s;
        GlStateManager.func_179094_E();
        Util.moveAndOrientToBlock(x, y, z, tile.getOrientation());
        RayTraceResult target = tile.getAimTarget(this.field_147501_a.field_147551_g, t);
        Gui<InWorldUITile> r = this.getGui(tile);
        r.renderComponents(tile, target, t);
        if (target != null && (s = r.getTooltip(tile, target.subHit)) != null) {
            Util.moveAndOrientToBlock(target.field_72307_f.field_72450_a - 1.0, target.field_72307_f.field_72448_b - 1.0, target.field_72307_f.field_72449_c - 1.0, Orientation.fromFacing(target.field_178784_b));
            GlStateManager.func_179152_a((float)(-TOOLTIP_SCALE), (float)(-TOOLTIP_SCALE), (float)(-TOOLTIP_SCALE));
            this.renderToolTip(0, -10, -4144960, -2146435040, s.split("\n"));
        }
        GlStateManager.func_179121_F();
    }

    private void renderToolTip(int x, int y, int tc, int bc, String ... lines) {
        int c1;
        GlStateManager.func_179140_f();
        FontRenderer fr = this.func_147498_b();
        int width = 0;
        int height = lines.length * fr.field_78288_b;
        int[] w = new int[lines.length];
        for (int i = 0; i < w.length; ++i) {
            int l;
            w[i] = l = fr.func_78256_a(lines[i]);
            if (l <= width) continue;
            width = l;
        }
        int x0 = Float.floatToIntBits(x - width / 2 - 5);
        int x1 = Float.floatToIntBits(x - width / 2);
        int x2 = Float.floatToIntBits(x + width / 2);
        int x3 = Float.floatToIntBits(x + width / 2 + 5);
        int y0 = Float.floatToIntBits(y - height - 5);
        int y1 = Float.floatToIntBits(y - height);
        int y2 = Float.floatToIntBits(y);
        int y3 = Float.floatToIntBits(y + 5);
        int z = 0;
        int c0 = c1 = bc & 0xFF00FF00 | bc >> 16 & 0xFF | (bc & 0xFF) << 16;
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179143_c((int)519);
        BufferBuilder buff = Tessellator.func_178181_a().func_178180_c();
        buff.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buff.func_178981_a(new int[]{x1, y2, z, c1, x2, y2, z, c1, x2, y1, z, c1, x1, y1, z, c1, x1, y1, z, c1, x2, y1, z, c1, x3, y0, z, c0, x0, y0, z, c0, x2, y1, z, c1, x2, y2, z, c1, x3, y3, z, c0, x3, y0, z, c0, x2, y2, z, c1, x1, y2, z, c1, x0, y3, z, c0, x3, y3, z, c0, x1, y2, z, c1, x1, y1, z, c1, x0, y0, z, c0, x0, y3, z, c0});
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
        for (int i = 0; i < w.length; ++i) {
            fr.func_78276_b(lines[i], x - w[i] / 2, y - height + i * fr.field_78288_b, tc);
        }
        GlStateManager.func_179143_c((int)515);
    }

    public void func_147499_a(ResourceLocation location) {
        super.func_147499_a(location);
    }

    public static interface Gui<T extends InWorldUITile> {
        public void renderComponents(T var1, RayTraceResult var2, float var3);

        @Nullable
        public String getTooltip(T var1, int var2);
    }
}

