/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render;

import cd4017be.lib.Lib;
import cd4017be.lib.render.IModeledTESR;
import cd4017be.lib.render.SpecialModelLoader;
import cd4017be.lib.render.model.IntArrayModel;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FluidRenderer
implements IModeledTESR {
    private static final String name = "fluid_block";
    public static FluidRenderer instance;
    private IntArrayModel baseModel = new IntArrayModel(0);
    private HashMap<Fluid, IntArrayModel> fluidModels = new HashMap();
    private HashMap<Fluid, Integer> fluidColors = new HashMap();

    public static void register() {
        if (instance == null) {
            instance = new FluidRenderer();
            SpecialModelLoader.instance.tesrs.add(instance);
        }
    }

    public IntArrayModel getFor(Fluid fluid) {
        IntArrayModel m = this.fluidModels.get(fluid);
        if (m != null) {
            return m;
        }
        ResourceLocation res = fluid.getStill();
        if (res == null && (res = fluid.getFlowing()) == null) {
            return null;
        }
        TextureAtlasSprite tex = Minecraft.func_71410_x().func_147117_R().func_110572_b(res.toString());
        if (tex == null) {
            return null;
        }
        m = this.baseModel.withTexture(tex);
        this.fluidModels.put(fluid, m);
        return m;
    }

    public int fluidColor(Fluid fluid) {
        Integer c = this.fluidColors.get(fluid);
        if (c != null) {
            return c;
        }
        int fc = fluid.getColor();
        ResourceLocation res = fluid.getStill();
        if (res == null && (res = fluid.getFlowing()) == null) {
            return fc;
        }
        TextureAtlasSprite tex = Minecraft.func_71410_x().func_147117_R().func_110572_b(res.toString());
        if (tex == null) {
            return fc;
        }
        int r = 0;
        int g = 0;
        int b = 0;
        int n = 0;
        for (int i = 0; i < tex.func_110970_k(); ++i) {
            int[][] nArray = tex.func_147965_a(i);
            int n2 = nArray.length;
            for (int j = 0; j < n2; ++j) {
                int[] arr;
                for (int k : arr = nArray[j]) {
                    int a = k >> 24 & 0xFF;
                    n += a;
                    r += (k >> 16 & 0xFF) * a;
                    g += (k >> 8 & 0xFF) * a;
                    b += (k & 0xFF) * a;
                }
            }
        }
        r = r / n * (fc >> 16 & 0xFF) / 255 & 0xFF;
        g = g / n * (fc >> 8 & 0xFF) / 255 & 0xFF;
        b = b / n * (fc & 0xFF) / 255 & 0xFF;
        fc = r << 16 | g << 8 | b;
        this.fluidColors.put(fluid, fc);
        return fc;
    }

    @Override
    public void bakeModels(IResourceManager manager) {
        try {
            this.baseModel = SpecialModelLoader.loadTESRModel("cd4017be_lib", name);
            this.fluidModels.clear();
            this.fluidColors.clear();
        }
        catch (Exception e) {
            Lib.LOG.error("FluidRenderer failed to load fluid model: fluid_block", (Throwable)e);
        }
    }

    public static int RGBtoBGR(int c) {
        return c & 0xFF00FF00 | c << 16 & 0xFF0000 | c >> 16 & 0xFF;
    }

    public void render(FluidStack stack, TileEntity te, double x, double y, double z, double dxz, double dy) {
        Fluid fluid = stack.getFluid();
        IntArrayModel m = this.getFor(fluid);
        GlStateManager.func_179140_f();
        GlStateManager.Profile.TRANSPARENT_MODEL.func_187373_a();
        m.setColor(FluidRenderer.RGBtoBGR(fluid.getColor(stack)));
        m.setBrightness(te.func_145831_w().func_175626_b(te.func_174877_v(), fluid.getLuminosity(stack)));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GlStateManager.func_179139_a((double)dxz, (double)dy, (double)dxz);
        BufferBuilder t = Tessellator.func_178181_a().func_178180_c();
        t.func_181668_a(7, IntArrayModel.FORMAT);
        t.func_178981_a(m.vertexData);
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.Profile.TRANSPARENT_MODEL.func_187374_b();
    }
}

