/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.network;

import cd4017be.lib.Lib;
import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.IServerPacketReceiver;
import cd4017be.lib.util.DimPos;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class NetworkHandler
implements IServerPacketReceiver,
IPlayerPacketReceiver {
    private static final long LOG_INTERVAL = 1000L;
    public static final Marker NETWORK = MarkerManager.getMarker((String)"Network");
    public final FMLEventChannel eventChannel;
    public final String channel;
    private long lastErr;
    private int errCount;

    protected NetworkHandler(String channel) {
        this.channel = channel;
        this.eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(channel);
        this.eventChannel.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPacketFromServer(FMLNetworkEvent.ClientCustomPacketEvent event) {
        FMLProxyPacket packet = event.getPacket();
        if (!packet.channel().equals(this.channel)) {
            return;
        }
        PacketBuffer buf = new PacketBuffer(packet.payload());
        try {
            this.handleServerPacket(buf);
        }
        catch (Exception e) {
            this.logError(buf, "SERVER", e);
        }
    }

    @SubscribeEvent
    public void onPacketFromClient(FMLNetworkEvent.ServerCustomPacketEvent event) {
        FMLProxyPacket packet = event.getPacket();
        if (!packet.channel().equals(this.channel) || !(event.getHandler() instanceof NetHandlerPlayServer)) {
            return;
        }
        EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        ByteBuf b = packet.payload();
        PacketBuffer buf = b instanceof PacketBuffer ? (PacketBuffer)b : new PacketBuffer(b);
        try {
            this.handlePlayerPacket(buf, player);
        }
        catch (Exception e) {
            this.logError(buf, "PLAYER \"" + player.func_70005_c_() + "\"", e);
        }
    }

    protected void logError(PacketBuffer buf, String source, Exception e) {
        long t = System.currentTimeMillis();
        if (t - this.lastErr < 1000L) {
            ++this.errCount;
        } else {
            this.lastErr = t;
            if (this.errCount > 0) {
                Lib.LOG.error(NETWORK, "suppressed {} additional packet processing errors within the last {}ms", (Object)this.errCount, (Object)(t - this.lastErr));
                this.errCount = 0;
            }
            StringBuilder sb = new StringBuilder("failed processing packet from ").append(source).append(" @").append(this.channel).append(": \n");
            NetworkHandler.printPacketData(sb, buf);
            Lib.LOG.error(NETWORK, (CharSequence)sb, (Throwable)e);
        }
    }

    public static void printPacketData(StringBuilder sb, PacketBuffer p) {
        int r = p.readerIndex();
        int l = p.writerIndex();
        sb.append("read ").append(r).append(" of ").append(l).append(" bytes [");
        for (int i = 0; i < l; ++i) {
            sb.append(String.format("%02X ", p.getUnsignedByte(i)));
        }
        sb.setCharAt(sb.length() - 1, ']');
    }

    public void sendToServer(PacketBuffer pkt) {
        this.eventChannel.sendToServer(new FMLProxyPacket(pkt, this.channel));
    }

    public void sendToPlayer(PacketBuffer pkt, EntityPlayerMP player) {
        this.eventChannel.sendTo(new FMLProxyPacket(pkt, this.channel), player);
    }

    public void sendToPlayers(PacketBuffer pkt, Collection<EntityPlayerMP> players) {
        FMLProxyPacket packet = new FMLProxyPacket(pkt, this.channel);
        for (EntityPlayerMP player : players) {
            this.eventChannel.sendTo(packet, player);
        }
    }

    public void sendToAllNear(PacketBuffer pkt, DimPos pos, double range) {
        this.eventChannel.sendToAllAround(new FMLProxyPacket(pkt, this.channel), new NetworkRegistry.TargetPoint(pos.dimId, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, range));
    }
}

