/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.jvm_utils;

import cd4017be.lib.jvm_utils.ClassAssembler;
import cd4017be.lib.jvm_utils.ClassUtils;
import cd4017be.lib.jvm_utils.ConstantPool;
import cd4017be.lib.jvm_utils.SecurityChecker;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBT2Class
implements Function<String, byte[]> {
    public final NBTTagCompound nbt;
    private final SecurityChecker checker;
    private final Class<?> type;
    private final List<Class<?>> interfaces;
    private short fieldAcc = (short)4098;
    private boolean defConstr = false;

    public NBT2Class(NBTTagCompound nbt, SecurityChecker checker, Class<?> type, Class<?> ... interfaces) {
        this.nbt = nbt;
        this.checker = checker;
        this.type = type;
        this.interfaces = Arrays.asList(interfaces);
    }

    public NBT2Class addConstructor() {
        this.defConstr = true;
        return this;
    }

    public NBT2Class publicFields() {
        this.fieldAcc = (short)4097;
        return this;
    }

    @Override
    public byte[] apply(String name) {
        ConstantPool cpt = new ConstantPool(name, this.type);
        for (NBTBase tag : this.nbt.func_150295_c("cpt", 7)) {
            cpt.add(((NBTTagByteArray)tag).func_150292_c());
        }
        ArrayList<byte[]> fields = new ArrayList<byte[]>();
        ArrayList<byte[]> methods = new ArrayList<byte[]>();
        if (this.defConstr) {
            methods.add(ClassAssembler.DEFAULT_CONSTR);
        }
        for (NBTBase tag : this.nbt.func_150295_c("methods", 7)) {
            methods.add(((NBTTagByteArray)tag).func_150292_c());
        }
        for (Object ni : (Object)this.nbt.func_74759_k("fields")) {
            ByteBuffer b = ByteBuffer.allocate(8);
            b.putShort(this.fieldAcc);
            b.putInt(2, (int)ni);
            fields.add((byte[])b.array().clone());
        }
        byte[] data = ClassAssembler.genClass(this.interfaces, cpt, fields, methods, null);
        this.checker.verify(data);
        return data;
    }

    public UUID getHash() {
        if (this.nbt.func_150297_b("uidM", 4) && this.nbt.func_150297_b("uidL", 4)) {
            return new UUID(this.nbt.func_74763_f("uidM"), this.nbt.func_74763_f("uidL"));
        }
        NBTTagList cpt = this.nbt.func_150295_c("cpt", 7);
        NBTTagList methods = this.nbt.func_150295_c("methods", 7);
        byte[][] data = new byte[cpt.func_74745_c() + methods.func_74745_c()][];
        int i = 0;
        int n = 0;
        for (NBTBase tag : cpt) {
            byte[] byArray = ((NBTTagByteArray)tag).func_150292_c();
            data[i++] = byArray;
            n += byArray.length;
        }
        for (NBTBase tag : methods) {
            byte[] byArray = ((NBTTagByteArray)tag).func_150292_c();
            data[i++] = byArray;
            n += byArray.length;
        }
        int[] fields = this.nbt.func_74759_k("fields");
        ByteBuffer buf = ByteBuffer.allocate(n + fields.length * 4 + 1);
        for (byte[] arr2 : data) {
            buf.put(arr2);
        }
        for (int f : fields) {
            buf.putInt(f);
        }
        buf.put((byte)(this.fieldAcc | (this.defConstr ? 4 : 0)));
        StringBuilder stringBuilder = new StringBuilder(this.type.getSimpleName());
        for (Class<?> c : this.interfaces) {
            stringBuilder.append(',').append(c.getSimpleName());
        }
        UUID uid = ClassUtils.hash(stringBuilder.toString(), buf.array());
        this.nbt.func_74772_a("uidM", uid.getMostSignificantBits());
        this.nbt.func_74772_a("uidL", uid.getLeastSignificantBits());
        return uid;
    }

    public static NBTTagCompound writeNBT(ConstantPool cpt, int[] fields, List<byte[]> methods) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (byte[] arr : methods) {
            list.func_74742_a((NBTBase)new NBTTagByteArray(arr));
        }
        nbt.func_74782_a("methods", (NBTBase)list);
        nbt.func_74783_a("fields", fields);
        list = new NBTTagList();
        int l = cpt.getCount();
        for (int i = 10; i < l; ++i) {
            list.func_74742_a((NBTBase)new NBTTagByteArray(cpt.get(i)));
        }
        nbt.func_74782_a("cpt", (NBTBase)list);
        return nbt;
    }

    public static int[] genFields(List<String> fields, ConstantPool cpt) {
        int[] indices = new int[fields.size()];
        int l = indices.length;
        for (int i = 0; i < l; ++i) {
            String descr = fields.get(i);
            int p = descr.indexOf(32);
            if (p < 0) {
                throw new IllegalArgumentException();
            }
            indices[i] = cpt.putUtf8(descr.substring(p + 1)) << 16 & 0xFFFF0000 | cpt.putUtf8(descr.substring(0, p).replace('.', '/')) & 0xFFFF;
        }
        return indices;
    }

    public static short refField(int field, ConstantPool cpt) {
        return cpt.putFieldMethod((short)2, cpt.putNameType((short)(field >> 16), (short)field), (byte)9);
    }
}

