/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes.mods;

import cd4017be.api.recipes.RecipeModule;
import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.lib.script.Parameters;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Nil;
import java.lang.reflect.Method;
import net.minecraft.item.ItemStack;

public class ImmersiveEngineeringModule
extends RecipeModule {
    public ImmersiveEngineeringModule() {
        super("IE");
        this.mkRcp("AlloyRecipe", "Alloy");
        this.mkRcp("ArcFurnaceRecipe", "Arc");
        this.mkRcp("BlastFurnaceRecipe", "Blast");
        this.mkRcp("BottlingMachineRecipe", "Bottle");
        this.mkRcp("CokeOvenRecipe", "Coke");
        this.mkRcp("CrusherRecipe", "Crush");
        this.mkRcp("FermenterRecipe", "Ferment");
        this.mkRcp("MetalPressRecipe", "Press");
        this.mkRcp("MixerRecipe", "Mix");
        this.mkRcp("RefineryRecipe", "Refine");
        this.mkRcp("SqueezerRecipe", "Squeeze");
        RecipeScriptContext.instance.LOG.info(RecipeScriptContext.SCRIPT, "added ImmersiveEngineering wrapper module");
    }

    private void mkRcp(String name, String id) {
        try {
            Class<?> c = Class.forName("blusunrize.immersiveengineering.api.crafting." + name);
            for (Method m : c.getDeclaredMethods()) {
                if (!m.getName().equals("addRecipe")) continue;
                this.methods.put("add" + id, new AddRecipe(m));
            }
            Method rem = c.getMethod("removeRecipes", ItemStack.class);
            this.methods.put("rem" + id, p -> {
                rem.invoke(null, p.get(0, ItemStack.class));
                return Nil.NIL;
            });
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            RecipeScriptContext.instance.LOG.warn(RecipeScriptContext.SCRIPT, "Problem occoured adding ImmersiveEngineering handler {}: {}", (Object)name, (Object)e.toString());
        }
    }

    private static class AddRecipe
    implements RecipeModule.Handler {
        final Method m;

        AddRecipe(Method m) {
            this.m = m;
        }

        @Override
        public IOperand handle(Parameters param) throws Exception {
            Class<?>[] types = this.m.getParameterTypes();
            Object[] p = new Object[types.length];
            for (int i = 0; i < p.length; ++i) {
                Class<?> t = types[i];
                p[i] = t == Integer.TYPE ? Integer.valueOf(param.getIndex(i)) : (t == Float.TYPE ? Float.valueOf((float)param.getNumber(i)) : (t == Double.TYPE ? Double.valueOf(param.getNumber(i)) : (t == Object[].class && i == p.length - 1 ? param.getArrayOrAll(i) : (t == ItemStack.class && param.has(i) && param.param[i] == Nil.NIL ? ItemStack.field_190927_a : param.get(i, t)))));
            }
            this.m.invoke(null, p);
            return Nil.NIL;
        }
    }
}

