/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.beneath.common.handler;

import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shinoow.beneath.Beneath;
import com.shinoow.beneath.common.handler.OreEntry;
import com.shinoow.beneath.common.util.JsonHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.init.Blocks;

public class BlockDecorationHandler {
    static List<OreEntry> blockdeco = new ArrayList<OreEntry>();

    public static void setupBlockDecoFile() {
        File f = new File("config/beneath/blockdeco.json");
        if (!f.exists()) {
            BlockDecorationHandler.generateDefault(f);
        } else {
            try {
                blockdeco = Streams.stream((Iterable)JsonHelper.ReadArrayFromFile(f)).filter(e -> e != null && e.isJsonObject()).map(e -> new OreEntry(e.getAsJsonObject())).collect(Collectors.toList());
            }
            catch (Exception e2) {
                Beneath.LOGGER.error("An error occurred while reading blockdeco.json, will use the default values instead", (Throwable)e2);
                BlockDecorationHandler.generateDefault(f);
            }
        }
    }

    public static void saveBlockDecoFile() {
        JsonArray l = new JsonArray();
        blockdeco.stream().map(OreEntry::toJson).forEach(j -> l.add((JsonElement)j));
        JsonHelper.WriteToFile(new File("config/beneath/blockdeco.json"), (JsonElement)l);
    }

    private static void generateDefault(File f) {
        OreEntry dirt = new OreEntry(Blocks.field_150346_d.getRegistryName().toString(), 0, Blocks.field_150348_b.getRegistryName().toString(), 0, 33, 24, 0, 256);
        OreEntry gravel = new OreEntry(Blocks.field_150351_n.getRegistryName().toString(), 0, Blocks.field_150348_b.getRegistryName().toString(), 0, 33, 22, 0, 256);
        OreEntry granite = new OreEntry(Blocks.field_150348_b.getRegistryName().toString(), 1, Blocks.field_150348_b.getRegistryName().toString(), 0, 33, 24, 0, 160);
        OreEntry diorite = new OreEntry(Blocks.field_150348_b.getRegistryName().toString(), 3, Blocks.field_150348_b.getRegistryName().toString(), 0, 33, 24, 0, 160);
        OreEntry adesite = new OreEntry(Blocks.field_150348_b.getRegistryName().toString(), 5, Blocks.field_150348_b.getRegistryName().toString(), 0, 33, 24, 0, 160);
        JsonArray list = new JsonArray();
        JsonObject jBlk = new JsonObject();
        dirt.writeToJson(jBlk);
        list.add((JsonElement)jBlk);
        jBlk = new JsonObject();
        gravel.writeToJson(jBlk);
        list.add((JsonElement)jBlk);
        jBlk = new JsonObject();
        granite.writeToJson(jBlk);
        list.add((JsonElement)jBlk);
        jBlk = new JsonObject();
        diorite.writeToJson(jBlk);
        list.add((JsonElement)jBlk);
        jBlk = new JsonObject();
        adesite.writeToJson(jBlk);
        list.add((JsonElement)jBlk);
        blockdeco = Streams.stream((Iterable)list).filter(e -> e != null && e.isJsonObject()).map(e -> new OreEntry(e.getAsJsonObject())).collect(Collectors.toList());
        JsonHelper.WriteToFile(f, (JsonElement)list);
    }

    public static List<OreEntry> getBlockDeco() {
        return blockdeco;
    }
}

