/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.loaders.recipes;

import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.StoneVariantBlock;
import gregtech.common.items.MetaItems;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import supersymmetry.common.blocks.SuSyBlocks;
import supersymmetry.common.blocks.SusyStoneVariantBlock;
import supersymmetry.loaders.SuSyMetaTileEntityLoader;
import supersymmetry.loaders.recipes.CoagulationRecipes;
import supersymmetry.loaders.recipes.FridgeRecipes;
import supersymmetry.loaders.recipes.SuSyMaterialRecipeHandler;
import supersymmetry.loaders.recipes.SusyOreRecipeHandler;
import supersymmetry.loaders.recipes.VulcanizationRecipes;

public class SuSyRecipeLoader {
    public static void init() {
        SuSyMetaTileEntityLoader.init();
        FridgeRecipes.init();
        CoagulationRecipes.init();
        VulcanizationRecipes.init();
        SusyOreRecipeHandler.init();
        SuSyMaterialRecipeHandler.init();
        SuSyRecipeLoader.registerStoneRecipes();
    }

    private static void registerStoneRecipes() {
        EnumMap susyVariantListMap = new EnumMap(SusyStoneVariantBlock.StoneVariant.class);
        for (SusyStoneVariantBlock.StoneVariant stoneVariant : SusyStoneVariantBlock.StoneVariant.values()) {
            SusyStoneVariantBlock block = SuSyBlocks.SUSY_STONE_BLOCKS.get((Object)stoneVariant);
            susyVariantListMap.put(stoneVariant, Arrays.stream(SusyStoneVariantBlock.StoneType.values()).map(arg_0 -> ((SusyStoneVariantBlock)block).getItemVariant(arg_0)).collect(Collectors.toList()));
        }
        List susycobbles = (List)susyVariantListMap.get((Object)SusyStoneVariantBlock.StoneVariant.COBBLE);
        List susysmooths = (List)susyVariantListMap.get((Object)SusyStoneVariantBlock.StoneVariant.SMOOTH);
        EnumMap variantListMap = new EnumMap(StoneVariantBlock.StoneVariant.class);
        for (StoneVariantBlock.StoneVariant shape : StoneVariantBlock.StoneVariant.values()) {
            StoneVariantBlock block = (StoneVariantBlock)MetaBlocks.STONE_BLOCKS.get(shape);
            variantListMap.put(shape, Arrays.stream(StoneVariantBlock.StoneType.values()).map(arg_0 -> ((StoneVariantBlock)block).getItemVariant(arg_0)).collect(Collectors.toList()));
        }
        List list = (List)variantListMap.get(StoneVariantBlock.StoneVariant.COBBLE);
        List smooths = (List)variantListMap.get(StoneVariantBlock.StoneVariant.SMOOTH);
        SuSyRecipeLoader.registerSmoothRecipe(susycobbles, susysmooths);
        SuSyRecipeLoader.registerCobbleRecipe(susysmooths, susycobbles);
        SuSyRecipeLoader.registerCobbleSmashingRecipe(susysmooths, susycobbles);
        SuSyRecipeLoader.registerCobbleSmashingRecipe(smooths, list);
        SuSyRecipeLoader.registerMacerationToStoneDustRecipe();
    }

    private static void registerCobbleRecipe(List<ItemStack> smoothStack, List<ItemStack> cobbleStack) {
        for (int i = 0; i < smoothStack.size(); ++i) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder()).inputs(new ItemStack[]{smoothStack.get(i)})).outputs(new ItemStack[]{cobbleStack.get(i)})).duration(12)).EUt(4)).buildAndRegister();
        }
    }

    private static void registerSmoothRecipe(List<ItemStack> roughStack, List<ItemStack> smoothStack) {
        for (int i = 0; i < roughStack.size(); ++i) {
            ModHandler.addSmeltingRecipe((ItemStack)roughStack.get(i), (ItemStack)smoothStack.get(i), (float)0.1f);
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder()).inputs(new ItemStack[]{roughStack.get(i)})).notConsumable(MetaItems.SHAPE_EXTRUDER_BLOCK.getStackForm())).outputs(new ItemStack[]{smoothStack.get(i)})).duration(24)).EUt(8)).buildAndRegister();
        }
    }

    private static void registerCobbleSmashingRecipe(List<ItemStack> smoothStack, List<ItemStack> cobbleStack) {
        for (int i = 0; i < smoothStack.size(); ++i) {
            ModHandler.addShapedRecipe((String)(smoothStack.get(i).func_82833_r() + "_hammer_smashing"), (ItemStack)cobbleStack.get(i), (Object[])new Object[]{"hS", Character.valueOf('S'), smoothStack.get(i)});
        }
    }

    private static void registerMacerationToStoneDustRecipe() {
        for (SusyStoneVariantBlock.StoneType stoneType : SusyStoneVariantBlock.StoneType.values()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder()).inputs(new ItemStack[]{SuSyBlocks.SUSY_STONE_BLOCKS.get((Object)SusyStoneVariantBlock.StoneVariant.SMOOTH).getItemVariant(stoneType)})).output(OrePrefix.dust, stoneType.getMaterial())).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder()).inputs(new ItemStack[]{SuSyBlocks.SUSY_STONE_BLOCKS.get((Object)SusyStoneVariantBlock.StoneVariant.COBBLE).getItemVariant(stoneType)})).output(OrePrefix.dust, stoneType.getMaterial())).buildAndRegister();
        }
    }
}

