/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.loaders;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.model.StockModel;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.util.DataBlock;
import cam72cam.mod.ModCore;
import cam72cam.mod.entity.EntityRegistry;
import cam72cam.mod.render.EntityRenderer;
import cam72cam.mod.render.IEntityRender;
import cam72cam.mod.render.opengl.RenderState;
import java.lang.reflect.Field;
import java.util.Map;
import supersymmetry.api.SusyLog;
import supersymmetry.common.entities.EntityTunnelBore;
import supersymmetry.integration.immersiverailroading.registry.TunnelBoreDefinition;

public class SuSyIRLoader {
    public static void initDefinitions() {
        try {
            Field jsonLoadersField = DefinitionManager.class.getDeclaredField("stockLoaders");
            jsonLoadersField.setAccessible(true);
            Map stockLoaders = (Map)jsonLoadersField.get(null);
            stockLoaders.put("tunnel_bore", TunnelBoreDefinition::new);
        }
        catch (NoSuchFieldException e) {
            SusyLog.logger.error("Failed to reflect definition manager json loaders", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            SusyLog.logger.error("Failed to instantiate StockLoaderBridge", (Throwable)e);
        }
    }

    public static void initEntities() {
        try {
            Field instanceField = ImmersiveRailroading.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            ModCore.Mod instance = (ModCore.Mod)instanceField.get(ImmersiveRailroading.class);
            EntityRegistry.register((ModCore.Mod)instance, EntityTunnelBore::new, (int)512);
        }
        catch (NoSuchFieldException e) {
            SusyLog.logger.error("Failed to reflect immersive railroading instance", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            SusyLog.logger.error("Failed to access immersive railroading instance", (Throwable)e);
        }
    }

    public static void initEntityRenderers() {
        IEntityRender<EntityMoveableRollingStock> stockRender = new IEntityRender<EntityMoveableRollingStock>(){

            public void render(EntityMoveableRollingStock entity, RenderState state, float partialTicks) {
                StockModel renderer = entity.getDefinition().getModel();
                if (renderer != null) {
                    renderer.renderEntity(entity, state, partialTicks);
                }
            }

            public void postRender(EntityMoveableRollingStock entity, RenderState state, float partialTicks) {
                StockModel renderer = entity.getDefinition().getModel();
                if (renderer != null) {
                    renderer.postRenderEntity(entity, state, partialTicks);
                }
            }
        };
        EntityRenderer.register(EntityTunnelBore.class, (IEntityRender)stockRender);
    }

    @FunctionalInterface
    public static interface StockLoader {
        public EntityRollingStockDefinition apply(String var1, DataBlock var2) throws Exception;
    }
}

