/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.loaders;

import com.google.common.collect.Lists;
import gregtech.api.fluids.FluidState;
import gregtech.api.fluids.GTFluid;
import gregtech.api.fluids.attribute.AttributedFluid;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.util.FluidTooltipUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class SuSyFluidTooltipLoader {
    public static void registerTooltips() {
        Supplier<List> liquidVoidableTooltip = () -> Lists.newArrayList((Object[])new String[]{TextFormatting.YELLOW + I18n.func_135052_a((String)"susy.fluid.voiding.liquid", (Object[])new Object[0])});
        Supplier<List> gasVoidableTooltip = () -> Lists.newArrayList((Object[])new String[]{TextFormatting.YELLOW + I18n.func_135052_a((String)"susy.fluid.voiding.gas", (Object[])new Object[0])});
        Supplier<List> flammableVoidableTooltip = () -> Lists.newArrayList((Object[])new String[]{TextFormatting.YELLOW + I18n.func_135052_a((String)"susy.fluid.voiding.flammable", (Object[])new Object[0])});
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            GTFluid.GTMaterialFluid gtFluid;
            Material mat;
            if (!(fluid instanceof AttributedFluid)) continue;
            AttributedFluid aFluid = (AttributedFluid)fluid;
            FluidState state = aFluid.getState();
            if (fluid instanceof GTFluid.GTMaterialFluid && (mat = (gtFluid = (GTFluid.GTMaterialFluid)fluid).getMaterial()).hasFlag(MaterialFlags.FLAMMABLE)) {
                FluidTooltipUtil.registerTooltip((Fluid)fluid, flammableVoidableTooltip);
                continue;
            }
            if (state == FluidState.LIQUID) {
                FluidTooltipUtil.registerTooltip((Fluid)fluid, liquidVoidableTooltip);
                continue;
            }
            if (state != FluidState.GAS) continue;
            FluidTooltipUtil.registerTooltip((Fluid)fluid, gasVoidableTooltip);
        }
    }
}

