/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.integration.immersiverailroading.model.part;

import cam72cam.immersiverailroading.model.ModelState;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.mod.math.Vec3d;
import java.util.function.Function;
import supersymmetry.common.entities.EntityTunnelBore;
import supersymmetry.integration.immersiverailroading.model.ModelHelper;
import util.Matrix4;

public class Borer {
    public static final String BORER_COMPONENT_REGEX = ".*BORER*.";
    protected final ModelComponent borer;

    public Borer(ComponentProvider provider, ModelState state, Function<EntityTunnelBore, Float> angle) {
        this.borer = ModelHelper.parseCustomComponent(provider, BORER_COMPONENT_REGEX);
        Vec3d wheelPos = this.borer.center;
        state.push(settings -> settings.add((stock, partialTicks) -> {
            float f;
            Matrix4 matrix4 = new Matrix4().translate(wheelPos.x, wheelPos.y, wheelPos.z);
            if (stock instanceof EntityTunnelBore) {
                EntityTunnelBore bore = (EntityTunnelBore)stock;
                f = ((Float)angle.apply(bore)).floatValue();
            } else {
                f = 0.0f;
            }
            return matrix4.rotate(Math.toRadians(f), 1.0, 0.0, 0.0).translate(-wheelPos.x, -wheelPos.y, -wheelPos.z);
        })).include(this.borer);
    }
}

