/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.integration.immersiverailroading.gui;

import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.gui.container.BaseContainer;
import cam72cam.mod.gui.container.IContainerBuilder;
import cam72cam.mod.gui.container.ServerContainerBuilder;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.item.ItemStackHandler;
import gregtech.common.items.MetaItems;
import supersymmetry.common.entities.EntityTunnelBore;
import supersymmetry.common.item.SuSyMetaItems;

public class TunnelBoreContainer
extends BaseContainer {
    public EntityTunnelBore stock;

    public TunnelBoreContainer(EntityTunnelBore stock) {
        this.stock = stock;
    }

    public void draw(IContainerBuilder container) {
        int currY = 0;
        currY = container.drawTopBar(0, currY, this.stock.getInventoryWidth());
        currY = container.drawSlotBlock((ItemStackHandler)this.stock.cargoItems, this.stock.getBatterySlots() + this.stock.getTrackSlots(), this.stock.getInventoryWidth(), 0, currY);
        currY = container.drawBottomBar(0, currY, this.getSlotsX());
        int rows = this.getBatteryTrackRows();
        int batteriesPerRow = this.stock.getBatterySlots() / this.getBatteryTrackRows();
        int tracksPerRow = this.getSlotsX() - 1 - this.getBatteryTrackRows();
        ItemStack battery = new ItemStack(MetaItems.BATTERY_HULL_LV.getStackForm());
        ItemStack trackSegment = new ItemStack(SuSyMetaItems.TRACK_SEGMENT.getStackForm());
        container.drawTopBar(2, currY, batteriesPerRow);
        container.drawTopBar(batteriesPerRow * 18 + 16, currY, tracksPerRow);
        currY += 7;
        if (container instanceof ServerContainerBuilder) {
            ServerContainerBuilder serverContainerBuilder = (ServerContainerBuilder)container;
            serverContainerBuilder.drawBottomBar(0, 0, 0);
        }
        for (int i = 0; i < rows; ++i) {
            int j;
            for (j = 0; j < batteriesPerRow; ++j) {
                container.drawSlotOverlay(battery, 18 * j + 2, currY);
            }
            for (j = 0; j < tracksPerRow; ++j) {
                container.drawSlotOverlay(trackSegment, batteriesPerRow * 18 + 16 + 18 * j, currY);
            }
            container.drawSlotRow((ItemStackHandler)this.stock.cargoItems, batteriesPerRow * i, batteriesPerRow, 2, currY);
            currY = container.drawSlotRow((ItemStackHandler)this.stock.cargoItems, this.stock.getBatterySlots() + tracksPerRow * i, tracksPerRow, batteriesPerRow * 18 + 16, currY);
        }
        container.drawBottomBar(2, currY, batteriesPerRow);
        currY = container.drawBottomBar(batteriesPerRow * 18 + 16, currY, tracksPerRow);
        container.drawTopBar(0, currY, this.getSlotsX());
        currY += 7;
        if (container instanceof ServerContainerBuilder) {
            ServerContainerBuilder serverContainerBuilder = (ServerContainerBuilder)container;
            serverContainerBuilder.drawBottomBar(0, 0, 0);
        }
        container.drawPlayerInventory(currY, this.stock.getInventoryWidth());
        this.drawName(container, (EntityRollingStock)this.stock);
    }

    public int getSlotsX() {
        return this.stock.getInventoryWidth();
    }

    public int getSlotsY() {
        return (this.stock.getInventorySize() - this.stock.getTrackSlots() - this.stock.getBatterySlots()) / this.stock.getInventoryWidth();
    }

    public int getBatteryTrackRows() {
        return (this.stock.getTrackSlots() + this.stock.getBatterySlots()) / (this.stock.getInventoryWidth() - 1);
    }
}

