/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.storage;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.IPropertyFluidFilter;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.unification.material.Material;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.storage.MetaTileEntityDrum;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import supersymmetry.client.renderer.textures.SusyTextures;
import supersymmetry.mixins.gregtech.MetaTileEntityDrumAccessor;

public class MetaTileEntityPlasticCan
extends MetaTileEntityDrum {
    private final MetaTileEntityDrumAccessor self = (MetaTileEntityDrumAccessor)((Object)this);

    public MetaTileEntityPlasticCan(ResourceLocation metaTileEntityId, @NotNull Material material, int tankSize) {
        super(metaTileEntityId, material, tankSize);
    }

    public MetaTileEntityPlasticCan(ResourceLocation metaTileEntityId, @NotNull IPropertyFluidFilter fluidFilter, int color, int tankSize) {
        super(metaTileEntityId, fluidFilter, false, color, tankSize);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityPlasticCan(this.metaTileEntityId, this.self.getFluidFilter(), this.self.getColor(), this.self.getTankSize());
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        ColourMultiplier multiplier = new ColourMultiplier(ColourRGBA.multiply((int)GTUtility.convertRGBtoOpaqueRGBA_CL((int)this.self.getColor()), (int)GTUtility.convertRGBtoOpaqueRGBA_CL((int)this.getPaintingColorForRendering())));
        SusyTextures.PLASTIC_CAN.render(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)multiplier), this.getFrontFacing());
        SusyTextures.PLASTIC_CAN_OVERLAY.render(renderState, translation, pipeline);
        if (this.self.isAutoOutput()) {
            Textures.STEAM_VENT_OVERLAY.renderSided(EnumFacing.DOWN, renderState, translation, pipeline);
        }
    }
}

