/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.single.steam;

import gregtech.api.capability.IGhostSlotConfigurable;
import gregtech.api.capability.impl.FluidHandlerProxy;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.GhostCircuitItemStackHandler;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.ItemHandlerProxy;
import gregtech.api.capability.impl.NotifiableFluidTank;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.capability.impl.RecipeLogicSteam;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.GhostCircuitSlotWidget;
import gregtech.api.gui.widgets.RecipeProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SteamMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.GTTransferUtils;
import gregtech.client.renderer.ICubeRenderer;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import supersymmetry.api.gui.SusyGuiTextures;
import supersymmetry.api.metatileentity.steam.SuSySteamProgressIndicator;

public class SuSySimpleSteamMetaTileEntity
extends SteamMetaTileEntity
implements IGhostSlotConfigurable {
    protected SuSySteamProgressIndicator progressIndicator;
    protected boolean isBrickedCasing;
    @Nullable
    protected GhostCircuitItemStackHandler circuitInventory;
    protected IItemHandler outputItemInventory;
    protected IFluidHandler outputFluidInventory;
    private IItemHandlerModifiable actualImportItems;

    public SuSySimpleSteamMetaTileEntity(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, SuSySteamProgressIndicator progressIndicator, ICubeRenderer renderer, boolean isBrickedCasing, boolean isHighPressure) {
        super(metaTileEntityId, recipeMap, renderer, isHighPressure);
        this.progressIndicator = progressIndicator;
        this.isBrickedCasing = isBrickedCasing;
        if (this.hasGhostCircuitInventory()) {
            this.circuitInventory = new GhostCircuitItemStackHandler((MetaTileEntity)this);
            this.circuitInventory.addNotifiableMetaTileEntity((MetaTileEntity)this);
        }
        this.initializeInventory();
        this.workableHandler = new RecipeLogicSteam((MetaTileEntity)this, recipeMap, isHighPressure, (IFluidTank)this.steamFluidTank, 1.0);
    }

    public boolean hasGhostCircuitInventory() {
        return true;
    }

    public void setGhostCircuitConfig(int config) {
        if (this.circuitInventory == null || this.circuitInventory.getCircuitValue() == config) {
            return;
        }
        this.circuitInventory.setCircuitValue(config);
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new SuSySimpleSteamMetaTileEntity(this.metaTileEntityId, this.workableHandler.getRecipeMap(), this.progressIndicator, this.renderer, this.isBrickedCasing, this.isHighPressure);
    }

    protected void initializeInventory() {
        super.initializeInventory();
        this.outputItemInventory = new ItemHandlerProxy((IItemHandler)new ItemStackHandler(0), (IItemHandler)this.exportItems);
        this.outputFluidInventory = new FluidHandlerProxy((IFluidHandler)new FluidTankList(false, new IFluidTank[0]), (IFluidHandler)this.exportFluids);
        this.actualImportItems = null;
    }

    public IItemHandlerModifiable getImportItems() {
        if (this.actualImportItems == null) {
            this.actualImportItems = this.circuitInventory == null ? super.getImportItems() : new ItemHandlerList(Arrays.asList(super.getImportItems(), this.circuitInventory));
        }
        return this.actualImportItems;
    }

    protected IItemHandlerModifiable createImportItemHandler() {
        if (this.workableHandler == null) {
            return new ItemStackHandler(0);
        }
        return new NotifiableItemStackHandler((MetaTileEntity)this, this.workableHandler.getRecipeMap().getMaxInputs(), (MetaTileEntity)this, false);
    }

    protected IItemHandlerModifiable createExportItemHandler() {
        if (this.workableHandler == null) {
            return new ItemStackHandler(0);
        }
        return new NotifiableItemStackHandler((MetaTileEntity)this, this.workableHandler.getRecipeMap().getMaxOutputs(), (MetaTileEntity)this, true);
    }

    public FluidTankList createImportFluidHandler() {
        super.createImportFluidHandler();
        if (this.workableHandler == null) {
            return new FluidTankList(false, new IFluidTank[]{this.steamFluidTank});
        }
        IFluidTank[] fluidImports = new IFluidTank[this.workableHandler.getRecipeMap().getMaxFluidInputs() + 1];
        fluidImports[0] = this.steamFluidTank;
        for (int i = 1; i < fluidImports.length; ++i) {
            fluidImports[i] = new NotifiableFluidTank(8000, (MetaTileEntity)this, false);
        }
        return new FluidTankList(false, fluidImports);
    }

    protected FluidTankList createExportFluidHandler() {
        if (this.workableHandler == null) {
            return new FluidTankList(false, new IFluidTank[0]);
        }
        FluidTank[] fluidExports = new FluidTank[this.workableHandler.getRecipeMap().getMaxFluidOutputs()];
        for (int i = 0; i < fluidExports.length; ++i) {
            fluidExports[i] = new NotifiableFluidTank(8000, (MetaTileEntity)this, true);
        }
        return new FluidTankList(false, (IFluidTank[])fluidExports);
    }

    protected boolean isBrickedCasing() {
        return this.isBrickedCasing;
    }

    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return this.createGuiTemplate(entityPlayer).build((IUIHolder)this.getHolder(), entityPlayer);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        if (this.circuitInventory != null) {
            this.circuitInventory.write(data);
        }
        return data;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (this.circuitInventory != null) {
            if (data.func_150297_b("CircuitInventory", 10)) {
                ItemStackHandler legacyCircuitInventory = new ItemStackHandler();
                for (int i = 0; i < legacyCircuitInventory.getSlots(); ++i) {
                    ItemStack stack = legacyCircuitInventory.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    stack = GTTransferUtils.insertItem((IItemHandler)this.importItems, (ItemStack)stack, (boolean)false);
                    this.circuitInventory.setCircuitValueFromStack(stack);
                }
            } else {
                this.circuitInventory.read(data);
            }
        }
    }

    protected ModularUI.Builder createGuiTemplate(EntityPlayer player) {
        RecipeMap recipeMap = this.workableHandler.getRecipeMap();
        int yOffset = 0;
        ModularUI.Builder builder = super.createUITemplate(player);
        this.addRecipeProgressBar(builder, recipeMap, yOffset);
        this.addInventorySlotGroup(builder, this.importItems, this.importFluids, false, yOffset);
        this.addInventorySlotGroup(builder, this.exportItems, this.exportFluids, true, yOffset);
        if (this.exportItems.getSlots() + this.exportFluids.getTanks() <= 9 && this.circuitInventory != null) {
            SlotWidget circuitSlot = new GhostCircuitSlotWidget(this.circuitInventory, 0, 124, 62 + yOffset).setBackgroundTexture(new IGuiTexture[]{GuiTextures.SLOT_STEAM.get(this.isHighPressure), this.getCircuitSlotOverlay()});
            builder.widget((Widget)circuitSlot.setConsumer(this::getCircuitSlotTooltip)).widget((Widget)new ClickButtonWidget(115, 62 + yOffset, 9, 9, "", click -> this.circuitInventory.addCircuitValue(click.isShiftClick ? 5 : 1)).setShouldClientCallback(true).setButtonTexture(SusyGuiTextures.BUTTON_INT_CIRCUIT_PLUS_STEAM.get(this.isHighPressure)).setDisplayFunction(() -> this.circuitInventory.hasCircuitValue() && this.circuitInventory.getCircuitValue() < 32)).widget((Widget)new ClickButtonWidget(115, 71 + yOffset, 9, 9, "", click -> this.circuitInventory.addCircuitValue(click.isShiftClick ? -5 : -1)).setShouldClientCallback(true).setButtonTexture(SusyGuiTextures.BUTTON_INT_CIRCUIT_MINUS_STEAM.get(this.isHighPressure)).setDisplayFunction(() -> this.circuitInventory.hasCircuitValue() && this.circuitInventory.getCircuitValue() > 0));
        }
        return builder;
    }

    protected TextureArea getCircuitSlotOverlay() {
        return SusyGuiTextures.INT_CIRCUIT_OVERLAY_STEAM.get(this.isHighPressure);
    }

    protected void getCircuitSlotTooltip(SlotWidget widget) {
        String configString = this.circuitInventory == null || this.circuitInventory.getCircuitValue() == -1 ? new TextComponentTranslation("gregtech.gui.configurator_slot.no_value", new Object[0]).func_150254_d() : String.valueOf(this.circuitInventory.getCircuitValue());
        widget.setTooltipText("gregtech.gui.configurator_slot.tooltip", new Object[]{configString});
    }

    protected void addRecipeProgressBar(ModularUI.Builder builder, RecipeMap<?> map, int yOffset) {
        int x = 89 - this.progressIndicator.width / 2;
        int y = yOffset + 42 - this.progressIndicator.height / 2;
        builder.widget((Widget)new RecipeProgressWidget(() -> ((RecipeLogicSteam)this.workableHandler).getProgressPercent(), x, y, this.progressIndicator.width, this.progressIndicator.height, this.progressIndicator.progressBarTexture.get(this.isHighPressure), this.progressIndicator.progressMoveType, map));
    }

    protected void addInventorySlotGroup(ModularUI.Builder builder, IItemHandlerModifiable itemHandler, FluidTankList fluidHandler, boolean isOutputs, int yOffset) {
        block12: {
            int i;
            boolean wasGroup;
            int itemsSlotsCount = itemHandler.getSlots();
            int fluidSlotsCount = fluidHandler.getTanks() - (isOutputs ? 0 : 1);
            boolean invertFluids = false;
            if (itemsSlotsCount == 0) {
                int tmp = itemsSlotsCount;
                itemsSlotsCount = fluidSlotsCount;
                fluidSlotsCount = tmp;
                invertFluids = true;
            }
            int[] inputSlotGrid = SuSySimpleSteamMetaTileEntity.determineSlotsGrid(itemsSlotsCount);
            int itemsSlotsLeft = inputSlotGrid[0];
            int itemsSlotsDown = inputSlotGrid[1];
            boolean isVerticalFluid = itemsSlotsDown >= fluidSlotsCount && itemsSlotsLeft < 3;
            int fluidGridHeight = fluidSlotsCount / 3 == 0 ? 1 : fluidSlotsCount / 3;
            int fullGridHeight = itemsSlotsDown + (isVerticalFluid ? 0 : fluidGridHeight);
            if (fullGridHeight >= 3) {
                yOffset += 4;
            }
            int startInputsX = isOutputs ? 89 + this.progressIndicator.width / 2 + 9 : 89 - (this.progressIndicator.width / 2 + 9 + itemsSlotsLeft * 18);
            int startInputsY = yOffset + (isVerticalFluid ? 42 - itemsSlotsDown * 18 / 2 : 42 - ((fluidSlotsCount - 1) / 3 + 1) * 18);
            boolean bl = wasGroup = itemHandler.getSlots() + fluidHandler.getTanks() == 12;
            if (wasGroup) {
                startInputsY -= 9;
            } else if (itemHandler.getSlots() >= 6 && fluidHandler.getTanks() >= 2 && !isOutputs) {
                startInputsY -= 9;
            }
            for (int i2 = 0; i2 < itemsSlotsDown; ++i2) {
                int slotIndex;
                for (int j = 0; j < itemsSlotsLeft && (slotIndex = i2 * itemsSlotsLeft + j) < itemsSlotsCount; ++j) {
                    int x = startInputsX + 18 * j;
                    int y = startInputsY + 18 * i2;
                    this.addSlot(builder, x, y, slotIndex, itemHandler, fluidHandler, invertFluids, isOutputs);
                }
            }
            if (wasGroup) {
                startInputsY += 2;
            }
            if (fluidSlotsCount <= 0 && !invertFluids) break block12;
            if (isVerticalFluid) {
                int startSpecX = isOutputs ? startInputsX + itemsSlotsLeft * 18 : startInputsX - 18;
                for (i = 0; i < fluidSlotsCount; ++i) {
                    this.addSlot(builder, startSpecX, startInputsY + 18 * i, i, itemHandler, fluidHandler, !invertFluids, isOutputs);
                }
            } else {
                int startSpecY = startInputsY + itemsSlotsDown * 18;
                for (i = 0; i < fluidSlotsCount; ++i) {
                    int x = isOutputs ? startInputsX + 18 * (i % 3) : startInputsX + itemsSlotsLeft * 18 - 18 - 18 * (i % 3);
                    int y = startSpecY + i / 3 * 18;
                    this.addSlot(builder, x, y, i, itemHandler, fluidHandler, !invertFluids, isOutputs);
                }
            }
        }
    }

    protected void addSlot(ModularUI.Builder builder, int x, int y, int slotIndex, IItemHandlerModifiable itemHandler, FluidTankList fluidHandler, boolean isFluid, boolean isOutputs) {
        if (!isOutputs && isFluid) {
            ++slotIndex;
        }
        if (!isFluid) {
            builder.widget((Widget)new SlotWidget((IItemHandler)itemHandler, slotIndex, x, y, true, !isOutputs).setBackgroundTexture((IGuiTexture[])this.getOverlaysForSlot(isOutputs, false)));
        } else {
            builder.widget((Widget)new TankWidget((IFluidTank)fluidHandler.getTankAt(slotIndex), x, y, 18, 18).setAlwaysShowFull(true).setBackgroundTexture((IGuiTexture[])this.getOverlaysForSlot(isOutputs, true)).setContainerClicking(true, !isOutputs));
        }
    }

    protected TextureArea[] getOverlaysForSlot(boolean isOutputs, boolean isFluid) {
        return new TextureArea[]{isFluid ? SusyGuiTextures.FLUID_SLOT_STEAM.get(this.isHighPressure) : GuiTextures.SLOT_STEAM.get(this.isHighPressure)};
    }

    protected static int[] determineSlotsGrid(int itemInputsCounts) {
        if (itemInputsCounts == 3) {
            return new int[]{3, 1};
        }
        int slotsLeft = (int)Math.ceil(Math.sqrt(itemInputsCounts));
        int slotsDown = (int)Math.ceil((double)itemInputsCounts / (double)slotsLeft);
        return new int[]{slotsLeft, slotsDown};
    }
}

