/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.single.electric;

import gregtech.api.GTValues;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.capability.impl.RecipeLogicEnergy;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SimpleMachineMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.logic.OverclockingLogic;
import gregtech.api.recipes.recipeproperties.IRecipePropertyStorage;
import gregtech.client.renderer.ICubeRenderer;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import supersymmetry.api.recipes.SuSyRecipeMaps;
import supersymmetry.client.renderer.textures.SusyTextures;

public class MetaTileEntityPhaseSeparator
extends SimpleMachineMetaTileEntity {
    public MetaTileEntityPhaseSeparator(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, SuSyRecipeMaps.PHASE_SEPARATOR, (ICubeRenderer)SusyTextures.PHASE_SEPARATOR_OVERLAY, 1, true);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityPhaseSeparator(this.metaTileEntityId);
    }

    protected RecipeLogicEnergy createWorkable(RecipeMap<?> recipeMap) {
        return new PhaseSeparatorRecipeLogic((MetaTileEntity)this, recipeMap, () -> this.energyContainer);
    }

    protected void reinitializeEnergyContainer() {
        this.energyContainer = new EnergyContainerHandler((MetaTileEntity)this, 0L, 0L, 0L, 0L, 0L){

            public boolean isOneProbeHidden() {
                return true;
            }
        };
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        if (this.workable.getRecipeMap() != null && this.workable.getRecipeMap().getMaxFluidInputs() != 0) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.getTankScalingFunction().apply(this.getTier())}));
        }
    }

    private static class PhaseSeparatorRecipeLogic
    extends RecipeLogicEnergy {
        public PhaseSeparatorRecipeLogic(MetaTileEntity metaTileEntity, RecipeMap<?> recipeMap, Supplier<IEnergyContainer> energyContainer) {
            super(metaTileEntity, recipeMap, energyContainer);
        }

        @NotNull
        public MetaTileEntityPhaseSeparator getMetaTileEntity() {
            return (MetaTileEntityPhaseSeparator)super.getMetaTileEntity();
        }

        protected long getEnergyInputPerSecond() {
            return Integer.MAX_VALUE;
        }

        protected long getEnergyStored() {
            return Integer.MAX_VALUE;
        }

        protected long getEnergyCapacity() {
            return Integer.MAX_VALUE;
        }

        protected boolean drawEnergy(int recipeEUt, boolean simulate) {
            return true;
        }

        public long getMaxVoltage() {
            return 1L;
        }

        protected int @NotNull [] runOverclockingLogic(@NotNull IRecipePropertyStorage propertyStorage, int recipeEUt, long maxVoltage, int recipeDuration, int amountOC) {
            return OverclockingLogic.standardOverclockingLogic((int)1, (long)this.getMaxVoltage(), (int)recipeDuration, (int)amountOC, (double)this.getOverclockingDurationDivisor(), (double)this.getOverclockingVoltageMultiplier());
        }

        public long getMaximumOverclockVoltage() {
            return GTValues.V[1];
        }
    }
}

