/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.single.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.widgets.AdvancedTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtechfoodoption.utils.GTFOUtils;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import supersymmetry.client.renderer.textures.SusyTextures;

public class MetaTileEntityIncinerator
extends TieredMetaTileEntity
implements IControllable {
    private boolean isWorkingEnabled = true;
    private boolean canProgress;
    private boolean hasItems = false;
    private int progress = 0;
    private boolean isClogged = false;
    public final int maxProgress;
    public final int itemsPerRun;
    public static final int UPDATE_CLOGGED = 3488;

    public MetaTileEntityIncinerator(ResourceLocation metaTileEntityId, int tier, int maxProgress, int itemsPerRun) {
        super(metaTileEntityId, tier);
        this.initializeInventory();
        this.maxProgress = maxProgress;
        this.itemsPerRun = itemsPerRun;
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        SusyTextures.INCINERATOR_OVERLAY.renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), true);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityIncinerator(this.metaTileEntityId, this.getTier(), this.maxProgress, this.itemsPerRun);
    }

    protected ModularUI createUI(EntityPlayer entityPlayer) {
        int rowSize = (int)Math.sqrt(this.getInventorySize());
        return this.createUITemplate(entityPlayer, rowSize).build((IUIHolder)this.getHolder(), entityPlayer);
    }

    public void update() {
        super.update();
        if (this.isActive() && this.getOffsetTimer() % 5L == 0L) {
            if (this.getWorld().field_72995_K) {
                this.incineratingParticles();
            } else {
                this.getWorld().func_184133_a(null, this.getPos(), SoundEvents.field_187658_bx, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (!this.getWorld().field_72995_K && this.getOffsetTimer() % 40L == 0L) {
            this.checkClogged();
        }
        if (!this.isClogged && this.isWorkingEnabled && !this.getWorld().field_72995_K && (this.hasItems || this.notifiedItemInputList != null)) {
            this.hasItems = true;
            int startSlot = GTFOUtils.getFirstUnemptyItemSlot((IItemHandler)this.importItems, (int)0);
            if (startSlot == -1) {
                this.hasItems = false;
                this.progress = 0;
                if (this.canProgress) {
                    this.setCanProgress(false);
                }
            } else if (this.energyContainer.removeEnergy(GTValues.V[this.getTier()] / 2L) == -GTValues.V[this.getTier()] / 2L) {
                if (!this.canProgress) {
                    this.setCanProgress(true);
                }
                ++this.progress;
                if (this.progress >= this.maxProgress) {
                    this.importItems.extractItem(startSlot, this.itemsPerRun, false);
                    this.progress = 0;
                }
            } else if (this.canProgress) {
                this.setCanProgress(false);
            }
        }
    }

    public void checkClogged() {
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.getPos().func_177981_b(1), (BlockPos)this.getPos().func_177981_b(8))) {
            IBlockState state = this.getWorld().func_180495_p(pos);
            if (state.func_177230_c().isAir(state, (IBlockAccess)this.getWorld(), pos)) continue;
            this.setClogged(true);
            this.progress = 0;
            return;
        }
        this.setClogged(false);
    }

    public boolean isActive() {
        return this.canProgress && this.isWorkingEnabled && !this.isClogged;
    }

    public void setCanProgress(boolean canProgress) {
        this.canProgress = canProgress;
        this.writeCustomData(GregtechDataCodes.UPDATE_ACTIVE, buf -> buf.writeBoolean(canProgress));
    }

    @SideOnly(value=Side.CLIENT)
    private void incineratingParticles() {
        BlockPos pos = this.getPos();
        double xPos = (double)pos.func_177958_n() + Math.random() / 2.0;
        double yPos = (double)pos.func_177956_o() + 0.5;
        double zPos = (double)pos.func_177952_p() + Math.random() / 2.0;
        double ySpd = 0.1 + Math.random() / 3.0;
        double xSpd = (Math.random() - 0.5) / 3.0;
        double zSpd = (Math.random() - 0.5) / 3.0;
        this.getWorld().func_175688_a(EnumParticleTypes.SMOKE_LARGE, xPos, yPos, zPos, xSpd, ySpd, zSpd, new int[0]);
        this.getWorld().func_175688_a(EnumParticleTypes.SMOKE_LARGE, xPos, yPos, zPos, xSpd, ySpd, zSpd, new int[0]);
    }

    private ModularUI.Builder createUITemplate(EntityPlayer player, int gridSize) {
        int backgroundWidth = gridSize > 6 ? 176 + (gridSize - 6) * 18 : 176;
        int center = backgroundWidth / 2;
        int gridStartX = center - gridSize * 9;
        int inventoryStartX = center - 9 - 72;
        int inventoryStartY = 30 + 18 * gridSize + 12;
        ModularUI.Builder builder = ModularUI.builder((IGuiTexture)GuiTextures.BACKGROUND, (int)backgroundWidth, (int)(30 + 18 * gridSize + 94)).label(10, 5, this.getMetaFullName());
        builder.widget((Widget)new AdvancedTextWidget(10, 18, this::getDisplayText, 0));
        for (int y = 0; y < gridSize; ++y) {
            for (int x = 0; x < gridSize; ++x) {
                int index = y * gridSize + x;
                builder.widget((Widget)new SlotWidget((IItemHandler)this.importItems, index, gridStartX + x * 18, 30 + y * 18, true, true).setBackgroundTexture(new IGuiTexture[]{GuiTextures.SLOT}));
            }
        }
        return builder.bindPlayerInventory(player.field_71071_by, (IGuiTexture)GuiTextures.SLOT, inventoryStartX, inventoryStartY);
    }

    private int getInventorySize() {
        int sizeRoot = 1 + Math.min(9, this.getTier());
        return sizeRoot * sizeRoot;
    }

    protected IItemHandlerModifiable createImportItemHandler() {
        return new NotifiableItemStackHandler((MetaTileEntity)this, this.getInventorySize(), (MetaTileEntity)this, false);
    }

    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    public void setWorkingEnabled(boolean b) {
        this.isWorkingEnabled = b;
        this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(b));
    }

    public void setClogged(boolean b) {
        this.isClogged = b;
        this.writeCustomData(3488, buf -> buf.writeBoolean(b));
    }

    public void getDisplayText(List<ITextComponent> list) {
        list.add((ITextComponent)new TextComponentTranslation(this.isClogged ? "gregtech.multiblock.incinerator.clogged" : "gregtech.multiblock.incinerator.working", new Object[0]));
    }

    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.isWorkingEnabled = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == 3488) {
            this.isClogged = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.UPDATE_ACTIVE) {
            this.canProgress = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data.func_74757_a("workingEnabled", this.isWorkingEnabled);
        data.func_74768_a("progress", this.progress);
        data.func_74757_a("isClogged", this.isClogged);
        data.func_74757_a("canProgress", this.canProgress);
        return super.writeToNBT(data);
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isWorkingEnabled = data.func_74767_n("workingEnabled");
        this.progress = data.func_74762_e("progress");
        this.isClogged = data.func_74767_n("isClogged");
        this.canProgress = data.func_74767_n("canProgress");
    }

    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isWorkingEnabled);
        buf.writeInt(this.progress);
        buf.writeBoolean(this.isClogged);
        buf.writeBoolean(this.canProgress);
    }

    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isWorkingEnabled = buf.readBoolean();
        this.progress = buf.readInt();
        this.isClogged = buf.readBoolean();
        this.canProgress = buf.readBoolean();
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return (T)super.getCapability(capability, side);
    }

    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.max_voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), GTValues.VNF[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.item_storage_capacity", (Object[])new Object[]{this.getInventorySize()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.incinerator.tooltip.1", (Object[])new Object[]{this.itemsPerRun, this.maxProgress}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.incinerator.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.incinerator.tooltip.3", (Object[])new Object[0]));
    }
}

