/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.single.electric;

import gregtech.api.GTValues;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.capability.impl.RecipeLogicEnergy;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SimpleMachineMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.logic.OverclockingLogic;
import gregtech.api.recipes.recipeproperties.IRecipePropertyStorage;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.client.renderer.ICubeRenderer;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import supersymmetry.api.metatileentity.multiblock.ICryogenicProvider;
import supersymmetry.api.metatileentity.multiblock.ICryogenicReceiver;
import supersymmetry.api.recipes.SuSyRecipeMaps;
import supersymmetry.api.recipes.properties.CryogenicEnvironmentProperty;
import supersymmetry.client.renderer.textures.SusyTextures;

public class MetaTileEntityBathCondenser
extends SimpleMachineMetaTileEntity
implements ICryogenicReceiver {
    @Nullable
    private ICryogenicProvider provider;

    public MetaTileEntityBathCondenser(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, SuSyRecipeMaps.BATH_CONDENSER, (ICubeRenderer)SusyTextures.BATH_CONDENSER_OVERLAY, 1, true);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityBathCondenser(this.metaTileEntityId);
    }

    protected RecipeLogicEnergy createWorkable(RecipeMap<?> recipeMap) {
        return new BathCondenserRecipeLogic((MetaTileEntity)this, recipeMap, () -> this.energyContainer);
    }

    protected void reinitializeEnergyContainer() {
        this.energyContainer = new EnergyContainerHandler((MetaTileEntity)this, 0L, 0L, 0L, 0L, 0L){

            public boolean isOneProbeHidden() {
                return true;
            }
        };
    }

    @Override
    @Nullable
    public ICryogenicProvider getCryogenicProvider() {
        return this.provider;
    }

    @Override
    public void setCryogenicProvider(@Nullable ICryogenicProvider cryogenicProvider) {
        AbstractRecipeLogic abstractRecipeLogic;
        this.provider = cryogenicProvider;
        if (this.provider == null && (abstractRecipeLogic = this.workable) instanceof BathCondenserRecipeLogic) {
            BathCondenserRecipeLogic logic = (BathCondenserRecipeLogic)abstractRecipeLogic;
            logic.invalidate();
        }
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        if (this.workable.getRecipeMap() != null && this.workable.getRecipeMap().getMaxFluidInputs() != 0) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.getTankScalingFunction().apply(this.getTier())}));
        }
    }

    private static class BathCondenserRecipeLogic
    extends RecipeLogicEnergy {
        public BathCondenserRecipeLogic(MetaTileEntity tileEntity, RecipeMap<?> recipeMap, Supplier<IEnergyContainer> energyContainer) {
            super(tileEntity, recipeMap, energyContainer);
        }

        @NotNull
        public MetaTileEntityBathCondenser getMetaTileEntity() {
            return (MetaTileEntityBathCondenser)super.getMetaTileEntity();
        }

        public boolean checkRecipe(@NotNull Recipe recipe) {
            if (super.checkRecipe(recipe)) {
                Boolean value = (Boolean)recipe.getProperty((RecipeProperty)CryogenicEnvironmentProperty.getInstance(), null);
                return value == null || value == false || this.getMetaTileEntity().getCryogenicProvider() != null && this.getMetaTileEntity().getCryogenicProvider().isStructureFormed();
            }
            return false;
        }

        protected boolean canProgressRecipe() {
            if (super.canProgressRecipe()) {
                if (this.previousRecipe == null) {
                    return true;
                }
                Boolean value = (Boolean)this.previousRecipe.getProperty((RecipeProperty)CryogenicEnvironmentProperty.getInstance(), null);
                return value == null || value == false || this.getMetaTileEntity().getCryogenicProvider() != null && this.getMetaTileEntity().getCryogenicProvider().isStructureFormed();
            }
            return false;
        }

        protected long getEnergyInputPerSecond() {
            return Integer.MAX_VALUE;
        }

        protected long getEnergyStored() {
            return Integer.MAX_VALUE;
        }

        protected long getEnergyCapacity() {
            return Integer.MAX_VALUE;
        }

        protected boolean drawEnergy(int recipeEUt, boolean simulate) {
            return true;
        }

        public long getMaxVoltage() {
            return 1L;
        }

        protected int @NotNull [] runOverclockingLogic(@NotNull IRecipePropertyStorage propertyStorage, int recipeEUt, long maxVoltage, int recipeDuration, int amountOC) {
            return OverclockingLogic.standardOverclockingLogic((int)1, (long)this.getMaxVoltage(), (int)recipeDuration, (int)amountOC, (double)this.getOverclockingDurationDivisor(), (double)this.getOverclockingVoltageMultiplier());
        }

        public long getMaximumOverclockVoltage() {
            return GTValues.V[1];
        }

        public void invalidate() {
            this.previousRecipe = null;
            this.progressTime = 0;
            this.maxProgressTime = 0;
            this.recipeEUt = 0;
            this.fluidOutputs = null;
            this.itemOutputs = null;
            this.setActive(false);
        }
    }
}

