/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.primitive;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import gregtech.api.GTValues;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapPrimitiveMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.util.GTUtility;
import gregtech.client.particle.VanillaParticleEffects;
import gregtech.client.renderer.CubeRendererState;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.cclop.ColourOperation;
import gregtech.client.renderer.cclop.LightMapOperation;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.metatileentity.multiblock.SuSyMultiblockAbilities;
import supersymmetry.api.recipes.SuSyRecipeMaps;
import supersymmetry.client.renderer.textures.SusyTextures;

public class MetaTileEntityPrimitiveSmelter
extends RecipeMapPrimitiveMultiblockController {
    private static final TraceabilityPredicate SNOW_PREDICATE = new TraceabilityPredicate(bws -> GTUtility.isBlockSnow((IBlockState)bws.getBlockState()));

    public MetaTileEntityPrimitiveSmelter(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, SuSyRecipeMaps.PRIMITIVE_SMELTER);
    }

    protected void initializeAbilities() {
        this.importItems = new ItemHandlerList(this.getAbilities(SuSyMultiblockAbilities.PRIMITIVE_IMPORT_ITEMS));
        this.exportItems = new ItemHandlerList(this.getAbilities(SuSyMultiblockAbilities.PRIMITIVE_EXPORT_ITEMS));
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.initializeAbilities();
    }

    public static IBlockState getCasingState() {
        return ModuleCore.Blocks.MASONRY_BRICK.func_176223_P();
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"BBB", "BBB", "SBS"}).aisle(new String[]{"BBB", "B#B", "B B"}).aisle(new String[]{"BBB", "BCB", "SBS"}).where('B', MetaTileEntityPrimitiveSmelter.states((IBlockState[])new IBlockState[]{MetaTileEntityPrimitiveSmelter.getCasingState()}).setMinGlobalLimited(14).or(MetaTileEntityPrimitiveSmelter.abilities((MultiblockAbility[])new MultiblockAbility[]{SuSyMultiblockAbilities.PRIMITIVE_IMPORT_ITEMS}).setPreviewCount(1)).or(MetaTileEntityPrimitiveSmelter.abilities((MultiblockAbility[])new MultiblockAbility[]{SuSyMultiblockAbilities.PRIMITIVE_EXPORT_ITEMS}).setPreviewCount(1))).where('C', this.selfPredicate()).where('S', MetaTileEntityPrimitiveSmelter.states((IBlockState[])new IBlockState[]{ModuleCore.Blocks.MASONRY_BRICK_SLAB.func_176223_P()})).where('#', MetaTileEntityPrimitiveSmelter.air().or(SNOW_PREDICATE)).where(' ', MetaTileEntityPrimitiveSmelter.air()).build();
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return SusyTextures.MASONRY_BRICK;
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityPrimitiveSmelter(this.metaTileEntityId);
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return SusyTextures.PRIMITIVE_SMELTER_OVERLAY;
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.recipeMapWorkable.isActive(), this.recipeMapWorkable.isWorkingEnabled());
        if (this.recipeMapWorkable.isActive() && this.isStructureFormed()) {
            EnumFacing back = this.getFrontFacing().func_176734_d();
            Matrix4 offset = translation.copy().translate((double)back.func_82601_c(), 0.2, (double)back.func_82599_e());
            CubeRendererState op = (CubeRendererState)Textures.RENDER_STATE.get();
            Textures.RENDER_STATE.set(new CubeRendererState(op.layer, CubeRendererState.PASS_MASK, op.world));
            SusyTextures.SLAG_HOT.renderSided(EnumFacing.UP, renderState, offset, (IVertexOperation[])ArrayUtils.addAll((Object[])pipeline, (Object[])new IVertexOperation[]{new LightMapOperation(240, 240), new ColourOperation(-1)}));
            Textures.RENDER_STATE.set(op);
        }
    }

    public void update() {
        super.update();
        if (this.isActive() && !this.getWorld().field_72995_K) {
            this.damageEntitiesAndBreakSnow();
        }
    }

    private void damageEntitiesAndBreakSnow() {
        BlockPos middlePos = this.getPos();
        middlePos = middlePos.func_177972_a(this.getFrontFacing().func_176734_d());
        this.getWorld().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(middlePos)).forEach(entity -> entity.func_70097_a(DamageSource.field_76371_c, 3.0f));
        if (this.getOffsetTimer() % 10L == 0L) {
            IBlockState state = this.getWorld().func_180495_p(middlePos);
            GTUtility.tryBreakSnow((World)this.getWorld(), (BlockPos)middlePos, (IBlockState)state, (boolean)true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick() {
        if (this.isActive()) {
            VanillaParticleEffects.defaultFrontEffect((MetaTileEntity)this, (float)0.3f, (EnumParticleTypes[])new EnumParticleTypes[]{EnumParticleTypes.SMOKE_LARGE, EnumParticleTypes.FLAME});
            BlockPos pos = this.getPos();
            EnumFacing facing = this.getFrontFacing().func_176734_d();
            float x = (float)facing.func_82601_c() + (float)pos.func_177958_n() + 0.5f;
            float y = (float)facing.func_96559_d() + (float)pos.func_177956_o() + 1.2f + (float)(GTValues.RNG.nextDouble() * 2.0 / 16.0);
            float z = (float)facing.func_82599_e() + (float)pos.func_177952_p() + 0.5f;
            for (int i = 0; i < 4; ++i) {
                double offsetX = (GTValues.RNG.nextDouble() * 2.0 - 1.0) * 0.3;
                double offsetY = (GTValues.RNG.nextDouble() * 2.0 - 1.0) * 0.3;
                double offsetZ = (GTValues.RNG.nextDouble() * 2.0 - 1.0) * 0.3;
                this.getWorld().func_175688_a(EnumParticleTypes.FLAME, (double)x + offsetX, (double)y + offsetY, (double)z + offsetZ, 0.0, 0.0, 0.0, new int[0]);
                if (!(GTValues.RNG.nextDouble() < 0.05)) continue;
                this.getWorld().func_175688_a(EnumParticleTypes.LAVA, (double)x + offsetX, (double)y + offsetY, (double)z + offsetZ, 0.0, 0.0, 0.0, new int[0]);
            }
            if (ConfigHolder.machines.machineSounds && GTValues.RNG.nextDouble() < 0.1) {
                this.getWorld().func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
        }
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    protected boolean openGUIOnRightClick() {
        return false;
    }

    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
    }

    public String getHarvestTool() {
        return "pickaxe";
    }
}

