/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.primitive;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.IPrimitivePump;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.wood.BlockGregPlanks;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import supersymmetry.common.materials.SusyMaterials;

public class MetaTileEntityPrimitiveMudPump
extends MultiblockControllerBase
implements IPrimitivePump {
    private IFluidTank mudTank;
    private int biomeModifier = 0;
    private int hatchModifier = 0;

    public MetaTileEntityPrimitiveMudPump(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
        this.resetTileAbilities();
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityPrimitiveMudPump(this.metaTileEntityId);
    }

    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.getOffsetTimer() % 20L == 0L && this.isStructureFormed()) {
            if (this.biomeModifier == 0) {
                this.biomeModifier = this.getAmount();
            } else if (this.biomeModifier > 0) {
                this.mudTank.fill(SusyMaterials.Mud.getFluid(this.getFluidProduction()), true);
            }
        }
    }

    private int getAmount() {
        Biome biome = this.getWorld().func_180494_b(this.getPos());
        Set biomeTypes = BiomeDictionary.getTypes((Biome)biome);
        if (this.getPos().func_177956_o() < 40 || this.getPos().func_177956_o() > 80) {
            return -1;
        }
        if (!biomeTypes.contains(BiomeDictionary.Type.RIVER) && !biomeTypes.contains(BiomeDictionary.Type.SWAMP)) {
            return -1;
        }
        return 250;
    }

    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    protected boolean openGUIOnRightClick() {
        return false;
    }

    protected void updateFormedValid() {
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.initializeAbilities();
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.resetTileAbilities();
    }

    private void initializeAbilities() {
        List tanks = this.getAbilities(MultiblockAbility.PUMP_FLUID_HATCH);
        if (tanks == null || tanks.size() == 0) {
            tanks = this.getAbilities(MultiblockAbility.EXPORT_FLUIDS);
        }
        if (tanks == null || tanks.size() == 0) {
            this.hatchModifier = 1;
        } else {
            this.hatchModifier = ((IFluidTank)tanks.get(0)).getCapacity() == 8000 ? 2 : 4;
            this.mudTank = (IFluidTank)tanks.get(0);
        }
    }

    private void resetTileAbilities() {
        this.mudTank = new FluidTank(0);
    }

    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"       ", "       ", "       ", "       ", "       ", "       "}).aisle(new String[]{" A   A ", " A   A ", " BBBBB ", " A   A ", " A   A ", " BBBBB "}).aisle(new String[]{"       ", "       ", " BBBBB ", "  CCC  ", "  CCC  ", " BBBBB "}).aisle(new String[]{"       ", "       ", " BBBBB ", "  CCC  ", "  CCC  ", " BBBBB "}).aisle(new String[]{"       ", "       ", " BBBBB ", "  CSC  ", "  CCC  ", " BBBBB "}).aisle(new String[]{" A   A ", " A   A ", " BBBBB ", " A   A ", " A   A ", " BBBBB "}).aisle(new String[]{"       ", "       ", "       ", "       ", "       ", "       "}).where('S', this.selfPredicate()).where('A', MetaTileEntityPrimitiveMudPump.frames((Material[])new Material[]{Materials.TreatedWood})).where('B', MetaTileEntityPrimitiveMudPump.states((IBlockState[])new IBlockState[]{MetaBlocks.PLANKS.getState((Enum)BlockGregPlanks.BlockType.TREATED_PLANK)})).where('C', MetaTileEntityPrimitiveMudPump.states((IBlockState[])new IBlockState[]{MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.BRONZE_BRICKS)}).or(MetaTileEntityPrimitiveMudPump.metaTileEntities((MetaTileEntity[])new MetaTileEntity[]{MetaTileEntities.FLUID_EXPORT_HATCH[0], MetaTileEntities.FLUID_EXPORT_HATCH[1], MetaTileEntities.PUMP_OUTPUT_HATCH}).setExactLimit(1))).where(' ', MetaTileEntityPrimitiveMudPump.any()).build();
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.STEAM_CASING_BRONZE;
    }

    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.PRIMITIVE_PUMP_OVERLAY;
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), true, true);
    }

    public String[] getDescription() {
        return (String[])Stream.of(new String[]{I18n.func_135052_a((String)"gregtech.multiblock.primitive_mud_pump.description", (Object[])new Object[0])}).flatMap(Stream::of).toArray(String[]::new);
    }

    public int getFluidProduction() {
        return this.biomeModifier * this.hatchModifier;
    }
}

