/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.primitive;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.IGhostSlotConfigurable;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.GhostCircuitItemStackHandler;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.PrimitiveRecipeLogic;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.GhostCircuitSlotWidget;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.RecipeProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.ParallelLogicType;
import gregtech.api.metatileentity.multiblock.RecipeMapPrimitiveMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.GTTransferUtils;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.gui.SusyGuiTextures;
import supersymmetry.api.recipes.SuSyRecipeMaps;
import supersymmetry.client.renderer.textures.SusyTextures;
import supersymmetry.common.blocks.BlockCoagulationTankWall;
import supersymmetry.common.blocks.SuSyBlocks;

public class MetaTileEntityCoagulationTank
extends RecipeMapPrimitiveMultiblockController
implements IGhostSlotConfigurable {
    @Nullable
    protected GhostCircuitItemStackHandler circuitInventory;
    private IItemHandlerModifiable actualImportItems;
    public int size;

    public MetaTileEntityCoagulationTank(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, SuSyRecipeMaps.COAGULATION_RECIPES);
        this.recipeMapWorkable = new ParallelablePrimitiveMultiblockRecipeLogic(this, SuSyRecipeMaps.COAGULATION_RECIPES);
        this.circuitInventory = new GhostCircuitItemStackHandler((MetaTileEntity)this);
        this.circuitInventory.addNotifiableMetaTileEntity((MetaTileEntity)this);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityCoagulationTank(this.metaTileEntityId);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"XXX", "XXX", "XXX"}).aisle(new String[]{"XXX", "XIX", "X#X"}).setRepeatable(1, 4).aisle(new String[]{"XXX", "XSX", "XXX"}).where('X', MetaTileEntityCoagulationTank.states((IBlockState[])new IBlockState[]{MetaTileEntityCoagulationTank.getCasingState()}).or(MetaTileEntityCoagulationTank.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_ITEMS, MultiblockAbility.IMPORT_FLUIDS}))).where('#', MetaTileEntityCoagulationTank.air()).where('I', MetaTileEntityCoagulationTank.isIndicatorPredicate()).where('S', this.selfPredicate()).build();
    }

    public static TraceabilityPredicate isIndicatorPredicate() {
        return new TraceabilityPredicate(blockWorldState -> {
            if (MetaTileEntityCoagulationTank.air().test(blockWorldState)) {
                blockWorldState.getMatchContext().increment("tankLength", 1);
                return true;
            }
            return false;
        });
    }

    protected static IBlockState getCasingState() {
        return SuSyBlocks.COAGULATION_TANK_WALL.getState(BlockCoagulationTankWall.CoagulationTankWallType.WOODEN_COAGULATION_TANK_WALL);
    }

    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, world, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.coagulation_tank.tooltip.1", (Object[])new Object[0]));
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return SusyTextures.WOODEN_COAGULATION_TANK_WALL;
    }

    protected ModularUI.Builder createUITemplate(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.builder((IGuiTexture)GuiTextures.PRIMITIVE_BACKGROUND, (int)176, (int)166);
        builder.label(6, 6, this.getMetaFullName());
        builder.widget((Widget)new RecipeProgressWidget(() -> ((PrimitiveRecipeLogic)this.recipeMapWorkable).getProgressPercent(), 76, 41, 20, 15, GuiTextures.PRIMITIVE_BLAST_FURNACE_PROGRESS_BAR, ProgressWidget.MoveType.HORIZONTAL, SuSyRecipeMaps.COAGULATION_RECIPES));
        builder.widget((Widget)new SlotWidget((IItemHandler)this.importItems, 0, 30, 30, true, true).setBackgroundTexture(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT}));
        builder.widget((Widget)new SlotWidget((IItemHandler)this.importItems, 1, 48, 30, true, true).setBackgroundTexture(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT}));
        builder.widget((Widget)new TankWidget((IFluidTank)this.importFluids.getTankAt(1), 30, 48, 18, 18).setAlwaysShowFull(true).setBackgroundTexture(new IGuiTexture[]{SusyGuiTextures.FLUID_SLOT_PRIMITIVE}).setContainerClicking(true, true));
        builder.widget((Widget)new TankWidget((IFluidTank)this.importFluids.getTankAt(0), 48, 48, 18, 18).setAlwaysShowFull(true).setBackgroundTexture(new IGuiTexture[]{SusyGuiTextures.FLUID_SLOT_PRIMITIVE}).setContainerClicking(true, true));
        builder.widget((Widget)new SlotWidget((IItemHandler)this.exportItems, 0, 106, 39, true, false).setBackgroundTexture(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT}));
        SlotWidget circuitSlot = new GhostCircuitSlotWidget(this.circuitInventory, 0, 124, 62).setBackgroundTexture(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT, SusyGuiTextures.INT_CIRCUIT_OVERLAY_STEAM.get(true)});
        builder.widget((Widget)this.getCircuitSlotTooltip(circuitSlot)).widget((Widget)new ClickButtonWidget(115, 62, 9, 9, "", click -> this.circuitInventory.addCircuitValue(click.isShiftClick ? 5 : 1)).setShouldClientCallback(true).setButtonTexture(SusyGuiTextures.BUTTON_INT_CIRCUIT_PLUS_PRIMITIVE).setDisplayFunction(() -> this.circuitInventory.hasCircuitValue() && this.circuitInventory.getCircuitValue() < 32)).widget((Widget)new ClickButtonWidget(115, 71, 9, 9, "", click -> this.circuitInventory.addCircuitValue(click.isShiftClick ? -5 : -1)).setShouldClientCallback(true).setButtonTexture(SusyGuiTextures.BUTTON_INT_CIRCUIT_MINUS_PRIMITIVE).setDisplayFunction(() -> this.circuitInventory.hasCircuitValue() && this.circuitInventory.getCircuitValue() > 0));
        return builder.bindPlayerInventory(entityPlayer.field_71071_by, (IGuiTexture)GuiTextures.PRIMITIVE_SLOT, 0);
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.recipeMapWorkable.isActive(), this.recipeMapWorkable.isWorkingEnabled());
    }

    public void update() {
        super.update();
        if (this.getOffsetTimer() % 5L == 0L && this.isStructureFormed()) {
            for (IFluidTank tank : this.getAbilities(MultiblockAbility.IMPORT_FLUIDS)) {
                if (tank.getFluid() == null) continue;
                NonNullList fluidStacks = NonNullList.func_191196_a();
                int toFill = this.importFluids.getTankAt(0).getCapacity() - this.importFluids.getTankAt(0).getFluidAmount();
                int amount = Math.min(tank.getFluidAmount(), toFill);
                fluidStacks.add((Object)new FluidStack(tank.getFluid().getFluid(), amount));
                if (!GTTransferUtils.addFluidsToFluidHandler((IMultipleTankHandler)this.importFluids, (boolean)true, (List)fluidStacks)) continue;
                GTTransferUtils.addFluidsToFluidHandler((IMultipleTankHandler)this.importFluids, (boolean)false, (List)fluidStacks);
                tank.drain(amount, true);
            }
            for (int i = 0; i < this.exportItems.getSlots(); ++i) {
                ItemStack stack = this.exportItems.getStackInSlot(i);
                this.exportItems.setStackInSlot(i, GTTransferUtils.insertItem((IItemHandler)new ItemHandlerList(this.getAbilities(MultiblockAbility.EXPORT_ITEMS)), (ItemStack)stack, (boolean)false));
            }
            this.fillInternalTankFromFluidContainer();
        }
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.size = (Integer)context.getOrDefault("tankLength", (Object)1);
    }

    protected void initializeAbilities() {
        super.initializeAbilities();
    }

    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.PRIMITIVE_PUMP_OVERLAY;
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    public boolean hasGhostCircuitInventory() {
        return true;
    }

    public void setGhostCircuitConfig(int config) {
        if (this.circuitInventory == null || this.circuitInventory.getCircuitValue() == config) {
            return;
        }
        this.circuitInventory.setCircuitValue(config);
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    protected SlotWidget getCircuitSlotTooltip(SlotWidget widget) {
        String configString = this.circuitInventory == null || this.circuitInventory.getCircuitValue() == -1 ? new TextComponentTranslation("gregtech.gui.configurator_slot.no_value", new Object[0]).func_150254_d() : String.valueOf(this.circuitInventory.getCircuitValue());
        return widget.setTooltipText("gregtech.gui.configurator_slot.tooltip", new Object[]{configString});
    }

    protected void initializeInventory() {
        super.initializeInventory();
        this.actualImportItems = null;
    }

    public IItemHandlerModifiable getImportItems() {
        if (this.actualImportItems == null) {
            this.actualImportItems = this.circuitInventory == null ? super.getImportItems() : new ItemHandlerList(Arrays.asList(super.getImportItems(), this.circuitInventory));
        }
        return this.actualImportItems;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("size", this.size);
        if (this.circuitInventory != null) {
            this.circuitInventory.write(data);
        }
        return data;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.size = data.func_74762_e("size");
        if (this.circuitInventory != null) {
            if (data.func_150297_b("CircuitInventory", 10)) {
                ItemStackHandler legacyCircuitInventory = new ItemStackHandler();
                for (int i = 0; i < legacyCircuitInventory.getSlots(); ++i) {
                    ItemStack stack = legacyCircuitInventory.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    stack = GTTransferUtils.insertItem((IItemHandler)this.importItems, (ItemStack)stack, (boolean)false);
                    this.circuitInventory.setCircuitValueFromStack(stack);
                }
            } else {
                this.circuitInventory.read(data);
            }
        }
    }

    public class ParallelablePrimitiveMultiblockRecipeLogic
    extends PrimitiveRecipeLogic {
        public ParallelablePrimitiveMultiblockRecipeLogic(RecipeMapPrimitiveMultiblockController tileEntity, RecipeMap<?> recipeMap) {
            super(tileEntity, recipeMap);
        }

        public int getParallelLimit() {
            return ((MetaTileEntityCoagulationTank)this.getMetaTileEntity()).size;
        }

        protected long getMaxParallelVoltage() {
            return 2147432767L;
        }

        @NotNull
        public ParallelLogicType getParallelLogicType() {
            return ParallelLogicType.MULTIPLY;
        }
    }
}

