/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.electric;

import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockMultiblockCasing;
import gregtech.common.blocks.BlockTurbineCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.StoneVariantBlock;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import supersymmetry.api.recipes.SuSyRecipeMaps;
import supersymmetry.client.renderer.textures.SusyTextures;
import supersymmetry.common.blocks.BlockDrillHead;
import supersymmetry.common.blocks.SuSyBlocks;

public class MetaTileEntityMiningDrill
extends RecipeMapMultiblockController {
    protected BlockPos targetBlock = null;

    public MetaTileEntityMiningDrill(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, SuSyRecipeMaps.MINING_DRILL_RECIPES);
        this.recipeMapWorkable = new IndustrialDrillWorkableHandler(this, true);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityMiningDrill(this.metaTileEntityId);
    }

    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"               ", "     DDDDD     ", "     DDDDD     ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}).aisle(new String[]{"               ", "   DDDDDDDDD   ", "   DDDDDDDDD   ", "    BB   BB    ", "    BB   BB    ", "    BB   BB    ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}).aisle(new String[]{"               ", "  DDDDDDDDDDD  ", "  DDDDDDDDDDD  ", "    BB   BB    ", "    BB   BB    ", "    BB   BB    ", "     BB BB     ", "     BB BB     ", "     BB BB     ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}).aisle(new String[]{"               ", " DDDDDDDDDDDDD ", " DDDDDDDDDDDDD ", "               ", "               ", "               ", "     BB BB     ", "     BB BB     ", "     BB BB     ", "     BB BB     ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}).aisle(new String[]{"               ", " DDDDDDDDDDDDD ", " DDDDDDDDDDDDD ", " BB         BB ", " BB         BB ", " BB         BB ", "               ", "       E       ", "     BBEBB     ", "     AAEAA     ", "       E       ", "       E       ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}).aisle(new String[]{"               ", "DDDDDD   DDDDDD", "DDDDDD   DDDDDD", " BB         BB ", " BB         BB ", " BB         BB ", "  BB       BB  ", "  BB   E   BB  ", "  BBBAAAAABBB  ", "   BAAACAAAB   ", "     GGCGG     ", "     BGEGB     ", "     BGAGB     ", "     B   B     ", "     B   B     ", "     BB  B     ", "     B B B     ", "     B  BB     ", "     B   B     "}).aisle(new String[]{"               ", "DDDDD     DDDDD", "DDDDD     DDDDD", "      AAA      ", "      BAB      ", "      BAB      ", "  BB  BAB  BB  ", "  BB  BAB  BB  ", "  BBBAAAAABBB  ", "   BAACCCAAB   ", "     GCCCG     ", "     GCCCG     ", "     GGCGG     ", "               ", "               ", "         B     ", "      ACA      ", "     BAAA      ", "               "}).aisle(new String[]{"       H       ", "DDDDD  F  DDDDD", "DDDDD  C  DDDDD", "      ACA      ", "      ACA      ", "      ACA      ", "      ACA      ", "    EEACAEE    ", "    EAACAAE    ", "    ECCCCCE    ", "    ECCCCCE    ", "    EECCCEE    ", "     AGGGA     ", "       C       ", "       C       ", "       C       ", "     BCCCB     ", "      AAA      ", "               "}).aisle(new String[]{"               ", "DDDDD     DDDDD", "DDDDD     DDDDD", "      AAA      ", "      BSB      ", "      BAB      ", "  BB  BAB  BB  ", "  BB  BAB  BB  ", "  BBBAAAAABBB  ", "   BAACCCAAB   ", "     GCCCG     ", "     GCCCG     ", "     GGCGG     ", "               ", "               ", "     B         ", "      ACA      ", "      AAAB     ", "               "}).aisle(new String[]{"               ", "DDDDDD   DDDDDD", "DDDDDD   DDDDDD", " BB         BB ", " BB         BB ", " BB         BB ", "  BB       BB  ", "  BB   E   BB  ", "  BBBAAAAABBB  ", "   BAAACAAAB   ", "     GGCGG     ", "     BGEGB     ", "     BGAGB     ", "     B   B     ", "     B   B     ", "     B  BB     ", "     B B B     ", "     BB  B     ", "     B   B     "}).aisle(new String[]{"               ", " DDDDDDDDDDDDD ", " DDDDDDDDDDDDD ", " BB         BB ", " BB         BB ", " BB         BB ", "               ", "       E       ", "     BBEBB     ", "     AAEAA     ", "       E       ", "       E       ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}).aisle(new String[]{"               ", " DDDDDDDDDDDDD ", " DDDDDDDDDDDDD ", "               ", "               ", "               ", "     BB BB     ", "     BB BB     ", "     BB BB     ", "     BB BB     ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}).aisle(new String[]{"               ", "  DDDDDDDDDDD  ", "  DDDDDDDDDDD  ", "    BB   BB    ", "    BB   BB    ", "    BB   BB    ", "     BB BB     ", "     BB BB     ", "     BB BB     ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}).aisle(new String[]{"               ", "   DDDDDDDDD   ", "   DDDDDDDDD   ", "    BB   BB    ", "    BB   BB    ", "    BB   BB    ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}).aisle(new String[]{"               ", "     DDDDD     ", "     DDDDD     ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               "}).where('S', this.selfPredicate()).where('A', MetaTileEntityMiningDrill.states((IBlockState[])new IBlockState[]{MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.STEEL_SOLID)})).where('B', MetaTileEntityMiningDrill.frames((Material[])new Material[]{Materials.Steel}).or(this.autoAbilities(true, true, true, true, true, true, false))).where('C', MetaTileEntityMiningDrill.states((IBlockState[])new IBlockState[]{MetaBlocks.TURBINE_CASING.getState((Enum)BlockTurbineCasing.TurbineCasingType.STEEL_GEARBOX)})).where('D', MetaTileEntityMiningDrill.states((IBlockState[])new IBlockState[]{((StoneVariantBlock)MetaBlocks.STONE_BLOCKS.get(StoneVariantBlock.StoneVariant.SMOOTH)).getState((Enum)StoneVariantBlock.StoneType.CONCRETE_LIGHT)})).where('E', MetaTileEntityMiningDrill.states((IBlockState[])new IBlockState[]{MetaBlocks.BOILER_CASING.getState((Enum)BlockBoilerCasing.BoilerCasingType.STEEL_PIPE)})).where('F', MetaTileEntityMiningDrill.states((IBlockState[])new IBlockState[]{SuSyBlocks.DRILL_HEAD.getState(BlockDrillHead.DrillHeadType.STEEL)})).where('G', MetaTileEntityMiningDrill.states((IBlockState[])new IBlockState[]{MetaBlocks.MULTIBLOCK_CASING.getState((Enum)BlockMultiblockCasing.MultiblockCasingType.GRATE_CASING)})).where('H', this.depositPredicate()).where(' ', MetaTileEntityMiningDrill.any()).build();
    }

    public TraceabilityPredicate autoAbilities(boolean checkEnergyIn, boolean checkMaintenance, boolean checkItemIn, boolean checkItemOut, boolean checkFluidIn, boolean checkFluidOut, boolean checkMuffler) {
        TraceabilityPredicate predicate = super.autoAbilities(checkMaintenance, checkMuffler);
        if (checkEnergyIn) {
            predicate = predicate.or(MetaTileEntityMiningDrill.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY}).setMinGlobalLimited(1).setMaxGlobalLimited(2).setPreviewCount(1));
        }
        if (checkItemIn && this.recipeMap.getMaxInputs() > 0) {
            predicate = predicate.or(MetaTileEntityMiningDrill.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS}).setMaxGlobalLimited(2).setPreviewCount(1));
        }
        if (checkItemOut && this.recipeMap.getMaxOutputs() > 0) {
            predicate = predicate.or(MetaTileEntityMiningDrill.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_ITEMS}).setMaxGlobalLimited(2).setPreviewCount(1));
        }
        if (checkFluidIn && this.recipeMap.getMaxFluidInputs() > 0) {
            predicate = predicate.or(MetaTileEntityMiningDrill.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS}).setMaxGlobalLimited(2).setPreviewCount(1));
        }
        if (checkFluidOut && this.recipeMap.getMaxFluidOutputs() > 0) {
            predicate = predicate.or(MetaTileEntityMiningDrill.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_FLUIDS}).setMaxGlobalLimited(2).setPreviewCount(1));
        }
        return predicate;
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return Textures.SOLID_STEEL_CASING;
    }

    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return SusyTextures.MINING_DRILL_OVERLAY;
    }

    public boolean isMultiblockPartWeatherResistant(@Nonnull IMultiblockPart part) {
        return true;
    }

    @Nonnull
    protected TraceabilityPredicate depositPredicate() {
        return new TraceabilityPredicate(blockWorldState -> {
            this.targetBlock = blockWorldState.getPos();
            if (this.isStructureFormed()) {
                this.inputInventory.setStackInSlot(0, GTUtility.toItem((IBlockState)this.getWorld().func_180495_p(this.targetBlock)));
            }
            return true;
        });
    }

    protected void initializeAbilities() {
        super.initializeAbilities();
        this.inputInventory = new NotifiableItemStackHandler((MetaTileEntity)this, 1, (MetaTileEntity)this, false);
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        if (this.targetBlock != null) {
            this.inputInventory.setStackInSlot(0, GTUtility.toItem((IBlockState)this.getWorld().func_180495_p(this.targetBlock)));
        }
    }

    public void invalidateStructure() {
        this.inputInventory.setStackInSlot(0, ItemStack.field_190927_a);
        this.targetBlock = null;
        super.invalidateStructure();
    }

    public boolean canBeDistinct() {
        return false;
    }

    public boolean getIsWeatherOrTerrainResistant() {
        return true;
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(TooltipHelper.RAINBOW_SLOW + I18n.func_135052_a((String)"gregtech.machine.perfect_oc", (Object[])new Object[0]));
    }

    public boolean allowsExtendedFacing() {
        return false;
    }

    public boolean allowsFlip() {
        return true;
    }

    protected static class IndustrialDrillWorkableHandler
    extends MultiblockRecipeLogic {
        public IndustrialDrillWorkableHandler(RecipeMapMultiblockController tileEntity, boolean hasPerfectOC) {
            super(tileEntity, hasPerfectOC);
        }

        public MetaTileEntityMiningDrill getMetaTileEntity() {
            return (MetaTileEntityMiningDrill)super.getMetaTileEntity();
        }

        protected boolean setupAndConsumeRecipeInputs(Recipe recipe, IItemHandlerModifiable importInventory) {
            MetaTileEntityMiningDrill drill;
            boolean result = super.setupAndConsumeRecipeInputs(recipe, importInventory);
            if (result && !((GTRecipeInput)recipe.getInputs().get(0)).isNonConsumable() && (drill = this.getMetaTileEntity()) != null) {
                drill.getWorld().func_175655_b(drill.targetBlock, false);
            }
            return result;
        }
    }
}

