/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.electric;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.metatileentity.multiblock.SuSyPredicates;
import supersymmetry.api.recipes.SuSyRecipeMaps;
import supersymmetry.api.recipes.properties.CoilingCoilTemperatureProperty;
import supersymmetry.common.blocks.BlockCoolingCoil;
import supersymmetry.common.blocks.SuSyBlocks;
import supersymmetry.common.metatileentities.SuSyMetaTileEntities;

public class MetaTileEntityMagneticRefrigerator
extends RecipeMapMultiblockController {
    private int temperature;

    public MetaTileEntityMagneticRefrigerator(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, SuSyRecipeMaps.COOLING_RECIPES);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityMagneticRefrigerator(this.metaTileEntityId);
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, (boolean)this.isStructureFormed()).setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.getEnergyContainer()).addEnergyTierLine((int)GTUtility.getTierByVoltage((long)this.recipeMapWorkable.getMaxVoltage())).addCustom(tl -> {
            if (this.isStructureFormed()) {
                TextComponentString heatString = TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.RED, (String)(TextFormattingUtil.formatNumbers((long)this.temperature) + "K"));
                tl.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.blast_furnace.max_temperature", (Object[])new Object[]{heatString}));
            }
        }).addParallelsLine(this.recipeMapWorkable.getParallelLimit()).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgressPercent());
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        Object type = context.get("CoolingCoilType");
        this.temperature = type instanceof BlockCoolingCoil.CoolingCoilType ? ((BlockCoolingCoil.CoolingCoilType)((Object)type)).coilTemperature : BlockCoolingCoil.CoolingCoilType.MANGANESE_IRON_ARSENIC_PHOSPHIDE.coilTemperature;
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.temperature = Integer.MAX_VALUE;
    }

    public boolean checkRecipe(@NotNull Recipe recipe, boolean consumeIfSuccess) {
        return this.temperature <= (Integer)recipe.getProperty((RecipeProperty)CoilingCoilTemperatureProperty.getInstance(), (Object)0);
    }

    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"XXX", "CCC", "CCC", "XXX"}).aisle(new String[]{"XXX", "C#C", "C#C", "XXX"}).aisle(new String[]{"XSX", "CCC", "CCC", "XXX"}).where('S', this.selfPredicate()).where('X', MetaTileEntityMagneticRefrigerator.states((IBlockState[])new IBlockState[]{this.getCasingState()}).setMinGlobalLimited(10).or(this.autoAbilities(true, true, true, true, true, true, false))).where('C', SuSyPredicates.coolingCoils()).where('#', MetaTileEntityMagneticRefrigerator.air()).build();
    }

    @NotNull
    protected IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.ALUMINIUM_FROSTPROOF);
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.FROST_PROOF_CASING;
    }

    public boolean canBeDistinct() {
        return true;
    }

    public List<MultiblockShapeInfo> getMatchingShapes() {
        ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
        MultiblockShapeInfo.Builder builder = MultiblockShapeInfo.builder().aisle(new String[]{"XEM", "CCC", "CCC", "XXX"}).aisle(new String[]{"XXD", "C#C", "C#C", "XXX"}).aisle(new String[]{"ISO", "CCC", "CCC", "XXX"}).where('X', MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.ALUMINIUM_FROSTPROOF)).where('S', (MetaTileEntity)SuSyMetaTileEntities.MAGNETIC_REFRIGERATOR, EnumFacing.SOUTH).where('#', Blocks.field_150350_a.func_176223_P()).where('E', (MetaTileEntity)MetaTileEntities.ENERGY_INPUT_HATCH[2], EnumFacing.NORTH).where('I', (MetaTileEntity)MetaTileEntities.ITEM_IMPORT_BUS[1], EnumFacing.SOUTH).where('O', (MetaTileEntity)MetaTileEntities.ITEM_EXPORT_BUS[1], EnumFacing.SOUTH).where('D', (MetaTileEntity)MetaTileEntities.FLUID_EXPORT_HATCH[1], EnumFacing.EAST).where('M', () -> ConfigHolder.machines.enableMaintenance ? MetaTileEntities.MAINTENANCE_HATCH : MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.INVAR_HEATPROOF), EnumFacing.NORTH);
        Arrays.stream(BlockCoolingCoil.CoolingCoilType.values()).sorted(Comparator.comparingInt(entry -> -entry.coilTemperature)).forEach(entry -> shapeInfo.add(builder.where('C', SuSyBlocks.COOLING_COIL.getState((Enum)entry)).build()));
        return shapeInfo;
    }

    @NotNull
    public List<ITextComponent> getDataInfo() {
        List list = super.getDataInfo();
        list.add(new TextComponentTranslation("gregtech.multiblock.magnetic_refrigerator.min_temperature", new Object[]{new TextComponentTranslation(TextFormattingUtil.formatNumbers((long)this.temperature) + "K", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE))}));
        return list;
    }
}

