/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.electric;

import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.ParallelLogicType;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.util.RelativeDirection;
import gregtech.api.util.TextComponentUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.capability.impl.NoEnergyMultiblockRecipeLogic;
import supersymmetry.api.recipes.SuSyRecipeMaps;
import supersymmetry.client.renderer.textures.SusyTextures;
import supersymmetry.common.blocks.BlockSerpentine;
import supersymmetry.common.blocks.SuSyBlocks;
import supersymmetry.common.metatileentities.SuSyMetaTileEntities;

public class MetaTileEntityHeatRadiator
extends RecipeMapMultiblockController {
    public static final int MIN_RADIUS = 1;
    public static final int MIN_HEIGHT = 1;
    private int sDist = 0;
    private int bDist = 0;
    private int area;

    public MetaTileEntityHeatRadiator(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, SuSyRecipeMaps.HEAT_RADIATOR_RECIPES);
        this.recipeMapWorkable = new ParallelableNoEnergyMultiblockRecipeLogic(this);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityHeatRadiator(this.metaTileEntityId);
    }

    protected BlockPattern createStructurePattern() {
        if (this.getWorld() != null) {
            this.updateStructureDimensions();
        }
        if (this.sDist < 1) {
            this.sDist = 1;
        }
        if (this.bDist < 1) {
            this.bDist = 1;
        }
        return FactoryBlockPattern.start((RelativeDirection)RelativeDirection.RIGHT, (RelativeDirection)RelativeDirection.FRONT, (RelativeDirection)RelativeDirection.UP).aisle(new String[]{this.rowPattern(rowType.BOTTOM, this.sDist)}).aisle(new String[]{this.rowPattern(rowType.MIDDLE, this.sDist)}).setRepeatable(1, this.bDist).aisle(new String[]{this.rowPattern(rowType.TOP, this.sDist)}).where('S', this.selfPredicate()).where('A', MetaTileEntityHeatRadiator.states((IBlockState[])new IBlockState[]{this.getCasingState()}).or(this.autoAbilities(false, true, false, false, false, false, false))).where('B', MetaTileEntityHeatRadiator.states((IBlockState[])new IBlockState[]{this.getRadiatorElementState()})).where('C', MetaTileEntityHeatRadiator.states((IBlockState[])new IBlockState[]{this.getCasingState()}).or(this.autoAbilities(false, false, false, false, true, false, false).setExactLimit(1)).or(this.autoAbilities(false, false, false, false, false, true, false).setExactLimit(1))).build();
    }

    private String rowPattern(rowType rowType2, int radius) {
        char other;
        char left;
        char right;
        char center;
        switch (rowType2) {
            case BOTTOM: {
                center = 'S';
                right = 'A';
                left = 'A';
                other = 'A';
                break;
            }
            case MIDDLE: {
                center = 'B';
                right = 'C';
                left = 'C';
                other = 'B';
                break;
            }
            case TOP: {
                center = 'A';
                right = 'A';
                left = 'A';
                other = 'A';
                break;
            }
            case BOTTOM_PREVIEW: {
                center = 'S';
                left = 'M';
                right = 'A';
                other = 'A';
                break;
            }
            case MIDDLE_PREVIEW: {
                center = 'B';
                left = 'I';
                right = 'O';
                other = 'B';
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid rowType: " + (Object)((Object)rowType2));
            }
        }
        StringBuilder rowBuilder = new StringBuilder();
        for (int i = 0; i < radius; ++i) {
            if (i == 0) {
                rowBuilder.append(center);
                continue;
            }
            rowBuilder.append(other);
            rowBuilder.insert(0, other);
        }
        rowBuilder.append(right);
        rowBuilder.insert(0, left);
        return rowBuilder.toString();
    }

    protected boolean updateStructureDimensions() {
        int i;
        World world = this.getWorld();
        EnumFacing front = this.getFrontFacing();
        EnumFacing up = RelativeDirection.UP.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        EnumFacing left = front.func_176732_a(up.func_176740_k());
        EnumFacing right = left.func_176734_d();
        BlockPos.MutableBlockPos lPos = new BlockPos.MutableBlockPos(this.getPos().func_177972_a(up));
        BlockPos.MutableBlockPos rPos = new BlockPos.MutableBlockPos(this.getPos().func_177972_a(up));
        BlockPos.MutableBlockPos uPos = new BlockPos.MutableBlockPos(this.getPos());
        int sDist = 0;
        int bDist = 0;
        for (i = 0; i < 16; ++i) {
            if (!this.isBlockEdge(world, uPos, up)) continue;
            bDist = i;
            break;
        }
        for (i = 1; i < 6; ++i) {
            if (!(this.isBlockEdge(world, lPos, left) & this.isBlockEdge(world, rPos, right))) continue;
            sDist = i;
            break;
        }
        if (sDist < 1 || bDist < 1) {
            this.invalidateStructure();
            return false;
        }
        this.sDist = sDist;
        this.bDist = bDist;
        this.area = bDist * (2 * sDist - 1);
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.UPDATE_STRUCTURE_SIZE, buf -> {
                buf.writeInt(this.sDist);
                buf.writeInt(this.bDist);
                buf.writeInt(this.area);
            });
        }
        return true;
    }

    public void checkStructurePattern() {
        if (!this.isStructureFormed() || this.structurePattern == null) {
            this.reinitializeStructurePattern();
        }
        super.checkStructurePattern();
    }

    public List<MultiblockShapeInfo> getMatchingShapes() {
        ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
        ArrayList<MultiblockShapeInfo.Builder> builders = new ArrayList<MultiblockShapeInfo.Builder>();
        for (int i = 1; i < 6; ++i) {
            MultiblockShapeInfo.Builder builder2 = MultiblockShapeInfo.builder().aisle(new String[]{this.rowPattern(rowType.BOTTOM_PREVIEW, i), this.rowPattern(rowType.MIDDLE_PREVIEW, i), this.rowPattern(rowType.TOP, i)});
            builders.add(builder2);
        }
        for (int j = 2; j < 15; ++j) {
            Object[] rows = new String[j + 2];
            Arrays.fill(rows, this.rowPattern(rowType.MIDDLE, 5));
            rows[0] = this.rowPattern(rowType.BOTTOM_PREVIEW, 5);
            rows[1] = this.rowPattern(rowType.MIDDLE_PREVIEW, 5);
            rows[j + 1] = this.rowPattern(rowType.TOP, 5);
            MultiblockShapeInfo.Builder builder3 = MultiblockShapeInfo.builder().aisle((String[])rows);
            builders.add(builder3);
        }
        builders.forEach(builder -> shapeInfo.add(builder.where('S', (MetaTileEntity)SuSyMetaTileEntities.HEAT_RADIATOR, EnumFacing.SOUTH).where('I', (MetaTileEntity)MetaTileEntities.FLUID_IMPORT_HATCH[1], EnumFacing.SOUTH).where('O', (MetaTileEntity)MetaTileEntities.FLUID_EXPORT_HATCH[1], EnumFacing.SOUTH).where('M', () -> ConfigHolder.machines.enableMaintenance ? MetaTileEntities.MAINTENANCE_HATCH : this.getCasingState(), EnumFacing.SOUTH).where('A', this.getCasingState()).where('C', this.getCasingState()).where('B', this.getRadiatorElementState()).build()));
        return shapeInfo;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data.func_74768_a("sDist", this.sDist);
        data.func_74768_a("bDist", this.bDist);
        data.func_74768_a("area", this.area);
        return super.writeToNBT(data);
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.sDist = data.func_74762_e("sDist");
        this.bDist = data.func_74762_e("bDist");
        this.area = data.func_74762_e("area");
        this.reinitializeStructurePattern();
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeInt(this.sDist);
        buf.writeInt(this.bDist);
        buf.writeInt(this.area);
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.sDist = buf.readInt();
        this.bDist = buf.readInt();
        this.area = buf.readInt();
        this.reinitializeStructurePattern();
    }

    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_STRUCTURE_SIZE) {
            this.sDist = buf.readInt();
            this.bDist = buf.readInt();
            this.area = buf.readInt();
        } else if (dataId == GregtechDataCodes.WORKABLE_ACTIVE) {
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.scheduleRenderUpdate();
        }
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, (boolean)this.isStructureFormed()).setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgressPercent());
        if (this.isStructureFormed()) {
            TextComponentString componentParallelAmount = TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.DARK_PURPLE, (String)String.valueOf(this.area));
            TextComponentTranslation componentParallelAmountBase = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.machine.heat_radiator.parallel", (Object[])new Object[]{componentParallelAmount});
            TextComponentTranslation componentParallelAmountHover = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.machine.heat_radiator.parallel_hover", (Object[])new Object[0]);
            textList.add(TextComponentUtil.setHover((ITextComponent)componentParallelAmountBase, (ITextComponent[])new ITextComponent[]{componentParallelAmountHover}));
        }
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.heat_radiator.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.heat_radiator.tooltip.2", (Object[])new Object[0]));
    }

    public boolean isBlockEdge(@Nonnull World world, @Nonnull BlockPos.MutableBlockPos pos, @Nonnull EnumFacing direction) {
        return world.func_180495_p((BlockPos)pos.func_189536_c(direction)) == this.getCasingState() || world.func_175625_s((BlockPos)pos) instanceof MetaTileEntityHolder;
    }

    public IBlockState getRadiatorElementState() {
        return SuSyBlocks.SERPENTINE.getState(BlockSerpentine.SerpentineType.BASIC);
    }

    public IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.STEEL_SOLID);
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return Textures.SOLID_STEEL_CASING;
    }

    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return SusyTextures.RADIATOR_OVERLAY;
    }

    private class ParallelableNoEnergyMultiblockRecipeLogic
    extends NoEnergyMultiblockRecipeLogic {
        public ParallelableNoEnergyMultiblockRecipeLogic(RecipeMapMultiblockController tileEntity) {
            super(tileEntity);
        }

        public int getParallelLimit() {
            return ((MetaTileEntityHeatRadiator)this.getMetaTileEntity()).area;
        }

        protected long getMaxParallelVoltage() {
            return 2147432767L;
        }

        public boolean consumesEnergy() {
            return false;
        }

        @NotNull
        public ParallelLogicType getParallelLogicType() {
            return ParallelLogicType.MULTIPLY;
        }
    }

    private static enum rowType {
        BOTTOM,
        MIDDLE,
        TOP,
        MIDDLE_PREVIEW,
        BOTTOM_PREVIEW;

    }
}

