/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.BlockInfo;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.StoneVariantBlock;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.SusyLog;
import supersymmetry.api.capability.impl.EvapRecipeLogic;
import supersymmetry.api.recipes.SuSyRecipeMaps;
import supersymmetry.api.recipes.properties.EvaporationEnergyProperty;
import supersymmetry.common.blocks.BlockEvaporationBed;
import supersymmetry.common.blocks.SuSyBlocks;
import supersymmetry.common.metatileentities.SuSyMetaTileEntities;
import supersymmetry.integration.theoneprobe.provider.EvaporationPoolInfoProvider;

public class MetaTileEntityEvaporationPool
extends RecipeMapMultiblockController {
    public static final int MAX_SQUARE_SIDE_LENGTH = 12;
    public static final int structuralDimensionsID = 1051354;
    int columnCount = 1;
    int rowCount = 1;
    int controllerPosition = 0;
    public static final int coilDataID = 10142156;
    public boolean isHeated = false;
    public int[] rollingAverage = new int[20];
    public boolean areCoilsHeating = false;
    public int coilStateMeta = -1;
    public static final int energyValuesID = 10868607;
    int exposedBlocks = 0;
    byte[] wasExposed;
    int kiloJoules = 0;
    int joulesBuffer = 0;
    int tickTimer = 0;
    public boolean isRecipeStalled = false;
    public IHeatingCoilBlockStats coilStats;
    public static final ArrayList<IBlockState> validContainerStates = new ArrayList();

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getControllerPosition() {
        return this.controllerPosition;
    }

    public MetaTileEntityEvaporationPool(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, SuSyRecipeMaps.EVAPORATION_POOL);
        this.recipeMapWorkable = new EvapRecipeLogic(this);
        this.columnCount = 1;
        this.controllerPosition = 0;
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityEvaporationPool(this.metaTileEntityId);
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.isHeated = false;
        this.areCoilsHeating = false;
        this.coilStateMeta = -1;
        this.exposedBlocks = 0;
        this.wasExposed = new byte[0];
        this.kiloJoules = 0;
        this.tickTimer = 0;
        this.isRecipeStalled = false;
        this.writeCustomData(10142156, buf -> {
            buf.writeBoolean(this.isHeated);
            buf.writeBoolean(this.areCoilsHeating);
            buf.writeInt(this.coilStateMeta);
        });
        this.writeCustomData(10868607, buf -> {
            buf.writeInt(this.exposedBlocks);
            buf.func_179250_a(this.wasExposed);
            buf.writeInt(this.kiloJoules);
            buf.writeInt(this.tickTimer);
            buf.writeBoolean(this.isRecipeStalled);
        });
    }

    public boolean updateStructureDimensions() {
        World world = this.getWorld();
        EnumFacing front = this.getFrontFacing();
        EnumFacing back = front.func_176734_d();
        EnumFacing right = front.func_176735_f();
        EnumFacing left = right.func_176734_d();
        BlockPos.MutableBlockPos lPos = new BlockPos.MutableBlockPos(this.getPos().func_177967_a(back, 2));
        BlockPos.MutableBlockPos rPos = new BlockPos.MutableBlockPos(this.getPos().func_177967_a(back, 2));
        BlockPos.MutableBlockPos bPos = new BlockPos.MutableBlockPos(this.getPos().func_177972_a(back));
        int lDist = -1;
        int rDist = -1;
        int bDist = -1;
        for (int i = 1; i < 14; ++i) {
            if (lDist == -1 && !this.isContainerBlock(world, lPos, left)) {
                lDist += i;
            }
            if (rDist == -1 && !this.isContainerBlock(world, rPos, right)) {
                rDist += i;
            }
            if (bDist == -1 && !this.isContainerBlock(world, bPos, back)) {
                bDist += i;
            }
            if (lDist != -1 && rDist != -1 && bDist != -1) break;
        }
        if (lDist < 0 || rDist < 0 || bDist < 1 || lDist + rDist + 1 > 12) {
            this.invalidateStructure();
            return false;
        }
        this.columnCount = rDist + lDist + 1;
        this.rowCount = bDist;
        this.controllerPosition = lDist;
        this.writeCustomData(1051354, buf -> {
            buf.writeInt(this.columnCount);
            buf.writeInt(this.rowCount);
            buf.writeInt(this.controllerPosition);
        });
        return true;
    }

    public boolean isContainerBlock(@Nonnull World world, @Nonnull BlockPos.MutableBlockPos pos, @Nonnull EnumFacing direction) {
        return validContainerStates.contains(world.func_180495_p((BlockPos)pos.func_189536_c(direction)));
    }

    public static String repeat(String s, int count) {
        if (s.length() == 0 || count < 1) {
            return "";
        }
        if (count == 1) {
            return s;
        }
        return new String(new char[count * s.length()]).replace("\u0000", s);
    }

    public String[] centerRowsPattern() {
        String[] containerRows = new String[this.rowCount];
        String[] flooring = new String[]{"G", "C"};
        for (int i = 0; i < this.rowCount; ++i) {
            StringBuilder containerRowBuilder = new StringBuilder(this.columnCount + 4);
            containerRowBuilder.replace(0, 2, "EE");
            for (int j = 2; j < this.columnCount + 2; ++j) {
                if ((j & 1) == 0) {
                    containerRowBuilder.replace(j, j + 1, "C");
                    continue;
                }
                if ((j - 2 & 3) == 1) {
                    containerRowBuilder.replace(j, j + 1, flooring[(i + 1) / this.rowCount]);
                    continue;
                }
                containerRowBuilder.replace(j, j + 1, flooring[~(i * -1) >>> 31]);
            }
            containerRowBuilder.replace(this.columnCount + 2, this.columnCount + 4, "EE");
            containerRows[i] = containerRowBuilder.toString();
        }
        return containerRows;
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.variantActiveBlocks = (List)context.getOrDefault("VABlock", new LinkedList());
        this.replaceVariantBlocksActive(this.isHeated());
    }

    protected BlockPattern createStructurePattern() {
        int currColCount = this.columnCount;
        int currRowCount = this.rowCount;
        int currContPos = this.controllerPosition;
        if (this.getWorld() != null) {
            this.updateStructureDimensions();
        }
        this.initializeCoilStats();
        if (this.columnCount < 1) {
            this.columnCount = 1;
        }
        if (this.rowCount < 1) {
            this.rowCount = 1;
        }
        if (this.wasExposed == null || this.wasExposed.length != this.columnCount * this.rowCount) {
            this.wasExposed = new byte[this.columnCount * this.rowCount];
            this.exposedBlocks = 0;
        }
        if (this.rollingAverage == null) {
            this.rollingAverage = new int[20];
        }
        this.isRecipeStalled = false;
        if (this.structurePattern != null && currColCount == this.columnCount && currRowCount == this.rowCount && currContPos == this.controllerPosition) {
            return this.structurePattern;
        }
        String[] containerRows = this.centerRowsPattern();
        FactoryBlockPattern pattern = FactoryBlockPattern.start().aisle(new String[]{MetaTileEntityEvaporationPool.repeat("E", this.columnCount + 4), MetaTileEntityEvaporationPool.repeat(" ", this.columnCount + 4)}).aisle(new String[]{MetaTileEntityEvaporationPool.repeat("E", this.columnCount + 4), " ".concat(MetaTileEntityEvaporationPool.repeat("E", this.columnCount + 2)).concat(" ")});
        for (int i = 0; i < this.rowCount; ++i) {
            pattern = pattern.aisle(new String[]{containerRows[this.rowCount - 1 - i], " E".concat(MetaTileEntityEvaporationPool.repeat("#", this.columnCount).concat("E "))});
        }
        pattern = pattern.aisle(new String[]{MetaTileEntityEvaporationPool.repeat("E", this.columnCount + 4), " ".concat(MetaTileEntityEvaporationPool.repeat("E", this.columnCount + 2)).concat(" ")}).aisle(new String[]{MetaTileEntityEvaporationPool.repeat("E", this.controllerPosition + 2).concat("S").concat(MetaTileEntityEvaporationPool.repeat("E", this.columnCount + 1 - this.controllerPosition)), MetaTileEntityEvaporationPool.repeat(" ", this.columnCount + 4)}).where('S', this.selfPredicate()).where('E', this.isEdge().or(this.autoAbilities(false, false, true, true, true, true, false).setMaxGlobalLimited(8)).or(MetaTileEntityEvaporationPool.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY}).setMinGlobalLimited(0).setMaxGlobalLimited(2).setPreviewCount(0))).where('G', this.isGround()).where('C', this.isContainer()).where('#', MetaTileEntityEvaporationPool.air()).where(' ', MetaTileEntityEvaporationPool.any());
        return pattern.build();
    }

    protected TraceabilityPredicate isEdge() {
        Supplier<BlockInfo[]> supplier = () -> new BlockInfo[]{new BlockInfo(((StoneVariantBlock)MetaBlocks.STONE_BLOCKS.get(StoneVariantBlock.StoneVariant.SMOOTH)).getState((Enum)StoneVariantBlock.StoneType.CONCRETE_LIGHT))};
        return new TraceabilityPredicate(blockWorldState -> {
            IBlockState state = blockWorldState.getBlockState();
            return state == ((StoneVariantBlock)MetaBlocks.STONE_BLOCKS.get(StoneVariantBlock.StoneVariant.SMOOTH)).getState((Enum)StoneVariantBlock.StoneType.CONCRETE_LIGHT);
        }, supplier);
    }

    protected TraceabilityPredicate isGround() {
        Supplier<BlockInfo[]> supplier = () -> new BlockInfo[]{new BlockInfo(SuSyBlocks.EVAPORATION_BED.getState(BlockEvaporationBed.EvaporationBedType.DIRT))};
        return new TraceabilityPredicate(blockWorldState -> {
            IBlockState state = blockWorldState.getBlockState();
            return this.isValidGround(state);
        }, supplier);
    }

    protected TraceabilityPredicate isContainer() {
        Supplier<BlockInfo[]> supplier = () -> {
            ArrayList<BlockInfo> containerInfo = new ArrayList<BlockInfo>();
            for (BlockEvaporationBed.EvaporationBedType type : BlockEvaporationBed.EvaporationBedType.values()) {
                containerInfo.add(new BlockInfo(SuSyBlocks.EVAPORATION_BED.getState(type)));
            }
            GregTechAPI.HEATING_COILS.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((IHeatingCoilBlockStats)entry.getValue()).getTier())).forEach(entry -> containerInfo.add(new BlockInfo((IBlockState)entry.getKey())));
            BlockInfo[] containerInfoArray = new BlockInfo[containerInfo.size()];
            return containerInfo.toArray(containerInfoArray);
        };
        return new TraceabilityPredicate(blockWorldState -> {
            IBlockState state = blockWorldState.getBlockState();
            int containerStateResult = this.isValidCoil(state);
            if (containerStateResult == -1) {
                return false;
            }
            if (containerStateResult == 1) {
                ((LinkedList)blockWorldState.getMatchContext().getOrPut("VABlock", new LinkedList())).add(blockWorldState.getPos());
            }
            return true;
        }, supplier);
    }

    public List<MultiblockShapeInfo> getMatchingShapes() {
        ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
        MultiblockShapeInfo.Builder builder = MultiblockShapeInfo.builder().aisle(new String[]{"efFIEEEEEE", "          "}).aisle(new String[]{"EEEEEEEEEE", " EEEEEEEE "}).aisle(new String[]{"EECCCGCCEE", " E######E "}).aisle(new String[]{"EECGCGCGEE", " E######E "}).aisle(new String[]{"EECGCGCGEE", " E######E "}).aisle(new String[]{"EECGCGCGEE", " E######E "}).aisle(new String[]{"EECGCGCGEE", " E######E "}).aisle(new String[]{"EECGCCCGEE", " E######E "}).aisle(new String[]{"EEEEEEEEEE", " EEEEEEEE "}).aisle(new String[]{"EEESEEEEEE", "          "}).where('S', (MetaTileEntity)GregTechAPI.MTE_REGISTRY.func_148754_a(SuSyMetaTileEntities.EVAPORATION_POOL_ID), EnumFacing.SOUTH).where('E', ((StoneVariantBlock)MetaBlocks.STONE_BLOCKS.get(StoneVariantBlock.StoneVariant.SMOOTH)).getState((Enum)StoneVariantBlock.StoneType.CONCRETE_LIGHT)).where('G', SuSyBlocks.EVAPORATION_BED.getState(BlockEvaporationBed.EvaporationBedType.DIRT)).where('#', Blocks.field_150350_a.func_176223_P()).where(' ', Blocks.field_150350_a.func_176223_P()).where('e', (MetaTileEntity)MetaTileEntities.ENERGY_INPUT_HATCH[1], EnumFacing.NORTH).where('f', (MetaTileEntity)MetaTileEntities.FLUID_IMPORT_HATCH[1], EnumFacing.NORTH).where('F', (MetaTileEntity)MetaTileEntities.FLUID_EXPORT_HATCH[1], EnumFacing.NORTH).where('I', (MetaTileEntity)MetaTileEntities.ITEM_EXPORT_BUS[1], EnumFacing.NORTH);
        GregTechAPI.HEATING_COILS.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((IHeatingCoilBlockStats)entry.getValue()).getTier())).forEach(entry -> shapeInfo.add(builder.where('C', (IBlockState)entry.getKey()).build()));
        return shapeInfo;
    }

    public int coilPatternCheck(boolean checkGround) {
        String[] centerPattern = this.centerRowsPattern();
        IBlockState targetState = this.coilStateMeta == -1 ? null : MetaBlocks.WIRE_COIL.func_176203_a(this.coilStateMeta);
        EnumFacing right = this.getFrontFacing().func_176735_f();
        EnumFacing back = this.getFrontFacing().func_176734_d();
        BlockPos.MutableBlockPos targetPos = new BlockPos.MutableBlockPos(this.getPos().func_177967_a(back, 2));
        targetPos.func_189534_c(right.func_176734_d(), this.controllerPosition + 1);
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 2; j < this.columnCount + 2; ++j) {
                targetPos.func_189536_c(right);
                if (centerPattern[i].charAt(j) != 'C') {
                    if (!checkGround || this.getWorld().func_180495_p((BlockPos)targetPos) == SuSyBlocks.EVAPORATION_BED.getState(BlockEvaporationBed.EvaporationBedType.DIRT)) continue;
                    return (i * this.columnCount + j - 2) * -1 - 2;
                }
                if (targetState == null) {
                    targetState = this.getWorld().func_180495_p((BlockPos)targetPos);
                    if (MetaBlocks.WIRE_COIL.func_176194_O().func_177619_a().contains((Object)targetState)) {
                        continue;
                    }
                } else if (this.getWorld().func_180495_p((BlockPos)targetPos).toString().equals(targetState.toString())) continue;
                return i * this.columnCount + j - 2;
            }
            targetPos.func_189536_c(back);
            targetPos.func_189534_c(right.func_176734_d(), this.columnCount);
        }
        if (!checkGround) {
            this.coilStateMeta = targetState.func_177230_c().func_176201_c(targetState);
        }
        return -1;
    }

    public boolean handleCoilCheckResult(int result) {
        if (result != -1) {
            this.coilStateMeta = -1;
            this.isHeated = false;
            this.initializeCoilStats();
            return false;
        }
        this.isHeated = true;
        this.initializeCoilStats();
        this.writeCustomData(10142156, buf -> {
            buf.writeBoolean(this.isHeated);
            buf.writeBoolean(this.areCoilsHeating);
            buf.writeInt(this.coilStateMeta);
        });
        return true;
    }

    public void initializeCoilStats() {
        this.coilStats = this.coilStateMeta > -1 ? (IHeatingCoilBlockStats)GregTechAPI.HEATING_COILS.get((Object)MetaBlocks.WIRE_COIL.func_176203_a(this.coilStateMeta)) : null;
    }

    public int isValidCoil(IBlockState state) {
        if (!MetaBlocks.WIRE_COIL.func_176194_O().func_177619_a().contains((Object)state)) {
            return this.isValidGround(state) ? 0 : -1;
        }
        if (this.coilStateMeta == -1) {
            return 1;
        }
        return state.toString().equals(MetaBlocks.WIRE_COIL.func_176203_a(this.coilStateMeta).toString()) ? 1 : 0;
    }

    public boolean isValidGround(IBlockState state) {
        return state == SuSyBlocks.EVAPORATION_BED.getState(BlockEvaporationBed.EvaporationBedType.DIRT);
    }

    public void checkStructurePattern() {
        if (!this.isStructureFormed() || this.structurePattern == null) {
            this.structurePattern = null;
            this.reinitializeStructurePattern();
        }
        super.checkStructurePattern();
        if ((this.tickTimer / 20 & 1) == 0 && this.structurePattern != null && this.structurePattern.getError() == null) {
            this.handleCoilCheckResult(this.coilPatternCheck(false));
        }
    }

    public void addInformation(ItemStack stack, World player, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.evaporation_pool.tooltip.info", (Object[])new Object[]{12, 12}));
        if (TooltipHelper.isShiftDown()) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.evaporation_pool.tooltip.structure_info", (Object[])new Object[]{12, 12}) + "\n");
        }
        super.addInformation(stack, player, tooltip, advanced);
    }

    public BlockPos.MutableBlockPos getCorner(boolean isClose, boolean isLeft) {
        BlockPos.MutableBlockPos corner = new BlockPos.MutableBlockPos(this.getPos());
        EnumFacing back = this.getFrontFacing().func_176734_d();
        EnumFacing left = this.getFrontFacing().func_176746_e();
        corner.func_189536_c(EnumFacing.UP);
        if (isLeft) {
            corner.func_189534_c(left, this.controllerPosition);
        } else {
            corner.func_189534_c(left.func_176734_d(), this.columnCount - this.controllerPosition - 1);
        }
        if (isClose) {
            corner.func_189534_c(back, 2);
        } else {
            corner.func_189534_c(back, this.rowCount + 1);
        }
        return corner;
    }

    public <T extends MultiblockRecipeLogic> void renderFluid(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, IBlockAccess world, EnumFacing frontFacing, T recipeMapWorkable, BlockPos.MutableBlockPos controllerPos) {
        if ((this.tickTimer + 1) % 20 != 0) {
            return;
        }
        SusyLog.logger.atError().log("About to attempt rendering with getWorld: " + (world == null ? "null" : world) + ", isStructureFormed: " + this.isStructureFormed() + ", isActive: " + (recipeMapWorkable == null ? "null" : recipeMapWorkable.isActive() + ", previousRecipe: " + (recipeMapWorkable.getPreviousRecipe() == null ? "null" : Boolean.valueOf(recipeMapWorkable.isActive()))));
        if (world != null) {
            renderState.setBrightness(world, (BlockPos)controllerPos);
        }
        if (controllerPos == null || !this.isStructureFormed() || !recipeMapWorkable.isActive() || recipeMapWorkable.getPreviousRecipe() == null) {
            return;
        }
        SusyLog.logger.atError().log("Passed rendering check");
        Cuboid6 partialFluidBox = new Cuboid6(0.001, 0.001, 0.001, 0.999, 0.875, 0.999);
        boolean isLeftMostColumn = frontFacing == EnumFacing.SOUTH || frontFacing == EnumFacing.WEST;
        boolean isFurthestRow = frontFacing == EnumFacing.SOUTH || frontFacing == EnumFacing.WEST;
        BlockPos.MutableBlockPos corner = this.getCorner(isFurthestRow, isLeftMostColumn);
        int EWFacing = frontFacing.func_176736_b() & 1;
        int NSFacing = frontFacing.func_176736_b() + 1 & 1;
        translation.translate((double)(corner.func_177958_n() - controllerPos.func_177958_n()), 1.0, (double)(corner.func_177952_p() - controllerPos.func_177952_p()));
        translation.scale((double)(EWFacing * this.rowCount + NSFacing * this.columnCount), 1.0, (double)(EWFacing * this.columnCount + NSFacing * this.rowCount));
        FluidStack fluidStack = Materials.Water.getFluid(1000);
        if (recipeMapWorkable.getPreviousRecipe().getFluidInputs() != null) {
            fluidStack = ((GTRecipeInput)recipeMapWorkable.getPreviousRecipe().getFluidInputs().get(0)).getInputFluidStack();
        }
        renderState.setBrightness((IBlockAccess)this.getWorld(), (BlockPos)controllerPos);
        renderState.setFluidColour(fluidStack);
        TextureAtlasSprite fluidStillSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidStack.getFluid().getStill(fluidStack).toString());
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Textures.renderFace((CCRenderState)renderState, (Matrix4)translation, (IVertexOperation[])pipeline, (EnumFacing)facing, (Cuboid6)partialFluidBox, (TextureAtlasSprite)fluidStillSprite, (BlockRenderLayer)BlockRenderLayer.CUTOUT_MIPPED);
        }
        GlStateManager.func_179117_G();
        renderState.reset();
    }

    public void update() {
        super.update();
        if (this.getWorld().field_72995_K) {
            if (this.isActive() && !this.isRecipeStalled) {
                this.evaporationParticles();
            }
            return;
        }
        if (this.structurePattern.getError() != null) {
            return;
        }
        this.tickTimer &= Integer.MAX_VALUE;
        this.checkCoilActivity();
        this.rollingAverage[this.tickTimer % 20] = 0;
        if (this.tickTimer % 10 == 0 && this.tickTimer != 0) {
            if (this.getWorld().func_175727_C(this.getPos().func_177967_a(this.getFrontFacing().func_176734_d(), 2)) || !this.getWorld().func_72935_r()) {
                this.exposedBlocks = 0;
                for (int i = 0; i < this.wasExposed.length; ++i) {
                    this.wasExposed[i] = 0;
                }
            } else if (this.getWorld().field_73011_w.getDimension() == 0) {
                int row = this.tickTimer / 20 / this.columnCount % this.rowCount;
                int col = this.tickTimer / 20 % this.columnCount;
                BlockPos.MutableBlockPos skyCheckPos = new BlockPos.MutableBlockPos(this.getPos().func_177967_a(EnumFacing.UP, 2));
                skyCheckPos.func_189534_c(this.getFrontFacing().func_176734_d(), this.rowCount - row + 1);
                skyCheckPos.func_189534_c(this.getFrontFacing().func_176746_e(), this.controllerPosition);
                skyCheckPos.func_189534_c(this.getFrontFacing().func_176735_f(), col);
                if (this.wasExposed == null || this.wasExposed.length != this.rowCount * this.columnCount) {
                    this.wasExposed = new byte[this.rowCount * this.columnCount];
                    this.exposedBlocks = 0;
                    SusyLog.logger.atError().log("Detected evaporation pool with invalid wasExposed array at pos: " + this.getPos() + "; setting explosed blocks to 0");
                }
                if (!this.getWorld().func_175710_j((BlockPos)skyCheckPos)) {
                    if (this.wasExposed[row * this.columnCount + col] != 0 && this.tickTimer / 20 > this.rowCount * this.columnCount) {
                        this.exposedBlocks = Math.max(0, this.exposedBlocks - 1);
                        this.wasExposed[row * this.columnCount + col] = 0;
                    }
                } else if (this.wasExposed[row * this.columnCount + col] == 0) {
                    if (this.exposedBlocks < this.rowCount * this.columnCount) {
                        ++this.exposedBlocks;
                    }
                    this.wasExposed[row * this.columnCount + col] = 1;
                }
            }
        }
        this.inputEnergy(this.exposedBlocks * 50);
        if (this.joulesBuffer >= 1000) {
            int tempBuffer = this.joulesBuffer;
            this.joulesBuffer = 0;
            if (!this.inputEnergy(tempBuffer)) {
                this.joulesBuffer = tempBuffer;
            }
        }
        ++this.tickTimer;
        this.writeCustomData(10868607, buf -> {
            buf.writeInt(this.exposedBlocks);
            buf.func_179250_a(this.wasExposed);
            buf.writeInt(this.kiloJoules);
            buf.writeInt(this.tickTimer);
            buf.writeBoolean(this.isRecipeStalled);
        });
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, (boolean)this.isStructureFormed()).setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.getEnergyContainer()).addCustom(tl -> {
            if (this.isStructureFormed()) {
                if (this.isHeated()) {
                    tl.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.WHITE, (String)"gregtech.top.evaporation_pool_heated_preface", (Object[])new Object[0]).func_150258_a(" ").func_150257_a((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GREEN, (String)"gregtech.top.evaporation_pool_is_heated", (Object[])new Object[0])));
                } else {
                    tl.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.WHITE, (String)"gregtech.top.evaporation_pool_heated_preface", (Object[])new Object[0]).func_150258_a(" ").func_150257_a((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.RED, (String)"gregtech.top.evaporation_pool_not_heated", (Object[])new Object[0])));
                }
                tl.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.WHITE, (String)"gregtech.multiblock.evaporation_pool.exposed_blocks", (Object[])new Object[0]).func_150258_a(" ").func_150257_a((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GREEN, (String)TextFormattingUtil.formatNumbers((long)this.exposedBlocks), (Object[])new Object[0])));
                tl.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.WHITE, (String)"gregtech.top.evaporation_pool.energy_transferred", (Object[])new Object[0]).func_150258_a(" ").func_150257_a(TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.YELLOW, (String)TextFormattingUtil.formatNumbers((long)this.getKiloJoules())).func_150258_a(".").func_150257_a((ITextComponent)TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.YELLOW, (String)EvaporationPoolInfoProvider.constLengthToString(this.getJoulesBuffer()))).func_150258_a(" ").func_150257_a((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.WHITE, (String)"gregtech.top.evaporation_pool.kilojoules", (Object[])new Object[0]))));
                tl.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.WHITE, (String)"gregtech.mutliblock.evaporation_pool.rolling_average", (Object[])new Object[0]).func_150258_a(" ").func_150257_a((ITextComponent)TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.YELLOW, (String)TextFormattingUtil.formatNumbers((long)this.getRollingAverageJt()))).func_150258_a(" ").func_150257_a((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.WHITE, (String)"gregtech.multiblock.evaporation_pool.joules_per_tick", (Object[])new Object[0])));
                tl.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.WHITE, (String)"gregtech.multiblock.evaporation_pool.average_speed", (Object[])new Object[0]).func_150258_a(" ").func_150257_a((ITextComponent)TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.GREEN, (String)this.getAverageRecipeSpeedString())).func_150257_a((ITextComponent)TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.WHITE, (String)"x")));
            }
        }).addEnergyTierLine((int)GTUtility.getTierByVoltage((long)this.recipeMapWorkable.getMaxVoltage())).addParallelsLine(this.recipeMapWorkable.getParallelLimit()).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgressPercent());
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("columnCount", this.columnCount);
        data.func_74768_a("rowCount", this.rowCount);
        data.func_74768_a("controllerPosition", this.controllerPosition);
        data.func_74757_a("isHeated", this.isHeated);
        data.func_74757_a("areCoilsHeating", this.areCoilsHeating);
        data.func_74768_a("exposedBlocks", this.exposedBlocks);
        data.func_74773_a("wasExposed", this.wasExposed == null ? new byte[this.rowCount * this.columnCount] : this.wasExposed);
        data.func_74768_a("kiloJoules", this.kiloJoules);
        data.func_74768_a("tickTimer", this.tickTimer);
        data.func_74757_a("isRecipeStalled", this.isRecipeStalled);
        data.func_74768_a("coilStateMeta", this.coilStateMeta);
        return data;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("columnCount")) {
            this.columnCount = data.func_74762_e("columnCount");
        }
        if (data.func_74764_b("rowCount")) {
            this.rowCount = data.func_74762_e("rowCount");
        }
        if (data.func_74764_b("controllerPosition")) {
            this.controllerPosition = data.func_74762_e("controllerPosition");
        }
        if (data.func_74764_b("isHeated")) {
            this.isHeated = data.func_74767_n("isHeated");
        }
        if (data.func_74764_b("areCoilsHeating")) {
            this.areCoilsHeating = data.func_74767_n("areCoilsHeating");
        }
        if (data.func_74764_b("exposedBlocks")) {
            this.exposedBlocks = data.func_74762_e("exposedBlocks");
        }
        if (data.func_74764_b("wasExposed")) {
            this.wasExposed = data.func_74770_j("wasExposed");
        }
        if (data.func_74764_b("kiloJoules")) {
            this.kiloJoules = data.func_74762_e("kiloJoules");
        }
        if (data.func_74764_b("tickTimer")) {
            this.tickTimer = data.func_74762_e("tickTimer");
        }
        if (data.func_74764_b("isRecipeStalled")) {
            this.isRecipeStalled = data.func_74767_n("isRecipeStalled");
        }
        if (data.func_74764_b("coilStateMeta")) {
            this.coilStateMeta = data.func_74762_e("coilStateMeta");
            this.initializeCoilStats();
        }
        if (this.rollingAverage == null) {
            this.rollingAverage = new int[20];
        }
        this.reinitializeStructurePattern();
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeInt(this.columnCount);
        buf.writeInt(this.rowCount);
        buf.writeInt(this.controllerPosition);
        buf.writeBoolean(this.isHeated);
        buf.writeBoolean(this.areCoilsHeating);
        buf.writeInt(this.exposedBlocks);
        buf.func_179250_a(this.wasExposed == null ? new byte[this.rowCount * this.columnCount] : this.wasExposed);
        buf.writeInt(this.kiloJoules);
        buf.writeInt(this.tickTimer);
        buf.writeBoolean(this.isRecipeStalled);
        buf.writeInt(this.coilStateMeta);
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.columnCount = buf.readInt();
        this.rowCount = buf.readInt();
        this.controllerPosition = buf.readInt();
        this.isHeated = buf.readBoolean();
        this.areCoilsHeating = buf.readBoolean();
        this.exposedBlocks = buf.readInt();
        this.wasExposed = buf.func_179251_a();
        this.kiloJoules = buf.readInt();
        this.tickTimer = buf.readInt();
        this.isRecipeStalled = buf.readBoolean();
        this.coilStateMeta = buf.readInt();
        if (this.rollingAverage == null) {
            this.rollingAverage = new int[20];
        }
        this.reinitializeStructurePattern();
    }

    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 1051354) {
            this.columnCount = buf.readInt();
            this.rowCount = buf.readInt();
            this.controllerPosition = buf.readInt();
        } else if (dataId == 10142156) {
            this.isHeated = buf.readBoolean();
            this.areCoilsHeating = buf.readBoolean();
            this.coilStateMeta = buf.readInt();
            this.initializeCoilStats();
        } else if (dataId == 10868607) {
            this.exposedBlocks = buf.readInt();
            this.wasExposed = buf.func_179251_a();
            this.kiloJoules = buf.readInt();
            this.tickTimer = buf.readInt();
            this.isRecipeStalled = buf.readBoolean();
        }
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void evaporationParticles() {
        EnumFacing back = this.getFrontFacing().func_176734_d();
        EnumFacing left = back.func_176735_f();
        int leftOffset = (left.func_82601_c() * -1 >>> 31) + (left.func_82599_e() * -1 >>> 31);
        int backOffset = (back.func_82601_c() * -1 >>> 31) + (back.func_82599_e() * -1 >>> 31);
        BlockPos pos = this.getPos().func_177967_a(left, this.controllerPosition + leftOffset).func_177967_a(back, 1 + backOffset);
        for (int i = 0; i < Math.max(1, this.columnCount * this.rowCount / 3); ++i) {
            float xLength = back.func_82601_c() * this.rowCount + left.func_82601_c() * this.columnCount * -1;
            float zLength = back.func_82599_e() * this.rowCount + left.func_82599_e() * this.columnCount * -1;
            float xPos = (float)pos.func_177958_n() + xLength * GTValues.RNG.nextFloat();
            float yPos = (float)pos.func_177956_o() + 0.75f;
            float zPos = (float)pos.func_177952_p() + zLength * GTValues.RNG.nextFloat();
            float ySpd = 0.4f + 0.2f * GTValues.RNG.nextFloat();
            this.getWorld().func_175688_a(EnumParticleTypes.CLOUD, (double)xPos, (double)yPos, (double)zPos, 0.0, (double)ySpd, 0.0, new int[0]);
        }
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.SOLID_STEEL_CASING;
    }

    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.BLAST_FURNACE_OVERLAY;
    }

    public boolean isMultiblockPartWeatherResistant(@Nonnull IMultiblockPart part) {
        return true;
    }

    public boolean getIsWeatherOrTerrainResistant() {
        return true;
    }

    public int getKiloJoules() {
        return this.kiloJoules;
    }

    public int getJoulesBuffer() {
        return this.joulesBuffer;
    }

    public int getTickTimer() {
        return this.tickTimer;
    }

    public int getRollingAverageJt() {
        return this.exposedBlocks * 50 + Arrays.stream(this.rollingAverage).sum() / 20;
    }

    public float getAverageRecipeSpeed() {
        if (!this.recipeMapWorkable.isActive() || this.recipeMapWorkable.getPreviousRecipe() == null) {
            return 0.0f;
        }
        float recipeJt = ((Integer)this.recipeMapWorkable.getPreviousRecipe().getProperty((RecipeProperty)EvaporationEnergyProperty.getInstance(), (Object)-1)).intValue();
        return ((float)(this.exposedBlocks * 50) + (float)Arrays.stream(this.rollingAverage).sum() / 20.0f) / recipeJt;
    }

    public String getAverageRecipeSpeedString() {
        return Float.toString((float)((int)(this.getAverageRecipeSpeed() * 100.0f)) / 100.0f);
    }

    public void checkCoilActivity(String source) {
        boolean isRunningHeated = this.isRunningHeated();
        if (this.lastActive ^ isRunningHeated) {
            this.setLastActive(isRunningHeated);
            this.markDirty();
            this.replaceVariantBlocksActive(isRunningHeated);
        }
    }

    public void checkCoilActivity() {
        boolean isRunningHeated = this.isRunningHeated();
        if (this.lastActive ^ isRunningHeated) {
            this.setLastActive(isRunningHeated);
            this.markDirty();
            this.replaceVariantBlocksActive(isRunningHeated);
        }
    }

    public void setCoilActivity(boolean state) {
        if (state == this.lastActive) {
            this.setLastActive(!state);
            this.markDirty();
            this.replaceVariantBlocksActive(!state);
        }
        this.setLastActive(state);
        this.markDirty();
        this.replaceVariantBlocksActive(state);
    }

    public boolean isHeated() {
        return this.isHeated;
    }

    public boolean isRunningHeated() {
        return this.isHeated && this.isActive() && this.areCoilsHeating;
    }

    public void setKiloJoules(int kiloJoules) {
        this.kiloJoules = kiloJoules;
    }

    public void setJoulesBuffer(int joulesBuffer) {
        this.joulesBuffer = joulesBuffer;
    }

    public void setIsHeated(boolean isHeated) {
        this.isHeated = isHeated;
    }

    public boolean inputEnergy(int joules) {
        int CUBE_HEAT_CAPACITY = 100;
        if (this.getKiloJoules() > 100 * this.columnCount * this.rowCount) {
            return false;
        }
        int kJ = joules / 1000;
        this.joulesBuffer += (joules -= kJ * 1000);
        this.setKiloJoules(this.getKiloJoules() + kJ);
        int n = this.tickTimer % 20;
        this.rollingAverage[n] = this.rollingAverage[n] + (joules + 1000 * kJ);
        return true;
    }

    public int calcMaxSteps(int jStepSize) {
        int stepCount = this.getKiloJoules() * 1000 / jStepSize;
        int remainder = (stepCount + 1) * jStepSize - this.getKiloJoules() * 1000;
        if (this.joulesBuffer >= remainder) {
            ++stepCount;
        } else {
            remainder = 0;
        }
        return stepCount += (this.joulesBuffer - remainder) / jStepSize;
    }

    public boolean allowsExtendedFacing() {
        return false;
    }

    static {
        validContainerStates.add(SuSyBlocks.EVAPORATION_BED.getState(BlockEvaporationBed.EvaporationBedType.DIRT));
        validContainerStates.addAll((Collection<IBlockState>)MetaBlocks.WIRE_COIL.func_176194_O().func_177619_a());
    }
}

