/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.multi.electric;

import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntLists;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import supersymmetry.api.SusyLog;
import supersymmetry.api.recipes.SuSyRecipeMaps;
import supersymmetry.api.recipes.properties.DroneDimensionProperty;
import supersymmetry.common.blocks.BlockSuSyMultiblockCasing;
import supersymmetry.common.blocks.SuSyBlocks;
import supersymmetry.common.entities.EntityDrone;

public class MetaTileEntityDronePad
extends RecipeMapMultiblockController {
    private AxisAlignedBB landingAreaBB;
    private EntityDrone drone = null;
    public boolean droneReachedSky;

    public MetaTileEntityDronePad(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, SuSyRecipeMaps.DRONE_PAD);
        this.recipeMapWorkable = new DronePadWorkable(this);
    }

    protected static IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.STEEL_SOLID);
    }

    protected static IBlockState getPadState() {
        return SuSyBlocks.MULTIBLOCK_CASING.getState(BlockSuSyMultiblockCasing.CasingType.DRONE_PAD);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{" CCC ", "     ", "     "}).aisle(new String[]{"CPPPC", " AAA ", " AAA "}).aisle(new String[]{"CPPPC", " AAA ", " AAA "}).aisle(new String[]{"CPPPC", " AAA ", " AAA "}).aisle(new String[]{" CSC ", "     ", "     "}).where(' ', MetaTileEntityDronePad.any()).where('A', MetaTileEntityDronePad.air()).where('S', this.selfPredicate()).where('C', MetaTileEntityDronePad.states((IBlockState[])new IBlockState[]{MetaTileEntityDronePad.getCasingState()}).setMinGlobalLimited(6).or(this.autoAbilities(true, false, true, true, false, false, false))).where('P', MetaTileEntityDronePad.states((IBlockState[])new IBlockState[]{MetaTileEntityDronePad.getPadState()})).build();
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return Textures.SOLID_STEEL_CASING;
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityDronePad(this.metaTileEntityId);
    }

    @Nullable
    public EntityDrone getDrone() {
        return this.drone;
    }

    public void setDrone(@Nullable EntityDrone drone) {
        this.drone = drone;
    }

    public void setDroneDead(boolean setReachedSky) {
        if (this.drone != null) {
            this.drone.func_70106_y();
            this.drone = null;
        }
        this.droneReachedSky = setReachedSky;
    }

    public boolean hasDrone() {
        if (this.getDrone() != null && !this.getDrone().field_70128_L) {
            for (EntityDrone entity : this.getWorld().func_72872_a(EntityDrone.class, this.landingAreaBB)) {
                if (entity != this.getDrone()) continue;
                return true;
            }
        }
        return false;
    }

    public void spawnDroneEntity(boolean descending) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74778_a("id", "susy:drone");
        Vec3d pos = this.getDroneSpawnPosition(descending);
        EntityDrone drone = (EntityDrone)AnvilChunkLoader.func_186054_a((NBTTagCompound)nbttagcompound, (World)this.getWorld(), (double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c, (boolean)true);
        if (drone != null) {
            this.setDrone(drone.withPadPos(this.getPos()));
        }
        if (this.getDrone() != null) {
            this.getDrone().setRotationFromFacing(this.getFrontFacing());
            if (descending) {
                this.getDrone().setDescendingMode();
                this.getDrone().setPadAltitude(this.getPos().func_177956_o());
            }
        } else {
            SusyLog.logger.error("Failed to spawn drone entity at: {}", (Object)pos);
        }
    }

    public Vec3d getDroneSpawnPosition(boolean descending) {
        double altitude = descending ? 296.0 : (double)this.getPos().func_177956_o() + 1.0;
        switch (this.getFrontFacing()) {
            case EAST: {
                return new Vec3d((double)this.getPos().func_177958_n() - 1.5, altitude, (double)this.getPos().func_177952_p() + 0.5);
            }
            case SOUTH: {
                return new Vec3d((double)this.getPos().func_177958_n() + 0.5, altitude, (double)this.getPos().func_177952_p() - 1.5);
            }
            case WEST: {
                return new Vec3d((double)this.getPos().func_177958_n() + 2.5, altitude, (double)this.getPos().func_177952_p() + 0.5);
            }
        }
        return new Vec3d((double)this.getPos().func_177958_n() + 0.5, altitude, (double)this.getPos().func_177952_p() + 2.5);
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.setStructureAABB();
    }

    public void setStructureAABB() {
        double x = this.getPos().func_177958_n();
        double y = this.getPos().func_177956_o();
        double z = this.getPos().func_177952_p();
        switch (this.getFrontFacing()) {
            case EAST: {
                this.landingAreaBB = new AxisAlignedBB(x - 1.0, y + 1.0, z + 1.0, x - 3.0, y + 2.0, z - 1.0);
                break;
            }
            case SOUTH: {
                this.landingAreaBB = new AxisAlignedBB(x - 1.0, y + 1.0, z - 1.0, x + 1.0, y + 2.0, z - 3.0);
                break;
            }
            case WEST: {
                this.landingAreaBB = new AxisAlignedBB(x + 1.0, y + 1.0, z - 1.0, x + 3.0, y + 2.0, z + 1.0);
                break;
            }
            default: {
                this.landingAreaBB = new AxisAlignedBB(x + 1.0, y + 1.0, z + 1.0, x - 1.0, y + 2.0, z + 3.0);
            }
        }
    }

    public boolean checkRecipe(@NotNull Recipe recipe) {
        IntListIterator intListIterator = ((IntList)recipe.getProperty((RecipeProperty)DroneDimensionProperty.getInstance(), (Object)IntLists.EMPTY_LIST)).iterator();
        while (intListIterator.hasNext()) {
            int dimension = (Integer)intListIterator.next();
            if (dimension != this.getWorld().field_73011_w.getDimension()) continue;
            return true;
        }
        return false;
    }

    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("droneReachedSky", this.droneReachedSky);
        return data;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.droneReachedSky = data.func_74767_n("droneReachedSky");
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.droneReachedSky);
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.droneReachedSky = buf.readBoolean();
    }

    public boolean isMultiblockPartWeatherResistant(@Nonnull IMultiblockPart part) {
        return true;
    }

    public boolean getIsWeatherOrTerrainResistant() {
        return true;
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    public boolean allowsExtendedFacing() {
        return false;
    }

    public static class DronePadWorkable
    extends MultiblockRecipeLogic {
        public DronePadWorkable(RecipeMapMultiblockController tileEntity) {
            super(tileEntity);
        }

        @NotNull
        public MetaTileEntityDronePad getMetaTileEntity() {
            return (MetaTileEntityDronePad)super.getMetaTileEntity();
        }

        public boolean isAllowOverclocking() {
            return false;
        }

        public boolean checkRecipe(@NotNull Recipe recipe) {
            return ((MetaTileEntityDronePad)this.metaTileEntity).checkRecipe(recipe) && super.checkRecipe(recipe);
        }

        protected void setupRecipe(Recipe recipe) {
            super.setupRecipe(recipe);
            this.getMetaTileEntity().spawnDroneEntity(false);
        }

        protected void updateRecipeProgress() {
            super.updateRecipeProgress();
            if (!this.getMetaTileEntity().droneReachedSky && this.getMetaTileEntity().getDrone() != null && this.getMetaTileEntity().getDrone().reachedSky()) {
                this.getMetaTileEntity().setDroneDead(true);
            }
            if (this.maxProgressTime - this.progressTime == 240 && this.getMetaTileEntity().droneReachedSky) {
                this.getMetaTileEntity().spawnDroneEntity(true);
            }
        }

        protected void completeRecipe() {
            if (this.getMetaTileEntity().hasDrone()) {
                super.completeRecipe();
            } else {
                this.progressTime = 0;
                this.setMaxProgress(0);
                this.recipeEUt = 0;
                this.fluidOutputs = null;
                this.itemOutputs = null;
                this.hasNotEnoughEnergy = false;
                this.wasActiveAndNeedsUpdate = true;
                this.parallelRecipesPerformed = 0;
                this.overclockResults = new int[]{0, 0};
            }
            this.getMetaTileEntity().setDroneDead(false);
        }
    }
}

