/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.metatileentities.logistics;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.unification.material.Material;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import supersymmetry.api.metatileentity.logistics.MetaTileEntityDelegator;
import supersymmetry.client.renderer.textures.custom.ExtenderRender;

public class MetaTileEntityExtender
extends MetaTileEntityDelegator {
    protected final ExtenderRender renderer;
    protected EnumFacing inputFacing;

    public MetaTileEntityExtender(ResourceLocation metaTileEntityId, Predicate<Capability<?>> capFilter, ExtenderRender renderer, Material baseMaterial) {
        this(metaTileEntityId, capFilter, renderer, baseMaterial.getMaterialRGB());
    }

    public MetaTileEntityExtender(ResourceLocation metaTileEntityId, Predicate<Capability<?>> capFilter, ExtenderRender renderer, int baseColor) {
        super(metaTileEntityId, capFilter, baseColor);
        this.renderer = renderer;
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityExtender(this.metaTileEntityId, this.capFilter, this.renderer, this.baseColor);
    }

    @Override
    @Nullable
    public EnumFacing getDelegatingFacing(EnumFacing facing) {
        return facing == this.getFrontFacing() ? this.inputFacing : this.getFrontFacing();
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.renderer.render(renderState, translation, pipeline, this.getFrontFacing(), this.inputFacing);
    }

    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!playerIn.func_70093_af()) {
            if (this.getInputFacing() == facing || facing == this.getFrontFacing()) {
                return false;
            }
            if (!this.getWorld().field_72995_K) {
                this.setInputFacing(facing);
            }
            return true;
        }
        return super.onWrenchClick(playerIn, hand, facing, hitResult);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("InputFacing", this.getInputFacing().func_176745_a());
        return data;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inputFacing = EnumFacing.field_82609_l[data.func_74762_e("InputFacing")];
    }

    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeByte(this.getInputFacing().func_176745_a());
    }

    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.inputFacing = EnumFacing.field_82609_l[buf.readByte()];
    }

    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_OUTPUT_FACING) {
            this.inputFacing = EnumFacing.field_82609_l[buf.readByte()];
            this.scheduleRenderUpdate();
        }
    }

    public boolean isValidFrontFacing(EnumFacing facing) {
        return facing != this.getFrontFacing() && facing != this.inputFacing;
    }

    public void setFrontFacing(EnumFacing frontFacing) {
        super.setFrontFacing(frontFacing);
        if (this.inputFacing == null) {
            this.setInputFacing(frontFacing.func_176734_d());
        }
    }

    public EnumFacing getInputFacing() {
        return this.inputFacing == null ? EnumFacing.SOUTH : this.inputFacing;
    }

    public void setInputFacing(EnumFacing inputFacing) {
        this.inputFacing = inputFacing;
        if (!this.getWorld().field_72995_K) {
            this.notifyBlockUpdate();
            this.writeCustomData(GregtechDataCodes.UPDATE_OUTPUT_FACING, buf -> buf.writeByte(inputFacing.func_176745_a()));
            this.markDirty();
        }
    }

    public boolean needsSneakToRotate() {
        return true;
    }

    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }
}

