/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.materials;

import gregtech.api.GregTechAPI;
import gregtech.api.fluids.FluidBuilder;
import gregtech.api.fluids.store.FluidStorageKeys;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlag;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.DustProperty;
import gregtech.api.unification.material.properties.FluidPipeProperties;
import gregtech.api.unification.material.properties.FluidProperty;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.IngotProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.OreProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import supersymmetry.api.SusyLog;
import supersymmetry.api.unification.material.info.SuSyMaterialFlags;
import supersymmetry.common.materials.SuSyElementMaterials;
import supersymmetry.common.materials.SuSyFirstDegreeMaterials;
import supersymmetry.common.materials.SuSyHighDegreeMaterials;
import supersymmetry.common.materials.SuSyOrganicChemistryMaterials;
import supersymmetry.common.materials.SuSySecondDegreeMaterials;
import supersymmetry.common.materials.SuSyUnknownCompositionMaterials;

public class SusyMaterials {
    public static Material ManganeseIronArsenicPhosphide;
    public static Material PraseodymiumNickel;
    public static Material GadoliniumSiliconGermanium;
    public static Material Gabbro;
    public static Material Gneiss;
    public static Material Limestone;
    public static Material Phyllite;
    public static Material Shale;
    public static Material Slate;
    public static Material Kimberlite;
    public static Material Latex;
    public static Material Mud;
    public static Material Seawater;
    public static Material Anorthite;
    public static Material Albite;
    public static Material Oligoclase;
    public static Material Andesine;
    public static Material Labradorite;
    public static Material Bytownite;
    public static Material Clinochlore;
    public static Material Augite;
    public static Material Dolomite;
    public static Material Muscovite;
    public static Material Forsterite;
    public static Material Lizardite;
    public static Material Fluorite;

    public static void init() {
        SuSyElementMaterials.init();
        SuSyFirstDegreeMaterials.init();
        SuSySecondDegreeMaterials.init();
        SuSyOrganicChemistryMaterials.init();
        SuSyHighDegreeMaterials.init();
        SuSyUnknownCompositionMaterials.init();
        SusyMaterials.changeProperties();
    }

    public static void removeFlags() {
        for (Material material : GregTechAPI.materialManager.getRegisteredMaterials()) {
            if (!material.hasFlag(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING)) continue;
            SusyMaterials.removeFlag(MaterialFlags.DECOMPOSITION_BY_ELECTROLYZING, material);
        }
    }

    private static void changeProperties() {
        SusyMaterials.removeProperty(PropertyKey.ORE, Materials.Soapstone);
        SusyMaterials.removeProperty(PropertyKey.ORE, Materials.Quartzite);
        SusyMaterials.removeProperty(PropertyKey.ORE, Materials.Mica);
        SusyMaterials.removeProperty(PropertyKey.FLUID_PIPE, Materials.Lead);
        Materials.Lead.setProperty(PropertyKey.FLUID_PIPE, (IMaterialProperty)new FluidPipeProperties(1200, 8, true, true, false, false));
        Materials.Iodine.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Scandium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Germanium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Selenium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Bromine.setProperty(PropertyKey.FLUID, (IMaterialProperty)new FluidProperty(FluidStorageKeys.LIQUID, new FluidBuilder()));
        Materials.Rubidium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Strontium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Zirconium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Technetium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Tellurium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Praseodymium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Promethium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Gadolinium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Terbium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Dysprosium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Holmium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Erbium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Thulium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Ytterbium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Hafnium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Rhenium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Thallium.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.CalciumChloride.setProperty(PropertyKey.FLUID, (IMaterialProperty)new FluidProperty(FluidStorageKeys.LIQUID, new FluidBuilder()));
        Materials.MagnesiumChloride.setProperty(PropertyKey.FLUID, (IMaterialProperty)new FluidProperty(FluidStorageKeys.LIQUID, new FluidBuilder()));
        Materials.RockSalt.setProperty(PropertyKey.FLUID, (IMaterialProperty)new FluidProperty(FluidStorageKeys.LIQUID, new FluidBuilder()));
        Materials.Salt.setProperty(PropertyKey.FLUID, (IMaterialProperty)new FluidProperty(FluidStorageKeys.LIQUID, new FluidBuilder()));
        Materials.SodiumHydroxide.setProperty(PropertyKey.FLUID, (IMaterialProperty)new FluidProperty(FluidStorageKeys.LIQUID, new FluidBuilder()));
        Materials.Sodium.setProperty(PropertyKey.FLUID, (IMaterialProperty)new FluidProperty(FluidStorageKeys.LIQUID, new FluidBuilder()));
        Materials.Phosphorus.setProperty(PropertyKey.INGOT, (IMaterialProperty)new IngotProperty());
        Materials.Phosphorus.setProperty(PropertyKey.FLUID, (IMaterialProperty)new FluidProperty(FluidStorageKeys.LIQUID, new FluidBuilder().temperature(317)));
        Materials.Phosphorus.setMaterialRGB(16776918);
        Materials.HydrochloricAcid.setFormula("(H2O)(HCl)", true);
        Materials.HydrofluoricAcid.setFormula("(H2O)(HF)", true);
        SusyMaterials.removeProperty(PropertyKey.FLUID, Materials.Dimethyldichlorosilane);
        Materials.Dimethyldichlorosilane.setProperty(PropertyKey.FLUID, (IMaterialProperty)new FluidProperty(FluidStorageKeys.LIQUID, new FluidBuilder()));
        Materials.Iron3Chloride.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Nitrochlorobenzene.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Dichlorobenzene.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Dichlorobenzidine.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.PhthalicAcid.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.DiphenylIsophtalate.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Diaminobenzidine.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.PolyvinylAcetate.setProperty(PropertyKey.DUST, (IMaterialProperty)new DustProperty());
        Materials.Platinum.addFlags(new MaterialFlag[]{SuSyMaterialFlags.GENERATE_CATALYST_BED});
        Materials.Cobalt.addFlags(new MaterialFlag[]{SuSyMaterialFlags.GENERATE_CATALYST_BED});
        Materials.Palladium.addFlags(new MaterialFlag[]{SuSyMaterialFlags.GENERATE_CATALYST_BED});
        Materials.Rhodium.addFlags(new MaterialFlag[]{SuSyMaterialFlags.GENERATE_CATALYST_BED});
        Materials.Copper.addFlags(new MaterialFlag[]{SuSyMaterialFlags.GENERATE_CATALYST_BED});
        Materials.Electrum.setProperty(PropertyKey.ORE, (IMaterialProperty)new OreProperty());
        Materials.Hydrogen.addFlags(new MaterialFlag[]{MaterialFlags.FLAMMABLE});
    }

    private static void removeProperty(PropertyKey<?> key, Material material) {
        Map map = null;
        try {
            Field field = MaterialProperties.class.getDeclaredField("propertyMap");
            field.setAccessible(true);
            map = (Map)field.get(material.getProperties());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            SusyLog.logger.error("Failed to reflect material property map", (Throwable)e);
        }
        if (map != null) {
            map.remove(key);
        }
    }

    private static void removeFlag(MaterialFlag flag, Material material) {
        HashSet set = null;
        try {
            Field field = MaterialFlags.class.getDeclaredField("flags");
            field.setAccessible(true);
            Field field2 = Material.class.getDeclaredField("flags");
            field2.setAccessible(true);
            set = (HashSet)field.get(field2.get(material));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            SusyLog.logger.error("Failed to reflect material flag hashset", (Throwable)e);
        }
        if (set != null) {
            set.remove(flag);
        }
    }
}

