/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.item.armor;

import gregtech.api.items.metaitem.stats.IItemDurabilityManager;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import supersymmetry.api.items.IBreathingArmorLogic;
import supersymmetry.common.event.DimensionBreathabilityHandler;

public class SimpleGasMask
implements IBreathingArmorLogic,
IItemDurabilityManager {
    public static final double LIFETIME = 600.0;

    public EntityEquipmentSlot getEquipmentSlot(ItemStack itemStack) {
        return EntityEquipmentSlot.HEAD;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "gregtech:textures/armor/simple_gas_mask.png";
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return 1.0 - this.getDamage(itemStack);
    }

    public boolean canBreakWithDamage(ItemStack stack) {
        return this.getDamage(stack) >= 1.0;
    }

    @Override
    public boolean mayBreatheWith(ItemStack stack, EntityPlayer player) {
        return player.field_71093_bK == 10 && this.getDamage(stack) < 1.0;
    }

    public boolean isValidArmor(ItemStack itemStack, Entity entity, EntityEquipmentSlot equipmentSlot) {
        return true;
    }

    @Override
    public double getDamageAbsorbed(ItemStack stack, EntityPlayer player) {
        if (DimensionBreathabilityHandler.isInHazardousEnvironment(player)) {
            this.changeDamage(stack, 0.0016666666666666668);
        }
        if (this.getDamage(stack) >= 1.0) {
            player.func_70669_a(stack);
            stack.func_190918_g(1);
            player.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
        }
        return -1.0;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltips) {
        int secondsRemaining = (int)(600.0 - this.getDamage(stack) * 600.0);
        tooltips.add(I18n.func_135052_a((String)"supersymmetry.seconds_left", (Object[])new Object[]{secondsRemaining}));
    }

    private double getDamage(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("damage")) {
            stack.func_77978_p().func_74780_a("damage", 0.0);
        }
        return stack.func_77978_p().func_74769_h("damage");
    }

    private void changeDamage(ItemStack stack, double damageChange) {
        NBTTagCompound compound = stack.func_77978_p();
        compound.func_74780_a("damage", this.getDamage(stack) + damageChange);
        stack.func_77982_d(compound);
    }
}

