/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.item.armor;

import gregtech.api.GTValues;
import gregtech.api.capability.IFilter;
import gregtech.api.capability.impl.GTFluidHandlerItemStack;
import gregtech.api.items.armor.ArmorLogicSuite;
import gregtech.api.items.armor.ArmorMetaItem;
import gregtech.api.items.armor.ArmorUtils;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.items.metaitem.stats.IItemCapabilityProvider;
import gregtech.api.items.metaitem.stats.IItemComponent;
import gregtech.api.items.metaitem.stats.IItemDurabilityManager;
import gregtech.api.items.metaitem.stats.IItemHUDProvider;
import gregtech.api.items.metaitem.stats.ISubItemHandler;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GradientUtil;
import gregtech.api.util.input.KeyBind;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import supersymmetry.api.capability.IElytraFlyingProvider;
import supersymmetry.api.capability.SuSyCapabilities;
import supersymmetry.api.recipes.SuSyRecipeMaps;
import supersymmetry.api.util.ElytraFlyingUtils;
import supersymmetry.client.audio.MovingSoundJetEngine;
import supersymmetry.client.renderer.handler.JetWingpackModel;

public class JetWingpack
extends ArmorLogicSuite
implements IItemHUDProvider {
    protected static final int TANK_CAPACITY = 32000;
    protected static final int MAX_SPEED = 2;
    protected static final double MIN_SPEED = 0.02;
    protected static final double THRUST = 0.05;
    protected static final double REVERSE_THRUST = 0.05;
    protected static final double FALLING = 0.005;
    protected static final ISpecialArmor.ArmorProperties DEFAULT_PROPERTIES = new ISpecialArmor.ArmorProperties(Integer.MIN_VALUE, -2.0, Integer.MAX_VALUE);
    protected static final Function<FluidStack, Integer> FUEL_BURN_TIME = fluidStack -> {
        Recipe recipe = SuSyRecipeMaps.JET_WINGPACK_FUELS.findRecipe(GTValues.V[2], Collections.emptyList(), Collections.singletonList(fluidStack));
        return recipe != null ? recipe.getDuration() : 0;
    };
    @SideOnly(value=Side.CLIENT)
    private ArmorUtils.ModularHUD HUD;
    @SideOnly(value=Side.CLIENT)
    protected MovingSoundJetEngine jetEngineSound;

    protected JetWingpack() {
        super(1, 32000L, 4, EntityEquipmentSlot.CHEST);
        if (ArmorUtils.SIDE.isClient()) {
            this.HUD = new ArmorUtils.ModularHUD();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawHUD(@NotNull ItemStack item) {
        IFluidTankProperties[] prop;
        IFluidHandlerItem tank = (IFluidHandlerItem)item.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (tank != null && (prop = tank.getTankProperties())[0] != null && prop[0].getContents() != null) {
            if (prop[0].getContents().amount == 0) {
                return;
            }
            String formated = String.format("%.1f", Float.valueOf((float)prop[0].getContents().amount * 100.0f / (float)prop[0].getCapacity()));
            this.HUD.newString(I18n.func_135052_a((String)"metaarmor.hud.fuel_lvl", (Object[])new Object[]{formated + "%"}));
            NBTTagCompound data = item.func_77978_p();
            if (data != null && data.func_74764_b("engineActive")) {
                String status = data.func_74767_n("engineActive") ? I18n.func_135052_a((String)"metaarmor.hud.status.enabled", (Object[])new Object[0]) : I18n.func_135052_a((String)"metaarmor.hud.status.disabled", (Object[])new Object[0]);
                String result = I18n.func_135052_a((String)"metaarmor.hud.engine_status", (Object[])new Object[]{status});
                this.HUD.newString(result);
            }
        }
        this.HUD.draw();
        this.HUD.reset();
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        NBTTagCompound data = GTUtility.getOrCreateNbtCompound((ItemStack)itemStack);
        byte toggleTimer = 0;
        boolean pressed = false;
        boolean wingActive = false;
        boolean engineActive = false;
        if (data.func_74764_b("toggleTimer")) {
            toggleTimer = data.func_74771_c("toggleTimer");
        }
        if (data.func_74764_b("pressed")) {
            pressed = data.func_74767_n("pressed");
        }
        if (data.func_74764_b("wingActive")) {
            wingActive = data.func_74767_n("wingActive");
        }
        if (data.func_74764_b("engineActive")) {
            engineActive = data.func_74767_n("engineActive");
        }
        if (toggleTimer == 0 && KeyBind.ARMOR_MODE_SWITCH.isKeyDown(player)) {
            engineActive = !engineActive;
            toggleTimer = 5;
            if (!world.field_72995_K) {
                if (engineActive) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.jet_wingpack.engine_active", new Object[0]), true);
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.jet_wingpack.engine_inactive", new Object[0]), true);
                }
            }
        }
        if (world.field_72995_K) {
            this.handleSounds(player, engineActive);
        }
        if (engineActive && player.func_184613_cA() && this.drainFuel(itemStack, this.getEnergyPerUse(), true)) {
            Vec3d lookVec = player.func_70040_Z();
            if (KeyBind.VANILLA_SNEAK.isKeyDown(player)) {
                player.field_70159_w -= 0.05 * (player.field_70159_w - 0.02 * lookVec.field_72450_a);
                player.field_70181_x -= 0.05 * player.field_70181_x + 0.005;
                player.field_70179_y -= 0.05 * (player.field_70179_y - 0.02 * lookVec.field_72449_c);
            } else {
                player.field_70159_w += 0.05 * (2.0 * lookVec.field_72450_a - player.field_70159_w);
                player.field_70181_x += 0.05 * (2.0 * lookVec.field_72448_b - player.field_70181_x);
                player.field_70179_y += 0.05 * (2.0 * lookVec.field_72449_c - player.field_70179_y);
                world.func_175688_a(EnumParticleTypes.CLOUD, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            }
            this.drainFuel(itemStack, this.getEnergyPerUse(), false);
        }
        if (!pressed && KeyBind.VANILLA_JUMP.isKeyDown(player)) {
            pressed = true;
            if (!world.field_72995_K) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                if (!wingActive) {
                    if (ElytraFlyingUtils.canTakeOff((EntityPlayer)playerMP, engineActive)) {
                        playerMP.func_184847_M();
                        wingActive = true;
                    }
                } else {
                    playerMP.func_189103_N();
                    wingActive = false;
                }
            }
        }
        if (pressed && !KeyBind.VANILLA_JUMP.isKeyDown(player)) {
            pressed = false;
        }
        if (toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
        }
        data.func_74774_a("toggleTimer", toggleTimer);
        data.func_74757_a("pressed", pressed);
        data.func_74757_a("wingActive", wingActive);
        data.func_74757_a("engineActive", engineActive);
        player.field_71069_bz.func_75142_b();
    }

    @SideOnly(value=Side.CLIENT)
    public void handleSounds(EntityPlayer player, boolean engineActive) {
        if (this.jetEngineSound == null) {
            this.jetEngineSound = new MovingSoundJetEngine(player);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.jetEngineSound);
        }
        if (engineActive && !this.jetEngineSound.isPlaying()) {
            this.jetEngineSound.startPlaying();
        } else if (!engineActive && this.jetEngineSound.isPlaying()) {
            this.jetEngineSound.stopPlaying();
        }
        if (this.jetEngineSound.isThrottled() != KeyBind.VANILLA_SNEAK.isKeyDown(player)) {
            this.jetEngineSound.setThrottled(KeyBind.VANILLA_SNEAK.isKeyDown(player));
        }
    }

    public void addToolComponents(ArmorMetaItem.ArmorMetaValueItem mvi) {
        mvi.addComponents(new IItemComponent[]{new ElytraFlyingProvider()});
        mvi.addComponents(new IItemComponent[]{new JetWingpackBehaviour(32000)});
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped defaultModel) {
        return JetWingpackModel.INSTANCE;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "susy:textures/armor/jet_wingpack.png";
    }

    public boolean handleUnblockableDamage(EntityLivingBase entity, @NotNull ItemStack armor, DamageSource source, double damage, EntityEquipmentSlot equipmentSlot) {
        return source == DamageSource.field_188406_j && entity.func_184613_cA();
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase entity, @NotNull ItemStack armor, DamageSource source, double damage, EntityEquipmentSlot slot) {
        return source == DamageSource.field_188406_j ? DEFAULT_PROPERTIES : super.getProperties(entity, armor, source, damage, slot);
    }

    protected boolean drainFuel(@NotNull ItemStack stack, int amount, boolean simulate) {
        NBTTagCompound data = GTUtility.getOrCreateNbtCompound((ItemStack)stack);
        int burnTimer = 0;
        if (data.func_74764_b("burnTimer")) {
            burnTimer = data.func_74765_d("burnTimer");
        }
        if (burnTimer > 0) {
            if (!simulate) {
                data.func_74777_a("burnTimer", (short)(burnTimer - 1));
            }
            return true;
        }
        IFluidHandlerItem fluidHandler = this.getFluidHandler(stack);
        if (fluidHandler == null) {
            return false;
        }
        FluidStack fuelStack = fluidHandler.drain(amount, false);
        if (fuelStack == null) {
            return false;
        }
        int burnTime = FUEL_BURN_TIME.apply(fuelStack);
        if (burnTime <= 0) {
            return false;
        }
        if (!simulate) {
            data.func_74777_a("burnTimer", (short)burnTime);
            fluidHandler.drain(amount, true);
        }
        return true;
    }

    private IFluidHandlerItem getFluidHandler(ItemStack stack) {
        return (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    private static class ElytraFlyingProvider
    implements IItemComponent,
    IElytraFlyingProvider,
    ICapabilityProvider,
    IItemCapabilityProvider {
        private ElytraFlyingProvider() {
        }

        @Override
        public boolean isElytraFlying(@NotNull EntityLivingBase entity, @NotNull ItemStack itemStack, boolean shouldStop) {
            if (entity instanceof EntityPlayer) {
                NBTTagCompound data = GTUtility.getOrCreateNbtCompound((ItemStack)itemStack);
                if (shouldStop) {
                    data.func_74757_a("wingActive", false);
                }
                return data.func_74764_b("wingActive") && data.func_74767_n("wingActive");
            }
            return false;
        }

        public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == SuSyCapabilities.ELYTRA_FLYING_PROVIDER;
        }

        @Nullable
        public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == SuSyCapabilities.ELYTRA_FLYING_PROVIDER ? SuSyCapabilities.ELYTRA_FLYING_PROVIDER.cast((Object)this) : null);
        }

        public ICapabilityProvider createProvider(ItemStack itemStack) {
            return this;
        }
    }

    public class JetWingpackBehaviour
    implements IItemDurabilityManager,
    IItemCapabilityProvider,
    IItemBehaviour,
    ISubItemHandler {
        private static final IFilter<FluidStack> JET_WINGPACK_FUEL_FILTER = new IFilter<FluidStack>(){

            public boolean test(@NotNull FluidStack fluidStack) {
                return FUEL_BURN_TIME.apply(fluidStack) > 0;
            }

            public int getPriority() {
                return IFilter.whitelistLikePriority();
            }
        };
        public final int maxCapacity;
        private final Pair<Color, Color> durabilityBarColors;

        public JetWingpackBehaviour(int internalCapacity) {
            this.maxCapacity = internalCapacity;
            this.durabilityBarColors = GradientUtil.getGradient((int)12037896, (int)10);
        }

        public double getDurabilityForDisplay(@NotNull ItemStack itemStack) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (fluidHandlerItem == null) {
                return 0.0;
            }
            IFluidTankProperties fluidTankProperties = fluidHandlerItem.getTankProperties()[0];
            FluidStack fluidStack = fluidTankProperties.getContents();
            return fluidStack == null ? 0.0 : (double)fluidStack.amount / (double)fluidTankProperties.getCapacity();
        }

        @Nullable
        public Pair<Color, Color> getDurabilityColorsForDisplay(ItemStack itemStack) {
            return this.durabilityBarColors;
        }

        public ICapabilityProvider createProvider(ItemStack itemStack) {
            return new GTFluidHandlerItemStack(itemStack, this.maxCapacity).setFilter(JET_WINGPACK_FUEL_FILTER);
        }

        public void addInformation(ItemStack itemStack, List<String> lines) {
            super.addInformation(itemStack, lines);
            NBTTagCompound data = GTUtility.getOrCreateNbtCompound((ItemStack)itemStack);
            String status = I18n.func_135052_a((String)"metaarmor.hud.status.disabled", (Object[])new Object[0]);
            if (data.func_74764_b("engineActive") && data.func_74767_n("engineActive")) {
                status = I18n.func_135052_a((String)"metaarmor.hud.status.enabled", (Object[])new Object[0]);
            }
            lines.add(I18n.func_135052_a((String)"metaarmor.hud.engine_status", (Object[])new Object[]{status}));
        }

        public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
            return JetWingpack.this.onRightClick(world, player, hand);
        }

        public String getItemSubType(ItemStack itemStack) {
            return "";
        }

        public void getSubItems(ItemStack itemStack, CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
            ItemStack copy = itemStack.func_77946_l();
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)copy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (fluidHandlerItem != null) {
                Optional firstRecipe = SuSyRecipeMaps.JET_WINGPACK_FUELS.getRecipeList().stream().findFirst();
                firstRecipe.ifPresent(recipe -> {
                    Optional<FluidStack> inputFluidStack = recipe.getFluidInputs().stream().map(GTRecipeInput::getInputFluidStack).filter(Objects::nonNull).findFirst();
                    inputFluidStack.ifPresent(stack -> {
                        Fluid fluid = stack.getFluid();
                        if (fluid != null && stack.amount > 0) {
                            fluidHandlerItem.fill(new FluidStack(fluid, this.maxCapacity), true);
                            subItems.add((Object)copy);
                        }
                    });
                });
            }
            subItems.add((Object)itemStack);
        }
    }
}

