/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.item.armor;

import gregtech.api.items.armor.IArmorLogic;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import supersymmetry.api.util.SuSyUtility;
import supersymmetry.client.renderer.handler.BreathingApparatusModel;
import supersymmetry.client.renderer.handler.ITextureRegistrar;
import supersymmetry.common.item.SuSyArmorItem;
import supersymmetry.common.item.armor.BreathingApparatus;

public class AdvancedBreathingApparatus
extends BreathingApparatus
implements ITextureRegistrar {
    private final double hoursOfLife;
    private final String name;
    private final int tier;
    private final double relativeAbsorption;
    private static final double DEFAULT_ABSORPTION = 0.0;

    public AdvancedBreathingApparatus(EntityEquipmentSlot slot, double hoursOfLife, String name, int tier, double relativeAbsorption) {
        super(slot);
        this.hoursOfLife = hoursOfLife;
        this.name = name;
        this.tier = tier;
        this.relativeAbsorption = relativeAbsorption;
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "susy:textures/armor/" + this.name + "_" + slot.func_188450_d() + ".png";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped defaultModel) {
        if (this.model == null) {
            this.model = new BreathingApparatusModel(this.name, armorSlot);
        }
        return this.model;
    }

    @Override
    public boolean mayBreatheWith(ItemStack stack, EntityPlayer player) {
        return player.field_71093_bK == 10 || player.field_71093_bK == -1;
    }

    @Override
    public double getDamageAbsorbed(ItemStack stack, EntityPlayer player) {
        SuSyArmorItem item;
        IArmorLogic iArmorLogic;
        this.handleDamage(stack, player);
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        Item item2 = chest.func_77973_b();
        if (item2 instanceof SuSyArmorItem && (iArmorLogic = ((SuSyArmorItem.SuSyArmorMetaValueItem)(item = (SuSyArmorItem)item2).getItem(chest)).getArmorLogic()) instanceof AdvancedBreathingApparatus) {
            AdvancedBreathingApparatus tank = (AdvancedBreathingApparatus)iArmorLogic;
            if (tank.tier == this.tier) {
                SuSyArmorItem item22;
                IArmorLogic iArmorLogic2;
                ItemStack boots;
                SuSyArmorItem item23;
                Item item3;
                tank.handleDamage(chest, player);
                int piecesCount = 0;
                ItemStack leggings = player.func_184582_a(EntityEquipmentSlot.LEGS);
                Item item4 = leggings.func_77973_b();
                if (item4 instanceof SuSyArmorItem && (item3 = ((SuSyArmorItem.SuSyArmorMetaValueItem)(item23 = (SuSyArmorItem)item4).getItem(leggings)).getArmorLogic()) instanceof AdvancedBreathingApparatus) {
                    AdvancedBreathingApparatus legLogic = (AdvancedBreathingApparatus)item3;
                    legLogic.handleDamage(leggings, player);
                    ++piecesCount;
                }
                if ((item3 = (boots = player.func_184582_a(EntityEquipmentSlot.FEET)).func_77973_b()) instanceof SuSyArmorItem && (iArmorLogic2 = ((SuSyArmorItem.SuSyArmorMetaValueItem)(item22 = (SuSyArmorItem)item3).getItem(boots)).getArmorLogic()) instanceof AdvancedBreathingApparatus) {
                    AdvancedBreathingApparatus bootLogic = (AdvancedBreathingApparatus)iArmorLogic2;
                    bootLogic.handleDamage(boots, player);
                    ++piecesCount;
                }
                if (tank.getOxygen(chest) <= 0.0) {
                    return 0.0;
                }
                tank.changeOxygen(chest, -1.0);
                switch (piecesCount) {
                    case 0: {
                        return 0.5;
                    }
                    case 1: {
                        return 1.0;
                    }
                    case 2: {
                        return -1.0;
                    }
                }
            }
        }
        return 0.0;
    }

    private double getDamage(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("damage")) {
            stack.func_77978_p().func_74780_a("damage", 0.0);
        }
        return stack.func_77978_p().func_74769_h("damage");
    }

    private void changeDamage(ItemStack stack, double damageChange) {
        NBTTagCompound compound = stack.func_77978_p();
        compound.func_74780_a("damage", this.getDamage(stack) + damageChange);
        stack.func_77982_d(compound);
    }

    private void handleDamage(ItemStack stack, EntityPlayer player) {
        if (this.hoursOfLife == 0.0 || player.field_71093_bK == 10) {
            return;
        }
        double amount = 1.0 / (3600.0 * this.hoursOfLife);
        this.changeDamage(stack, amount);
        if (this.getDamage(stack) >= 1.0) {
            player.func_70669_a(stack);
            stack.func_190918_g(1);
            player.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
        }
    }

    @Override
    public double getDurabilityForDisplay(ItemStack itemStack) {
        if (this.SLOT == EntityEquipmentSlot.CHEST && this.getMaxOxygen(itemStack) != -1.0) {
            return this.getOxygen(itemStack) / this.getMaxOxygen(itemStack);
        }
        if (this.hoursOfLife > 0.0) {
            return 1.0 - this.getDamage(itemStack);
        }
        return 1.0;
    }

    public float getHeatResistance() {
        return 0.25f;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @NotNull ItemStack armor, DamageSource source, double damage, EntityEquipmentSlot equipmentSlot) {
        ISpecialArmor.ArmorProperties prop = new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        if (source.func_76363_c()) {
            return prop;
        }
        prop.Armor = (double)this.getAbsorption(armor) * this.relativeAbsorption * 20.0;
        return prop;
    }

    protected float getAbsorption(ItemStack itemStack) {
        return this.getAbsorption(this.getEquipmentSlot(itemStack));
    }

    protected float getAbsorption(EntityEquipmentSlot slot) {
        float f;
        switch (slot) {
            case HEAD: 
            case FEET: {
                f = 0.15f;
                break;
            }
            case CHEST: {
                f = 0.4f;
                break;
            }
            case LEGS: {
                f = 0.3f;
                break;
            }
            default: {
                f = 0.0f;
            }
        }
        return f;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> strings) {
        if (this.hoursOfLife > 0.0) {
            double lifetime = 3600.0 * this.hoursOfLife;
            int secondsRemaining = (int)(lifetime - this.getDamage(stack) * lifetime);
            strings.add(I18n.func_135052_a((String)"supersymmetry.seconds_left", (Object[])new Object[]{secondsRemaining}));
        } else {
            strings.add(I18n.func_135052_a((String)"supersymmetry.unlimited", (Object[])new Object[0]));
        }
        int armor = (int)Math.round((double)(20.0f * this.getAbsorption(this.SLOT)) * this.relativeAbsorption);
        if (armor > 0) {
            strings.add(I18n.func_135052_a((String)"attribute.modifier.plus.0", (Object[])new Object[]{armor, I18n.func_135052_a((String)"attribute.name.generic.armor", (Object[])new Object[0])}));
        }
    }

    @Override
    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)Math.round((double)(20.0f * this.getAbsorption(armor)) * this.relativeAbsorption);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getTextureLocations() {
        ArrayList<ResourceLocation> models = new ArrayList<ResourceLocation>();
        models.add(SuSyUtility.susyId("armor/" + this.name + "_" + this.SLOT.toString()));
        return models;
    }
}

