/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import supersymmetry.api.event.MobHordeEvent;

public class MobHordePlayerData
implements INBTSerializable<NBTTagCompound> {
    public int ticksUntilCanSpawn;
    public int gracePeriod;
    public int ticksActive;
    public int timeoutPeriod;
    public int[] invasionTimers;
    public boolean hasActiveInvasion = false;
    public List<UUID> invasionEntitiesUUIDs = new ArrayList<UUID>();
    public String currentInvasion = "";

    public MobHordePlayerData(int gracePeriod) {
        this.ticksUntilCanSpawn = gracePeriod;
        this.gracePeriod = gracePeriod;
        this.invasionTimers = new int[MobHordeEvent.EVENTS.size()];
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound result = new NBTTagCompound();
        result.func_74768_a("ticksUntilCanSpawn", this.ticksUntilCanSpawn);
        result.func_74783_a("invasionTimers", this.invasionTimers);
        result.func_74757_a("hasActiveInvasion", this.hasActiveInvasion);
        if (this.hasActiveInvasion && !this.invasionEntitiesUUIDs.isEmpty()) {
            result.func_74778_a("currentInvasion", this.currentInvasion);
            result.func_74768_a("timeoutPeriod", this.timeoutPeriod);
            result.func_74768_a("ticksActive", this.ticksActive);
            NBTTagList tagList = new NBTTagList();
            this.invasionEntitiesUUIDs.stream().forEach(uuid -> tagList.func_74742_a((NBTBase)NBTUtil.func_186862_a((UUID)uuid)));
            result.func_74782_a("invasionEntitiesUUIDs", (NBTBase)tagList);
        }
        return result;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.ticksUntilCanSpawn = nbt.func_74762_e("ticksUntilCanSpawn");
        this.invasionTimers = Arrays.copyOf(nbt.func_74759_k("invasionTimers"), MobHordeEvent.EVENTS.size());
        this.hasActiveInvasion = nbt.func_74767_n("hasActiveInvasion");
        if (this.hasActiveInvasion) {
            this.invasionEntitiesUUIDs.clear();
            this.currentInvasion = nbt.func_74779_i("currentInvasion");
            this.timeoutPeriod = nbt.func_74762_e("timeoutPeriod");
            this.ticksActive = nbt.func_74762_e("ticksActive");
            NBTTagList tagList = nbt.func_150295_c("invasionEntitiesUUIDs", 10);
            tagList.forEach(compound -> this.invasionEntitiesUUIDs.add(NBTUtil.func_186860_b((NBTTagCompound)((NBTTagCompound)compound))));
        }
    }

    public void update(EntityPlayerMP player) {
        if (this.hasActiveInvasion) {
            ++this.ticksActive;
            if (this.ticksActive > this.timeoutPeriod) {
                this.finishInvasion();
            } else {
                return;
            }
        }
        --this.ticksUntilCanSpawn;
        int i = 0;
        while (i < this.invasionTimers.length) {
            int n = i++;
            this.invasionTimers[n] = this.invasionTimers[n] - 1;
        }
        if (this.ticksUntilCanSpawn <= 0 && Math.random() < 0.001) {
            MobHordeEvent event;
            ArrayList<Integer> doableEvents = new ArrayList<Integer>();
            List events = MobHordeEvent.EVENTS.values().stream().collect(Collectors.toList());
            for (int i2 = 0; i2 < MobHordeEvent.EVENTS.values().size(); ++i2) {
                event = (MobHordeEvent)events.get(i2);
                if (!event.canRun(player) || this.invasionTimers[i2] > 0) continue;
                doableEvents.add(i2);
            }
            if (!doableEvents.isEmpty()) {
                this.ticksUntilCanSpawn = this.gracePeriod;
                int index = (Integer)doableEvents.get((int)(Math.random() * (double)doableEvents.size()));
                event = (MobHordeEvent)events.get(index);
                if (event.run((EntityPlayer)player, this::addEntity)) {
                    this.invasionTimers[index] = event.getNextDelay();
                    this.setCurrentInvasion(event);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        EntityLivingBase deadEntity = event.getEntityLiving();
        UUID deadEntityUUID = deadEntity.getPersistentID();
        if (this.invasionEntitiesUUIDs.contains(deadEntityUUID)) {
            this.removeDeadEntity(deadEntityUUID);
            if (this.invasionEntitiesUUIDs.isEmpty()) {
                this.finishInvasion();
            }
        }
    }

    public void setCurrentInvasion(MobHordeEvent event) {
        this.currentInvasion = event.KEY;
        this.timeoutPeriod = event.timeoutPeriod;
        this.hasActiveInvasion = true;
        this.ticksActive = 0;
    }

    public void addEntity(UUID uuid) {
        this.invasionEntitiesUUIDs.add(uuid);
    }

    private void removeDeadEntity(UUID deadEntityUUID) {
        this.invasionEntitiesUUIDs.remove(deadEntityUUID);
    }

    public void finishInvasion() {
        this.hasActiveInvasion = false;
        this.currentInvasion = "";
        this.ticksActive = 0;
    }

    public void stopInvasion(EntityPlayerMP player) {
        if (this.hasActiveInvasion) {
            WorldServer world = player.func_71121_q();
            this.invasionEntitiesUUIDs.stream().map(uuid -> world.func_175733_a(uuid)).filter(Objects::nonNull).forEach(entity -> entity.func_70106_y());
            this.finishInvasion();
        }
    }
}

