/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.covers;

import com.google.common.math.IntMath;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverableView;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.IncrementButtonWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleSidedCubeRenderer;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.ManualImportExportMode;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import org.jetbrains.annotations.NotNull;

public class CoverSteamPump
extends CoverPump {
    public CoverSteamPump(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide, int mbPerTick) {
        super(definition, coverableView, attachedSide, 0, mbPerTick);
    }

    @NotNull
    protected TextureAtlasSprite getPlateSprite() {
        return Textures.STEAM_CASING_BRONZE.getSpriteOnSide(SimpleSidedCubeRenderer.RenderSide.SIDE);
    }

    public ModularUI createUI(EntityPlayer player) {
        WidgetGroup primaryGroup = new WidgetGroup();
        primaryGroup.addWidget((Widget)new LabelWidget(10, 5, this.getUITitle(), new Object[0]));
        primaryGroup.addWidget((Widget)new ImageWidget(44, 20, 62, 20, (IGuiTexture)GuiTextures.DISPLAY));
        primaryGroup.addWidget((Widget)new IncrementButtonWidget(136, 20, 30, 20, 1, 10, 100, 1000, x$0 -> this.adjustTransferRate(x$0)).setDefaultTooltip().setShouldClientCallback(false));
        primaryGroup.addWidget((Widget)new IncrementButtonWidget(10, 20, 34, 20, -1, -10, -100, -1000, x$0 -> this.adjustTransferRate(x$0)).setDefaultTooltip().setShouldClientCallback(false));
        TextFieldWidget2 textField = new TextFieldWidget2(45, 26, 60, 20, () -> this.bucketMode == CoverPump.BucketMode.BUCKET ? Integer.toString(this.transferRate / 1000) : Integer.toString(this.transferRate), val -> {
            if (val != null && !val.isEmpty()) {
                int amount = Integer.parseInt(val);
                if (this.bucketMode == CoverPump.BucketMode.BUCKET) {
                    amount = IntMath.saturatedMultiply((int)amount, (int)1000);
                }
                this.setTransferRate(amount);
            }
        }).setCentered(true).setNumbersOnly(1, this.bucketMode == CoverPump.BucketMode.BUCKET ? this.maxFluidTransferRate / 1000 : this.maxFluidTransferRate).setMaxLength(8);
        primaryGroup.addWidget((Widget)textField);
        primaryGroup.addWidget((Widget)new CycleButtonWidget(106, 20, 30, 20, CoverPump.BucketMode.class, () -> ((CoverSteamPump)this).getBucketMode(), mode -> {
            if (mode != this.bucketMode) {
                this.setBucketMode((CoverPump.BucketMode)mode);
            }
        }));
        primaryGroup.addWidget((Widget)new CycleButtonWidget(10, 43, 75, 18, CoverPump.PumpMode.class, () -> ((CoverSteamPump)this).getPumpMode(), arg_0 -> ((CoverSteamPump)this).setPumpMode(arg_0)));
        primaryGroup.addWidget((Widget)new CycleButtonWidget(7, 160, 116, 20, ManualImportExportMode.class, () -> ((CoverSteamPump)this).getManualImportExportMode(), x$0 -> this.setManualImportExportMode((ManualImportExportMode)x$0)).setTooltipHoverString("cover.universal.manual_import_export.mode.description"));
        this.fluidFilter.initUI(88, arg_0 -> ((WidgetGroup)primaryGroup).addWidget(arg_0));
        ModularUI.Builder builder = ModularUI.builder((IGuiTexture)GuiTextures.BACKGROUND, (int)176, (int)266).widget((Widget)primaryGroup).bindPlayerInventory(player.field_71071_by, (IGuiTexture)GuiTextures.SLOT, 7, 184);
        return this.buildUI(builder, player);
    }

    protected String getUITitle() {
        return "cover.pump.steam.title";
    }
}

