/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.covers;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.ItemHandlerDelegate;
import gregtech.api.cover.CoverBase;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverableView;
import gregtech.api.util.ItemStackHashStrategy;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import supersymmetry.client.renderer.textures.SusyTextures;

public class CoverRestrictive
extends CoverBase {
    protected ItemHandlerRestrictive itemHandler;

    public CoverRestrictive(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide) {
        super(definition, coverableView, attachedSide);
    }

    public boolean canAttach(@NotNull CoverableView coverable, @NotNull EnumFacing enumFacing) {
        return coverable.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getAttachedSide()) != null;
    }

    public <T> T getCapability(@NotNull Capability<T> capability, T defaultValue) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (defaultValue == null) {
                return null;
            }
            IItemHandler delegate = (IItemHandler)defaultValue;
            if (this.itemHandler == null || this.itemHandler.delegate != delegate) {
                this.itemHandler = new ItemHandlerRestrictive(delegate);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler);
        }
        return defaultValue;
    }

    public boolean canPipePassThrough() {
        return true;
    }

    public void renderCover(@NotNull CCRenderState renderState, @NotNull Matrix4 translation, @NotNull IVertexOperation[] pipeline, @NotNull Cuboid6 plateBox, @NotNull BlockRenderLayer renderLayer) {
        SusyTextures.RESTRICTIVE_FILTER_FILTER_OVERLAY.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
    }

    protected static class ItemHandlerRestrictive
    extends ItemHandlerDelegate {
        private final Map<ItemStack, Set<Integer>> multimap = new Object2ObjectOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());

        public ItemHandlerRestrictive(IItemHandler delegate) {
            super(delegate);
        }

        private void addToMap(int slot, ItemStack stack) {
            if (this.multimap.containsKey(stack)) {
                this.multimap.get(stack).add(slot);
            } else {
                ObjectArraySet set = new ObjectArraySet();
                set.add(slot);
                this.multimap.put(stack, (Set<Integer>)set);
            }
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (!this.getStackInSlot(slot).func_190926_b() && ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.getStackInSlot(slot))) {
                return super.insertItem(slot, stack, simulate);
            }
            if (this.getStackInSlot(slot).func_190926_b()) {
                if (this.multimap.containsKey(stack)) {
                    Iterator iterator = new ArrayList(this.multimap.get(stack)).iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.getStackInSlot(i))) {
                            return stack;
                        }
                        this.multimap.get(stack).remove(i);
                    }
                }
                for (int i = 0; i < this.getSlots(); ++i) {
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.getStackInSlot(i))) continue;
                    this.addToMap(i, stack);
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    }
}

