/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.covers;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.cover.CoverBase;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverableView;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.recipeproperties.GasCollectorDimensionProperty;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.client.renderer.texture.Textures;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverAirVent
extends CoverBase
implements ITickable {
    private final int airPerSecond;
    @Nullable
    private FluidStack cachedAirType;

    public CoverAirVent(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide, int airPerSecond) {
        super(definition, coverableView, attachedSide);
        this.airPerSecond = airPerSecond;
    }

    public boolean canAttach(@NotNull CoverableView coverable, @NotNull EnumFacing side) {
        return coverable.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
    }

    public void renderCover(@NotNull CCRenderState renderState, @NotNull Matrix4 translation, @NotNull IVertexOperation[] pipeline, @NotNull Cuboid6 plateBox, @NotNull BlockRenderLayer layer) {
        Textures.AIR_VENT_OVERLAY.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
    }

    public void func_73660_a() {
        World world = this.getWorld();
        if (world.field_72995_K || this.getOffsetTimer() % 20L != 0L) {
            return;
        }
        if (world.func_180495_p(this.getPos().func_177972_a(this.getAttachedSide())).func_185913_b()) {
            return;
        }
        TileEntity tileEntity = this.getTileEntityHere();
        if (tileEntity == null) {
            return;
        }
        IFluidHandler fluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getAttachedSide());
        if (fluidHandler == null) {
            return;
        }
        if (this.cachedAirType == null) {
            this.tryAcquireFluid();
        }
        if (this.cachedAirType != null) {
            fluidHandler.fill(this.cachedAirType.copy(), true);
        }
    }

    private void tryAcquireFluid() {
        int dimension = this.getWorld().field_73011_w.getDimension();
        RecipeMaps.GAS_COLLECTOR_RECIPES.getRecipeList().stream().filter(r -> {
            IntList list = (IntList)r.getProperty((RecipeProperty)GasCollectorDimensionProperty.getInstance(), null);
            if (list == null) {
                return false;
            }
            IntListIterator intListIterator = list.iterator();
            while (intListIterator.hasNext()) {
                int dim = (Integer)intListIterator.next();
                if (dimension != dim) continue;
                return true;
            }
            return false;
        }).findFirst().ifPresent(recipe -> {
            FluidStack stack = (FluidStack)recipe.getFluidOutputs().get(0);
            if (stack != null) {
                this.cachedAirType = new FluidStack(stack.getFluid(), this.airPerSecond);
            }
        });
    }
}

