/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.blocks;

import gregtech.api.GregTechAPI;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.ItemMaterialInfo;
import gregtech.api.unification.stack.MaterialStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import supersymmetry.api.unification.ore.SusyOrePrefix;
import supersymmetry.common.blocks.BlockSheetedFrame;

public class SuSyMetaBlocks {
    public static final Map<Material, BlockSheetedFrame> SHEETED_FRAMES = new HashMap<Material, BlockSheetedFrame>();
    public static final List<BlockSheetedFrame> SHEETED_FRAME_BLOCKS = new ArrayList<BlockSheetedFrame>();

    public static void init() {
        SuSyMetaBlocks.createGeneratedBlock(m -> m.hasProperty(PropertyKey.DUST) && m.hasFlag(MaterialFlags.GENERATE_FRAME), SuSyMetaBlocks::createSheetedFrameBlock);
    }

    public static void createSheetedFrameBlock(Material[] materials, int index) {
        BlockSheetedFrame block = new BlockSheetedFrame(materials);
        block.setRegistryName("meta_block_sheeted_frame_" + index);
        for (Material material : materials) {
            SHEETED_FRAMES.put(material, block);
        }
        SHEETED_FRAME_BLOCKS.add(block);
    }

    protected static void createGeneratedBlock(Predicate<Material> materialPredicate, BiConsumer<Material[], Integer> blockGenerator) {
        TreeMap<Integer, Object[]> blocksToGenerate = new TreeMap<Integer, Object[]>();
        for (Material material : GregTechAPI.materialManager.getRegisteredMaterials()) {
            if (!materialPredicate.test(material)) continue;
            int id = material.getId();
            int metaBlockID = id / 4;
            int subBlockID = id % 4;
            if (!blocksToGenerate.containsKey(metaBlockID)) {
                Object[] materials = new Material[4];
                Arrays.fill(materials, Materials.NULL);
                blocksToGenerate.put(metaBlockID, materials);
            }
            ((Material[])blocksToGenerate.get((Object)Integer.valueOf((int)metaBlockID)))[subBlockID] = material;
        }
        blocksToGenerate.forEach((key, value) -> blockGenerator.accept((Material[])value, (Integer)key));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemModels() {
        SHEETED_FRAMES.values().stream().distinct().forEach(BlockSheetedFrame::onModelRegister);
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemModel(Block block) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)block.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), SuSyMetaBlocks.statePropertiesToString(state.func_177228_b())));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemModelWithOverride(Block block, Map<IProperty<?>, Comparable<?>> stateOverrides, Predicate<IBlockState> condition) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            if (!condition.test(state)) continue;
            HashMap stringProperties = new HashMap((Map<IProperty<?>, Comparable<?>>)state.func_177228_b());
            stringProperties.putAll(stateOverrides);
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)block.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), SuSyMetaBlocks.statePropertiesToString(stringProperties)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerColors() {
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        for (BlockSheetedFrame block : SHEETED_FRAME_BLOCKS) {
            blockColors.func_186722_a((s, w, p, i) -> block.getGtMaterial(block.func_176201_c(s)).getMaterialRGB(), new Block[]{block});
            itemColors.func_186731_a((s, i) -> block.getGtMaterial(s.func_77960_j()).getMaterialRGB(), new Block[]{block});
        }
    }

    public static void registerOreDict() {
        for (Map.Entry<Material, BlockSheetedFrame> entry : SHEETED_FRAMES.entrySet()) {
            Material material = entry.getKey();
            if (material == Materials.NULL) continue;
            BlockSheetedFrame block = entry.getValue();
            ItemStack itemStack = block.getItem(material);
            OreDictUnifier.registerOre((ItemStack)itemStack, (OrePrefix)SusyOrePrefix.sheetedFrame, (Material)material);
            OreDictUnifier.registerOre((ItemStack)itemStack, (ItemMaterialInfo)new ItemMaterialInfo(new MaterialStack[]{new MaterialStack(material, 1L)}));
        }
    }

    public static String statePropertiesToString(Map<IProperty<?>, Comparable<?>> properties) {
        StringBuilder stringbuilder = new StringBuilder();
        List entries = properties.entrySet().stream().sorted(Comparator.comparing(c -> ((IProperty)c.getKey()).func_177701_a())).collect(Collectors.toList());
        for (Map.Entry entry : entries) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            IProperty property = (IProperty)entry.getKey();
            stringbuilder.append(property.func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(SuSyMetaBlocks.getPropertyName(property, (Comparable)entry.getValue()));
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("normal");
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> value) {
        return property.func_177702_a(value);
    }
}

