/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.blocks;

import gregtech.api.util.BlockUtility;
import gregtech.common.blocks.MetaBlocks;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import supersymmetry.common.blocks.BlockAlternatorCoil;
import supersymmetry.common.blocks.BlockCoagulationTankWall;
import supersymmetry.common.blocks.BlockCoolingCoil;
import supersymmetry.common.blocks.BlockDeposit;
import supersymmetry.common.blocks.BlockDrillHead;
import supersymmetry.common.blocks.BlockElectrodeAssembly;
import supersymmetry.common.blocks.BlockEvaporationBed;
import supersymmetry.common.blocks.BlockHome;
import supersymmetry.common.blocks.BlockMultiblockTank;
import supersymmetry.common.blocks.BlockResource;
import supersymmetry.common.blocks.BlockResource1;
import supersymmetry.common.blocks.BlockSeparatorRotor;
import supersymmetry.common.blocks.BlockSerpentine;
import supersymmetry.common.blocks.BlockSinteringBrick;
import supersymmetry.common.blocks.BlockStructural;
import supersymmetry.common.blocks.BlockStructural1;
import supersymmetry.common.blocks.BlockSuSyMultiblockCasing;
import supersymmetry.common.blocks.BlockTurbineRotor;
import supersymmetry.common.blocks.BlocksCustomSheets;
import supersymmetry.common.blocks.BlocksHardened;
import supersymmetry.common.blocks.SusyStoneVariantBlock;

public class SuSyBlocks {
    public static BlockCoolingCoil COOLING_COIL;
    public static BlockSinteringBrick SINTERING_BRICK;
    public static BlockCoagulationTankWall COAGULATION_TANK_WALL;
    public static final EnumMap<SusyStoneVariantBlock.StoneVariant, SusyStoneVariantBlock> SUSY_STONE_BLOCKS;
    public static BlockAlternatorCoil ALTERNATOR_COIL;
    public static BlockTurbineRotor TURBINE_ROTOR;
    public static BlockSeparatorRotor SEPARATOR_ROTOR;
    public static BlockDrillHead DRILL_HEAD;
    public static BlockStructural STRUCTURAL_BLOCK;
    public static BlockStructural1 STRUCTURAL_BLOCK_1;
    public static BlockDeposit DEPOSIT_BLOCK;
    public static BlockResource RESOURCE_BLOCK;
    public static BlockResource1 RESOURCE_BLOCK_1;
    public static BlockHome HOME;
    public static BlockMultiblockTank MULTIBLOCK_TANK;
    public static BlockEvaporationBed EVAPORATION_BED;
    public static BlockElectrodeAssembly ELECTRODE_ASSEMBLY;
    public static BlockSuSyMultiblockCasing MULTIBLOCK_CASING;
    public static BlockSerpentine SERPENTINE;
    public static BlocksHardened HARDBLOCKS;
    public static BlocksCustomSheets CUSTOMSHEETS;

    public static void init() {
        COOLING_COIL = new BlockCoolingCoil();
        COOLING_COIL.setRegistryName("cooling_coil");
        SINTERING_BRICK = new BlockSinteringBrick();
        SINTERING_BRICK.setRegistryName("sintering_brick");
        DRILL_HEAD = new BlockDrillHead();
        DRILL_HEAD.setRegistryName("drill_head");
        COAGULATION_TANK_WALL = new BlockCoagulationTankWall();
        COAGULATION_TANK_WALL.setRegistryName("coagulation_tank_wall");
        for (SusyStoneVariantBlock.StoneVariant shape : SusyStoneVariantBlock.StoneVariant.values()) {
            SUSY_STONE_BLOCKS.put(shape, new SusyStoneVariantBlock(shape));
        }
        SuSyBlocks.registerWalkingSpeedBonus();
        ALTERNATOR_COIL = new BlockAlternatorCoil();
        ALTERNATOR_COIL.setRegistryName("alternator_coil");
        TURBINE_ROTOR = new BlockTurbineRotor();
        TURBINE_ROTOR.setRegistryName("turbine_rotor");
        SEPARATOR_ROTOR = new BlockSeparatorRotor();
        SEPARATOR_ROTOR.setRegistryName("separator_rotor");
        STRUCTURAL_BLOCK = new BlockStructural();
        STRUCTURAL_BLOCK.setRegistryName("structural_block");
        STRUCTURAL_BLOCK_1 = new BlockStructural1();
        STRUCTURAL_BLOCK_1.setRegistryName("structural_block_1");
        DEPOSIT_BLOCK = new BlockDeposit();
        DEPOSIT_BLOCK.setRegistryName("deposit_block");
        RESOURCE_BLOCK = new BlockResource();
        RESOURCE_BLOCK.setRegistryName("resource_block");
        RESOURCE_BLOCK_1 = new BlockResource1();
        RESOURCE_BLOCK_1.setRegistryName("resource_block_1");
        HOME = new BlockHome();
        HOME.setRegistryName("home_block");
        EVAPORATION_BED = new BlockEvaporationBed();
        EVAPORATION_BED.setRegistryName("evaporation_bed");
        MULTIBLOCK_TANK = new BlockMultiblockTank();
        MULTIBLOCK_TANK.setRegistryName("multiblock_tank");
        ELECTRODE_ASSEMBLY = new BlockElectrodeAssembly();
        ELECTRODE_ASSEMBLY.setRegistryName("electrode_assembly");
        MULTIBLOCK_CASING = new BlockSuSyMultiblockCasing();
        MULTIBLOCK_CASING.setRegistryName("susy_multiblock_casing");
        SERPENTINE = new BlockSerpentine();
        SERPENTINE.setRegistryName("serpentine");
        HARDBLOCKS = new BlocksHardened();
        HARDBLOCKS.setRegistryName("hardened_blocks");
        CUSTOMSHEETS = new BlocksCustomSheets();
        CUSTOMSHEETS.setRegistryName("custom_sheets");
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemModels() {
        COOLING_COIL.onModelRegister();
        SINTERING_BRICK.onModelRegister();
        SuSyBlocks.registerItemModel((Block)COAGULATION_TANK_WALL);
        for (SusyStoneVariantBlock block : SUSY_STONE_BLOCKS.values()) {
            SuSyBlocks.registerItemModel((Block)block);
        }
        SuSyBlocks.registerItemModel((Block)ALTERNATOR_COIL);
        SuSyBlocks.registerItemModel((Block)DRILL_HEAD);
        SuSyBlocks.registerItemModel((Block)TURBINE_ROTOR);
        SuSyBlocks.registerItemModel((Block)SEPARATOR_ROTOR);
        SuSyBlocks.registerItemModel((Block)STRUCTURAL_BLOCK);
        SuSyBlocks.registerItemModel((Block)STRUCTURAL_BLOCK_1);
        SuSyBlocks.registerItemModel((Block)DEPOSIT_BLOCK);
        SuSyBlocks.registerItemModel((Block)RESOURCE_BLOCK);
        SuSyBlocks.registerItemModel((Block)RESOURCE_BLOCK_1);
        SuSyBlocks.registerItemModel((Block)HOME);
        EVAPORATION_BED.onModelRegister();
        MULTIBLOCK_TANK.onModelRegister();
        ELECTRODE_ASSEMBLY.onModelRegister();
        SuSyBlocks.registerItemModel((Block)MULTIBLOCK_CASING);
        SERPENTINE.onModelRegister();
        SuSyBlocks.registerItemModel((Block)HARDBLOCKS);
        SuSyBlocks.registerItemModel((Block)CUSTOMSHEETS);
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerItemModel(@NotNull Block block) {
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)block.func_176201_c(state), (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), SuSyBlocks.statePropertiesToString(state.func_177228_b())));
        }
    }

    @NotNull
    public static String statePropertiesToString(@NotNull Map<IProperty<?>, Comparable<?>> properties) {
        StringBuilder stringbuilder = new StringBuilder();
        List entries = properties.entrySet().stream().sorted(Comparator.comparing(c -> ((IProperty)c.getKey()).func_177701_a())).collect(Collectors.toList());
        for (Map.Entry entry : entries) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            IProperty property = (IProperty)entry.getKey();
            stringbuilder.append(property.func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(SuSyBlocks.getPropertyName(property, (Comparable)entry.getValue()));
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("normal");
        }
        return stringbuilder.toString();
    }

    public static void registerWalkingSpeedBonus() {
        for (SusyStoneVariantBlock block : SUSY_STONE_BLOCKS.values()) {
            if (block.getWalkingSpeed() == 0.0) continue;
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                BlockUtility.setWalkingSpeedBonus((IBlockState)state, (double)block.getWalkingSpeed());
            }
        }
        for (IBlockState state : MetaBlocks.ASPHALT.func_176194_O().func_177619_a()) {
            BlockUtility.setWalkingSpeedBonus((IBlockState)state, (double)1.0);
        }
    }

    @NotNull
    private static <T extends Comparable<T>> String getPropertyName(@NotNull IProperty<T> property, Comparable<?> value) {
        return property.func_177702_a(value);
    }

    static {
        SUSY_STONE_BLOCKS = new EnumMap(SusyStoneVariantBlock.StoneVariant.class);
    }
}

