/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.blocks;

import gregtech.api.GregTechAPI;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.properties.PropertyMaterial;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.unification.material.info.SuSyMaterialIconType;
import supersymmetry.api.util.MaterialBlockModelLoader;

public class BlockSheetedFrame
extends Block {
    public static final PropertyEnum<FrameEnumAxis> SHEETED_FRAME_AXIS = PropertyEnum.func_177709_a((String)"axis", FrameEnumAxis.class);
    public final PropertyMaterial variantProperty;

    public BlockSheetedFrame(gregtech.api.unification.material.Material[] materials) {
        super(Material.field_151573_f);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149663_c("sheeted_frame");
        this.func_149647_a((CreativeTabs)GregTechAPI.TAB_GREGTECH_MATERIALS);
        this.variantProperty = PropertyMaterial.create((String)"variant", (gregtech.api.unification.material.Material[])materials);
        BlockStateContainer stateContainer = this.createStateContainer();
        ObfuscationReflectionHelper.setPrivateValue(Block.class, (Object)((Object)this), (Object)stateContainer, (int)21);
        this.func_180632_j(stateContainer.func_177621_b().func_177226_a(SHEETED_FRAME_AXIS, (Comparable)((Object)FrameEnumAxis.Y)));
    }

    @NotNull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a(SHEETED_FRAME_AXIS, (Comparable)((Object)FrameEnumAxis.fromFacingAxis(facing.func_176740_k())));
    }

    protected BlockStateContainer createStateContainer() {
        return new BlockStateContainer((Block)this, new IProperty[]{SHEETED_FRAME_AXIS, this.variantProperty});
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[0]);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((FrameEnumAxis)((Object)state.func_177229_b(SHEETED_FRAME_AXIS))) {
                    case X: {
                        return state.func_177226_a(SHEETED_FRAME_AXIS, (Comparable)((Object)FrameEnumAxis.Z));
                    }
                    case Z: {
                        return state.func_177226_a(SHEETED_FRAME_AXIS, (Comparable)((Object)FrameEnumAxis.X));
                    }
                }
                return state;
            }
        }
        return state;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return this.func_176201_c(state);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta > 15) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a((IProperty)this.variantProperty, (Comparable)((gregtech.api.unification.material.Material)this.variantProperty.getAllowedValues().get(meta & 3))).func_177226_a(SHEETED_FRAME_AXIS, (Comparable)((Object)FrameEnumAxis.values()[(meta & 0xF) >>> 2]));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((FrameEnumAxis)((Object)state.func_177229_b(SHEETED_FRAME_AXIS))).ordinal() << 2;
        return meta |= this.variantProperty.getAllowedValues().indexOf((Object)state.func_177229_b((IProperty)this.variantProperty));
    }

    public String getHarvestTool(IBlockState state) {
        gregtech.api.unification.material.Material material = (gregtech.api.unification.material.Material)state.func_177229_b((IProperty)this.variantProperty);
        return ModHandler.isMaterialWood((gregtech.api.unification.material.Material)material) ? "axe" : "wrench";
    }

    @Nonnull
    public SoundType getSoundType(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity entity) {
        gregtech.api.unification.material.Material material = (gregtech.api.unification.material.Material)state.func_177229_b((IProperty)this.variantProperty);
        return ModHandler.isMaterialWood((gregtech.api.unification.material.Material)material) ? SoundType.field_185848_a : SoundType.field_185852_e;
    }

    public int getHarvestLevel(@Nonnull IBlockState state) {
        return 1;
    }

    @Nonnull
    public Material func_149688_o(IBlockState state) {
        gregtech.api.unification.material.Material material = (gregtech.api.unification.material.Material)state.func_177229_b((IProperty)this.variantProperty);
        return ModHandler.isMaterialWood((gregtech.api.unification.material.Material)material) ? Material.field_151575_d : super.func_149688_o(state);
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        this.field_176227_L.func_177619_a().stream().filter(blockState -> blockState.func_177229_b((IProperty)this.variantProperty) != Materials.NULL && this.func_176201_c((IBlockState)blockState) >>> 2 == 1).forEach(blockState -> list.add((Object)BlockSheetedFrame.getItem(blockState)));
    }

    public static ItemStack getItem(IBlockState blockState) {
        return GTUtility.toItem((IBlockState)blockState);
    }

    public ItemStack getItem(gregtech.api.unification.material.Material material) {
        return BlockSheetedFrame.getItem(this.func_176223_P().func_177226_a((IProperty)this.variantProperty, (Comparable)material).func_177226_a(SHEETED_FRAME_AXIS, (Comparable)((Object)FrameEnumAxis.Y)));
    }

    public IBlockState getBlock(gregtech.api.unification.material.Material material) {
        return this.func_176223_P().func_177226_a((IProperty)this.variantProperty, (Comparable)material).func_177226_a(SHEETED_FRAME_AXIS, (Comparable)((Object)FrameEnumAxis.Y));
    }

    public gregtech.api.unification.material.Material getGtMaterial(int meta) {
        return (gregtech.api.unification.material.Material)this.variantProperty.getAllowedValues().get(meta & 3);
    }

    public gregtech.api.unification.material.Material getGtMaterial(IBlockState state) {
        return this.getGtMaterial(this.func_176201_c(state));
    }

    public boolean canCreatureSpawn(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public void func_180634_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, Entity entityIn) {
        entityIn.field_70159_w = MathHelper.func_151237_a((double)entityIn.field_70159_w, (double)-0.15, (double)0.15);
        entityIn.field_70179_y = MathHelper.func_151237_a((double)entityIn.field_70179_y, (double)-0.15, (double)0.15);
        entityIn.field_70143_R = 0.0f;
        if (entityIn.field_70181_x < -0.15) {
            entityIn.field_70181_x = -0.15;
        }
        if (entityIn.func_70093_af() && entityIn.field_70181_x < 0.0) {
            entityIn.field_70181_x = 0.0;
        }
        if (entityIn.field_70123_F) {
            entityIn.field_70181_x = 0.3;
        }
    }

    @Nonnull
    public EnumPushReaction func_149656_h(@Nonnull IBlockState state) {
        return EnumPushReaction.NORMAL;
    }

    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        AxisAlignedBB axisAlignedBB;
        switch (this.func_176201_c(blockState) >>> 2) {
            case 0: {
                axisAlignedBB = new AxisAlignedBB(0.05, 0.0, 0.0, 0.95, 1.0, 1.0);
                break;
            }
            case 2: {
                axisAlignedBB = new AxisAlignedBB(0.0, 0.0, 0.05, 1.0, 1.0, 0.95);
                break;
            }
            default: {
                axisAlignedBB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
        }
        AxisAlignedBB boundingBox = axisAlignedBB;
        return boundingBox;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public void onModelRegister() {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (IBlockState state : this.func_176194_O().func_177619_a()) {
            gregtech.api.unification.material.Material material = this.getGtMaterial(state);
            map.put(state, MaterialBlockModelLoader.loadBlockModel(SuSyMaterialIconType.sheetedFrame, material.getMaterialIconSet(), "axis=" + ((FrameEnumAxis)((Object)state.func_177229_b(SHEETED_FRAME_AXIS))).func_176610_l()));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)this.func_176201_c(state), (ModelResourceLocation)MaterialBlockModelLoader.loadItemModel(SuSyMaterialIconType.sheetedFrame, material.getMaterialIconSet()));
        }
        ModelLoader.setCustomStateMapper((Block)this, arg_0 -> BlockSheetedFrame.lambda$onModelRegister$2((Map)map, arg_0));
    }

    private static /* synthetic */ Map lambda$onModelRegister$2(Map map, Block b) {
        return map;
    }

    public static enum FrameEnumAxis implements IStringSerializable
    {
        X("x"),
        Y("y"),
        Z("z"),
        NONE("none");

        private final String name;

        private FrameEnumAxis(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static FrameEnumAxis fromFacingAxis(EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    return X;
                }
                case Y: {
                    return Y;
                }
                case Z: {
                    return Z;
                }
            }
            return NONE;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

