/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common.blocks;

import gregtech.api.block.VariantActiveBlock;
import gregtech.api.block.VariantItemBlock;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import supersymmetry.common.materials.SusyMaterials;

public class BlockCoolingCoil
extends VariantActiveBlock<CoolingCoilType> {
    public BlockCoolingCoil() {
        super(Material.field_151573_f);
        this.func_149663_c("cooling_coil");
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("wrench", 2);
        this.func_180632_j(this.getState(CoolingCoilType.MANGANESE_IRON_ARSENIC_PHOSPHIDE));
    }

    @NotNull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(@NotNull ItemStack itemStack, @Nullable World worldIn, List<String> lines, @NotNull ITooltipFlag tooltipFlag) {
        super.func_190948_a(itemStack, worldIn, lines, tooltipFlag);
        VariantItemBlock itemBlock = (VariantItemBlock)itemStack.func_77973_b();
        IBlockState stackState = itemBlock.getBlockState(itemStack);
        CoolingCoilType coolingCoilType = (CoolingCoilType)this.getState(stackState);
        lines.add(I18n.func_135052_a((String)"tile.cooling_coil.tooltip_temperature", (Object[])new Object[]{coolingCoilType.coilTemperature}));
    }

    public boolean canCreatureSpawn(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public static enum CoolingCoilType implements IStringSerializable
    {
        MANGANESE_IRON_ARSENIC_PHOSPHIDE("manganese_iron_arsenic_phosphide", 160, SusyMaterials.ManganeseIronArsenicPhosphide),
        PRASEODYMIUM_NICKEL("praseodymium_nickel", 50, SusyMaterials.PraseodymiumNickel),
        GADOLINIUM_SILICON_GERMANIUM("gadolinium_silicon_germanium", 1, SusyMaterials.GadoliniumSiliconGermanium);

        public final String name;
        public final int coilTemperature;
        public final gregtech.api.unification.material.Material material;

        private CoolingCoilType(String name, int coilTemperature, gregtech.api.unification.material.Material material) {
            this.name = name;
            this.coilTemperature = coilTemperature;
            this.material = material;
        }

        @NotNull
        public String func_176610_l() {
            return this.name;
        }

        @NotNull
        public String toString() {
            return this.func_176610_l();
        }
    }
}

