/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.common;

import gregtech.api.block.VariantItemBlock;
import gregtech.api.modules.IModuleContainer;
import gregtech.api.modules.ModuleContainerRegistryEvent;
import gregtech.api.unification.material.event.MaterialEvent;
import gregtech.api.unification.material.event.PostMaterialEvent;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.items.MetaItems;
import gregtech.modules.ModuleManager;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.GeckoLib;
import supersymmetry.api.event.MobHordeEvent;
import supersymmetry.api.recipes.SuSyRecipeMaps;
import supersymmetry.api.unification.ore.SusyOrePrefix;
import supersymmetry.api.unification.ore.SusyStoneTypes;
import supersymmetry.common.blocks.SheetedFrameItemBlock;
import supersymmetry.common.blocks.SuSyBlocks;
import supersymmetry.common.blocks.SuSyMetaBlocks;
import supersymmetry.common.blocks.SusyStoneVariantBlock;
import supersymmetry.common.item.SuSyMetaItems;
import supersymmetry.common.materials.SusyMaterials;
import supersymmetry.loaders.SuSyWorldLoader;
import supersymmetry.loaders.SusyOreDictionaryLoader;
import supersymmetry.loaders.recipes.SuSyRecipeLoader;
import supersymmetry.modules.SuSyModules;

@Mod.EventBusSubscriber(modid="susy")
public class CommonProxy {
    public void preLoad() {
        GeckoLib.initialize();
        SusyStoneTypes.init();
        SuSyRecipeMaps.init();
    }

    public void load() {
        SuSyWorldLoader.init();
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            new MobHordeEvent(p -> new EntityZombie(p.field_70170_p), 4, 8, "zombies").setMaximumDistanceUnderground(10).setNightOnly(true);
        }
    }

    @SubscribeEvent
    public static void registerBlocks(@NotNull RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)SuSyBlocks.COOLING_COIL);
        registry.register((IForgeRegistryEntry)SuSyBlocks.SINTERING_BRICK);
        registry.register((IForgeRegistryEntry)SuSyBlocks.COAGULATION_TANK_WALL);
        for (SusyStoneVariantBlock block : SuSyBlocks.SUSY_STONE_BLOCKS.values()) {
            registry.register((IForgeRegistryEntry)block);
        }
        registry.register((IForgeRegistryEntry)SuSyBlocks.ALTERNATOR_COIL);
        registry.register((IForgeRegistryEntry)SuSyBlocks.TURBINE_ROTOR);
        registry.register((IForgeRegistryEntry)SuSyBlocks.SEPARATOR_ROTOR);
        registry.register((IForgeRegistryEntry)SuSyBlocks.STRUCTURAL_BLOCK);
        registry.register((IForgeRegistryEntry)SuSyBlocks.STRUCTURAL_BLOCK_1);
        registry.register((IForgeRegistryEntry)SuSyBlocks.DRILL_HEAD);
        registry.register((IForgeRegistryEntry)SuSyBlocks.DEPOSIT_BLOCK);
        registry.register((IForgeRegistryEntry)SuSyBlocks.RESOURCE_BLOCK);
        registry.register((IForgeRegistryEntry)SuSyBlocks.RESOURCE_BLOCK_1);
        registry.register((IForgeRegistryEntry)SuSyBlocks.HOME);
        registry.register((IForgeRegistryEntry)SuSyBlocks.MULTIBLOCK_TANK);
        registry.register((IForgeRegistryEntry)SuSyBlocks.EVAPORATION_BED);
        registry.register((IForgeRegistryEntry)SuSyBlocks.ELECTRODE_ASSEMBLY);
        registry.register((IForgeRegistryEntry)SuSyBlocks.MULTIBLOCK_CASING);
        registry.register((IForgeRegistryEntry)SuSyBlocks.SERPENTINE);
        registry.register((IForgeRegistryEntry)SuSyBlocks.HARDBLOCKS);
        registry.register((IForgeRegistryEntry)SuSyBlocks.CUSTOMSHEETS);
        SuSyMetaBlocks.SHEETED_FRAMES.values().stream().distinct().forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }

    @SubscribeEvent
    public static void registerItems(@NotNull RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        SuSyMetaItems.initSubItems();
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.COOLING_COIL, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.SINTERING_BRICK, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.COAGULATION_TANK_WALL, VariantItemBlock::new));
        for (SusyStoneVariantBlock block2 : SuSyBlocks.SUSY_STONE_BLOCKS.values()) {
            registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(block2, VariantItemBlock::new));
        }
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.ALTERNATOR_COIL, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.DRILL_HEAD, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.TURBINE_ROTOR, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.SEPARATOR_ROTOR, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.STRUCTURAL_BLOCK, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.STRUCTURAL_BLOCK_1, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.DEPOSIT_BLOCK, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.RESOURCE_BLOCK, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.RESOURCE_BLOCK_1, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.HOME, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.EVAPORATION_BED, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.MULTIBLOCK_TANK, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.ELECTRODE_ASSEMBLY, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.MULTIBLOCK_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.SERPENTINE, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.HARDBLOCKS, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(SuSyBlocks.CUSTOMSHEETS, VariantItemBlock::new));
        SuSyMetaBlocks.SHEETED_FRAMES.values().stream().distinct().map(block -> CommonProxy.createItemBlock(block, SheetedFrameItemBlock::new)).forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void registerMaterials(@NotNull MaterialEvent event) {
        SusyMaterials.init();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void postRegisterMaterials(@NotNull PostMaterialEvent event) {
        MetaItems.addOrePrefix((OrePrefix[])new OrePrefix[]{SusyOrePrefix.catalystPellet});
        MetaItems.addOrePrefix((OrePrefix[])new OrePrefix[]{SusyOrePrefix.catalystBed});
        MetaItems.addOrePrefix((OrePrefix[])new OrePrefix[]{SusyOrePrefix.flotated});
        MetaItems.addOrePrefix((OrePrefix[])new OrePrefix[]{SusyOrePrefix.sifted});
        MetaItems.addOrePrefix((OrePrefix[])new OrePrefix[]{SusyOrePrefix.concentrate});
        MetaItems.addOrePrefix((OrePrefix[])new OrePrefix[]{SusyOrePrefix.fiber});
        MetaItems.addOrePrefix((OrePrefix[])new OrePrefix[]{SusyOrePrefix.wetFiber});
        MetaItems.addOrePrefix((OrePrefix[])new OrePrefix[]{SusyOrePrefix.thread});
        MetaItems.addOrePrefix((OrePrefix[])new OrePrefix[]{SusyOrePrefix.dustWet});
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void itemToolTip(ItemTooltipEvent event) {
        CommonProxy.handleCoilTooltips(event);
        CommonProxy.addTooltip(event, "gregtech.machine.steam_extractor", TooltipHelper.BLINKING_ORANGE + I18n.func_135052_a((String)"gregtech.machine.steam_extractor_cannot_melt_items.warning", (Object[])new Object[0]), 2);
    }

    private static void handleCoilTooltips(ItemTooltipEvent event) {
        Block block = Block.func_149634_a((Item)event.getItemStack().func_77973_b());
        if (block instanceof BlockWireCoil && TooltipHelper.isShiftDown()) {
            ItemStack itemStack = event.getItemStack();
            Item item = itemStack.func_77973_b();
            BlockWireCoil wireCoilBlock = (BlockWireCoil)block;
            VariantItemBlock itemBlock = (VariantItemBlock)item;
            BlockWireCoil.CoilType coilType = (BlockWireCoil.CoilType)wireCoilBlock.getState(itemBlock.getBlockState(itemStack));
            event.getToolTip().add(I18n.func_135052_a((String)"tile.wire_coil.tooltip_evaporation", (Object[])new Object[0]));
            event.getToolTip().add(I18n.func_135052_a((String)"tile.wire_coil.tooltip_energy_evaporating", (Object[])new Object[]{coilType.getCoilTemperature() / 1000}));
        }
    }

    private static void addTooltip(ItemTooltipEvent event, String key, String toolTip, int index) {
        if (event.getItemStack().func_77977_a().contains(key)) {
            event.getToolTip().add(index, toolTip);
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        SusyOreDictionaryLoader.init();
        SuSyMetaBlocks.registerOreDict();
        SuSyRecipeLoader.init();
    }

    @SubscribeEvent
    public static void registerModuleContainer(ModuleContainerRegistryEvent event) {
        ModuleManager.getInstance().registerContainer((IModuleContainer)new SuSyModules());
    }

    private static <T extends Block> ItemBlock createItemBlock(T block, Function<T, ItemBlock> producer) {
        ItemBlock itemBlock = producer.apply(block);
        itemBlock.setRegistryName(Objects.requireNonNull(block.getRegistryName()));
        return itemBlock;
    }
}

