/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.client.renderer.handler;

import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.TransformUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import supersymmetry.api.SusyLog;

@SideOnly(value=Side.CLIENT)
public class OBJModelRender
extends ModelRenderer {
    public float scale = 0.0f;
    private int displayList;
    private boolean compiled = false;
    private IBakedModel objModel;
    private float scaleMultiplier = 1.0f;

    public OBJModelRender(ModelBase baseModel, ResourceLocation customModel, float scaleMultiplier) {
        this(baseModel, customModel);
        this.scaleMultiplier = scaleMultiplier;
    }

    public OBJModelRender(ModelBase baseModel, ResourceLocation customModel) {
        super(baseModel);
        try {
            this.objModel = OBJLoader.INSTANCE.loadModel(customModel).bake((IModelState)TransformUtils.DEFAULT_TOOL, DefaultVertexFormats.field_176599_b, TextureUtils::getTexture);
        }
        catch (Exception e) {
            SusyLog.logger.error((Object)e);
        }
    }

    public static void renderQuads(List<BakedQuad> listQuads) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        int j = listQuads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = listQuads.get(i);
            vertexbuffer.func_178981_a(bakedquad.func_178209_a());
            vertexbuffer.func_178990_f(1.0f, 1.0f, 1.0f);
            Vec3i vec3i = bakedquad.func_178210_d().func_176730_m();
            vertexbuffer.func_178975_e((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p());
        }
        tessellator.func_78381_a();
    }

    public void func_78785_a(float scale) {
        if (!this.field_78807_k && this.field_78806_j) {
            if (!this.compiled) {
                this.compileDisplayList(scale);
            }
            GlStateManager.func_179109_b((float)this.field_82906_o, (float)this.field_82908_p, (float)this.field_82907_q);
            if (this.field_78795_f == 0.0f && this.field_78796_g == 0.0f && this.field_78808_h == 0.0f) {
                if (this.field_78800_c == 0.0f && this.field_78797_d == 0.0f && this.field_78798_e == 0.0f) {
                    GlStateManager.func_179148_o((int)this.displayList);
                } else {
                    GlStateManager.func_179109_b((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
                    GlStateManager.func_179148_o((int)this.displayList);
                    GlStateManager.func_179109_b((float)(-this.field_78800_c * scale), (float)(-this.field_78797_d * scale), (float)(-this.field_78798_e * scale));
                }
            } else {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
                if (this.field_78808_h != 0.0f) {
                    GlStateManager.func_179114_b((float)(this.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.field_78796_g != 0.0f) {
                    GlStateManager.func_179114_b((float)(this.field_78796_g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.field_78795_f != 0.0f) {
                    GlStateManager.func_179114_b((float)(this.field_78795_f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                GlStateManager.func_179148_o((int)this.displayList);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179109_b((float)(-this.field_82906_o), (float)(-this.field_82908_p), (float)(-this.field_82907_q));
        }
    }

    private void compileDisplayList(float scale) {
        if (this.scale == 0.0f) {
            this.scale = scale * this.scaleMultiplier;
        }
        if (this.objModel == null) {
            this.compiled = true;
            SusyLog.logger.error("Failed to compile OBJ model!");
            return;
        }
        scale = this.scale;
        this.displayList = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)this.displayList, (int)4864);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)-1.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179144_i((int)Minecraft.func_71410_x().func_147117_R().func_110552_b());
        OBJModelRender.renderQuads(this.objModel.func_188616_a(null, null, 0L));
        GlStateManager.func_179121_F();
        GlStateManager.func_187415_K();
        this.compiled = true;
    }

    public void func_78791_b(float scale) {
        if (!this.field_78807_k && this.field_78806_j) {
            if (!this.compiled) {
                this.compileDisplayList(scale);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
            if (this.field_78796_g != 0.0f) {
                GlStateManager.func_179114_b((float)(this.field_78796_g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.field_78795_f != 0.0f) {
                GlStateManager.func_179114_b((float)(this.field_78795_f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (this.field_78808_h != 0.0f) {
                GlStateManager.func_179114_b((float)(this.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GlStateManager.func_179148_o((int)this.displayList);
            GlStateManager.func_179121_F();
        }
    }

    public void func_78794_c(float scale) {
        if (!this.field_78807_k && this.field_78806_j) {
            if (this.field_78795_f == 0.0f && this.field_78796_g == 0.0f && this.field_78808_h == 0.0f) {
                if (this.field_78800_c != 0.0f || this.field_78797_d != 0.0f || this.field_78798_e != 0.0f) {
                    GlStateManager.func_179109_b((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
                }
            } else {
                GlStateManager.func_179109_b((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
                if (this.field_78808_h != 0.0f) {
                    GlStateManager.func_179114_b((float)(this.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.field_78796_g != 0.0f) {
                    GlStateManager.func_179114_b((float)(this.field_78796_g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.field_78795_f != 0.0f) {
                    GlStateManager.func_179114_b((float)(this.field_78795_f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
        }
    }
}

