/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.client;

import gregtech.api.GTValues;
import gregtech.api.items.metaitem.MetaOreDictItem;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.stack.UnificationEntry;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.recipes.catalysts.CatalystGroup;
import supersymmetry.api.recipes.catalysts.CatalystInfo;
import supersymmetry.common.CommonProxy;
import supersymmetry.common.SusyMetaEntities;
import supersymmetry.common.blocks.SheetedFrameItemBlock;
import supersymmetry.common.blocks.SuSyBlocks;
import supersymmetry.common.blocks.SuSyMetaBlocks;
import supersymmetry.common.item.SuSyMetaItems;
import supersymmetry.loaders.SuSyFluidTooltipLoader;
import supersymmetry.loaders.SuSyIRLoader;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="susy", value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    @Override
    public void preLoad() {
        super.preLoad();
        SusyMetaEntities.initRenderers();
        SuSyIRLoader.initEntityRenderers();
    }

    @Override
    public void load() {
        super.load();
        SuSyMetaBlocks.registerColors();
        SuSyFluidTooltipLoader.registerTooltips();
    }

    @SubscribeEvent
    public static void addMaterialFormulaHandler(@Nonnull ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (!(itemStack.func_77973_b() instanceof SheetedFrameItemBlock)) {
            return;
        }
        UnificationEntry unificationEntry = OreDictUnifier.getUnificationEntry((ItemStack)itemStack);
        if (unificationEntry != null && unificationEntry.material != null && unificationEntry.material.getChemicalFormula() != null && !unificationEntry.material.getChemicalFormula().isEmpty()) {
            event.getToolTip().add(TextFormatting.YELLOW + unificationEntry.material.getChemicalFormula());
        }
    }

    @SubscribeEvent
    public static void addCatalystTooltipHandler(@Nonnull ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        ArrayList<String> tooltips = new ArrayList<String>();
        Item item = itemStack.func_77973_b();
        if (item instanceof MetaOreDictItem) {
            MetaOreDictItem oreDictItem = (MetaOreDictItem)item;
            Optional oreDictName = OreDictUnifier.getOreDictionaryNames((ItemStack)itemStack).stream().findFirst();
            if (oreDictName.isPresent() && oreDictItem.OREDICT_TO_FORMULA.containsKey(oreDictName.get()) && !((String)oreDictItem.OREDICT_TO_FORMULA.get(oreDictName.get())).isEmpty()) {
                tooltips.add(TextFormatting.YELLOW + (String)oreDictItem.OREDICT_TO_FORMULA.get(oreDictName.get()));
            }
        }
        for (CatalystGroup group : CatalystGroup.getCatalystGroups()) {
            ItemStack is = itemStack.func_77946_l();
            is.func_190920_e(1);
            CatalystInfo catalystInfo = group.getCatalystInfos().get(is);
            if (catalystInfo == null) continue;
            tooltips.add(TextFormatting.UNDERLINE + TextFormatting.BLUE + I18n.func_135052_a((String)("gregtech.catalyst_group." + group.getName() + ".name"), (Object[])new Object[0]));
            if (catalystInfo.getTier() == -1) {
                tooltips.add(TextFormatting.RED + "Disclaimer: Catalyst bonuses for non-tiered catalysts have not yet been implemented.");
                tooltips.add(I18n.func_135052_a((String)"gregtech.universal.catalysts.tooltip.yield", (Object[])new Object[]{catalystInfo.getYieldEfficiency()}));
                tooltips.add(I18n.func_135052_a((String)"gregtech.universal.catalysts.tooltip.energy", (Object[])new Object[]{catalystInfo.getEnergyEfficiency()}));
                tooltips.add(I18n.func_135052_a((String)"gregtech.universal.catalysts.tooltip.speed", (Object[])new Object[]{catalystInfo.getSpeedEfficiency()}));
                continue;
            }
            tooltips.add(I18n.func_135052_a((String)"gregtech.universal.catalysts.tooltip.tier", (Object[])new Object[]{GTValues.V[catalystInfo.getTier()], GTValues.VNF[catalystInfo.getTier()]}));
            tooltips.add(I18n.func_135052_a((String)"gregtech.universal.catalysts.tooltip.yield.tiered", (Object[])new Object[]{catalystInfo.getYieldEfficiency()}));
            tooltips.add(I18n.func_135052_a((String)"gregtech.universal.catalysts.tooltip.energy.tiered", (Object[])new Object[]{catalystInfo.getEnergyEfficiency()}));
            tooltips.add(I18n.func_135052_a((String)"gregtech.universal.catalysts.tooltip.speed.tiered", (Object[])new Object[]{catalystInfo.getSpeedEfficiency()}));
        }
        event.getToolTip().addAll(tooltips);
    }

    @SubscribeEvent
    public static void registerModels(@NotNull ModelRegistryEvent event) {
        SuSyBlocks.registerItemModels();
        SuSyMetaBlocks.registerItemModels();
    }

    @SubscribeEvent
    public static void stitchTexture(TextureStitchEvent.Pre event) {
        TextureMap map = event.getMap();
        map.func_174942_a(new ResourceLocation("susy", "armor/jet_wingpack"));
        SuSyMetaItems.armorItem.registerIngameModels(map);
    }
}

