/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.recipes.properties;

import gregtech.api.gui.resources.TextureArea;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class BiomeProperty
extends RecipeProperty<BiomePropertyList> {
    public static final String KEY = "biome";
    private static final Position POSITION = new Position(80, 45);
    private static final Size SIZE = new Size(16, 16);
    private static final TextureArea ICON = TextureArea.fullImage((String)"textures/gui/widget/information.png");
    private static BiomeProperty INSTANCE;

    private BiomeProperty() {
        super(KEY, BiomePropertyList.class);
    }

    public static BiomeProperty getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BiomeProperty();
        }
        return INSTANCE;
    }

    private static String getBiomesForRecipe(BiomePropertyList biomePropertyList, boolean limited) {
        boolean isWhiteList = biomePropertyList.whiteListBiomes.size() > 0;
        List<Biome> list = isWhiteList ? biomePropertyList.whiteListBiomes : biomePropertyList.blackListBiomes;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            builder.append(list.get((int)i).field_76791_y);
            if (i == list.size() - 1) continue;
            builder.append(", ");
        }
        String str = I18n.func_135052_a((String)(isWhiteList ? "susy.recipe.biomes" : "susy.recipe.biomes_blocked"), (Object[])new Object[]{builder.toString()});
        if (limited && str.length() >= 35) {
            str = str.substring(0, 32) + "..";
        }
        return str;
    }

    @SideOnly(value=Side.CLIENT)
    public void getTooltipStrings(List<String> tooltip, int mouseX, int mouseY, Object value) {
        super.getTooltipStrings(tooltip, mouseX, mouseY, value);
        BiomePropertyList list = (BiomePropertyList)this.castValue(value);
        if (mouseX < POSITION.getX() || mouseX > POSITION.getX() + SIZE.getWidth() || mouseY < POSITION.getY() || mouseY > POSITION.getY() + SIZE.getHeight()) {
            return;
        }
        tooltip.add(BiomeProperty.getBiomesForRecipe(list, false));
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int x, int y, int color, Object value) {
        BiomePropertyList list = (BiomePropertyList)this.castValue(value);
        minecraft.field_71466_p.func_78276_b(BiomeProperty.getBiomesForRecipe(list, true), x, y, color);
        GlStateManager.func_179145_e();
        GlStateManager.func_179085_a((int)1);
        ICON.draw((double)POSITION.getX(), (double)POSITION.getY(), SIZE.getWidth(), SIZE.getHeight());
        GlStateManager.func_179122_b((int)1);
        GlStateManager.func_179140_f();
    }

    public static class BiomePropertyList {
        public static BiomePropertyList EMPTY_LIST = new BiomePropertyList();
        public final List<Biome> whiteListBiomes = new ObjectArrayList();
        public final List<Biome> blackListBiomes = new ObjectArrayList();

        public void add(Biome biome, boolean toBlacklist) {
            if (toBlacklist) {
                this.blackListBiomes.add(biome);
                this.whiteListBiomes.remove(biome);
            } else {
                this.whiteListBiomes.add(biome);
                this.blackListBiomes.remove(biome);
            }
        }

        public void merge(@NotNull BiomePropertyList list) {
            this.whiteListBiomes.addAll(list.whiteListBiomes);
            this.blackListBiomes.addAll(list.blackListBiomes);
        }

        public boolean checkBiome(Biome biome) {
            boolean valid = true;
            if (this.blackListBiomes.size() > 0) {
                boolean bl = valid = !this.blackListBiomes.contains(biome);
            }
            if (this.whiteListBiomes.size() > 0) {
                valid = this.whiteListBiomes.contains(biome);
            }
            return valid;
        }
    }
}

