/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.recipes.catalysts;

import javax.annotation.Nonnull;

public class CatalystInfo
implements Comparable<CatalystInfo> {
    public static final int NO_TIER = -1;
    private final int tier;
    private final double yieldEfficiency;
    private final double energyEfficiency;
    private final double speedEfficiency;

    public CatalystInfo(int tier, double yieldEfficiency, double energyEfficiency, double speedEfficiency) {
        this.tier = tier;
        this.yieldEfficiency = yieldEfficiency;
        this.energyEfficiency = energyEfficiency;
        this.speedEfficiency = speedEfficiency;
    }

    public int getTier() {
        return this.tier;
    }

    public double getYieldEfficiency() {
        return this.yieldEfficiency;
    }

    public double getEnergyEfficiency() {
        return this.energyEfficiency;
    }

    public double getSpeedEfficiency() {
        return this.speedEfficiency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalystInfo that = (CatalystInfo)o;
        if (this.getTier() != that.getTier()) {
            return false;
        }
        if (Double.compare(that.getYieldEfficiency(), this.getYieldEfficiency()) != 0) {
            return false;
        }
        if (Double.compare(that.getEnergyEfficiency(), this.getEnergyEfficiency()) != 0) {
            return false;
        }
        return Double.compare(that.getSpeedEfficiency(), this.getSpeedEfficiency()) == 0;
    }

    public int hashCode() {
        int result = this.getTier();
        long temp = Double.doubleToLongBits(this.getYieldEfficiency());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.getEnergyEfficiency());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.getSpeedEfficiency());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public int compareTo(@Nonnull CatalystInfo o) {
        int result = Integer.compare(this.getTier(), o.getTier());
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.getSpeedEfficiency(), o.getSpeedEfficiency());
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.getYieldEfficiency(), o.getYieldEfficiency());
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.getEnergyEfficiency(), o.getEnergyEfficiency());
        return result;
    }
}

