/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.recipes.builders;

import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.recipeproperties.PrimitiveProperty;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.ValidationResult;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.SusyLog;
import supersymmetry.api.recipes.properties.EvaporationEnergyProperty;

public class EvaporationPoolRecipeBuilder
extends RecipeBuilder<EvaporationPoolRecipeBuilder> {
    int eutStorage = -1;

    public EvaporationPoolRecipeBuilder() {
    }

    public EvaporationPoolRecipeBuilder(EvaporationPoolRecipeBuilder other) {
        super((RecipeBuilder)other);
        this.eutStorage = other.eutStorage;
    }

    public EvaporationPoolRecipeBuilder copy() {
        return new EvaporationPoolRecipeBuilder(this);
    }

    public EvaporationPoolRecipeBuilder Jt(int Jt) {
        if (Jt <= 0) {
            SusyLog.logger.error("Evaporation Pool required energy cannot be less then or equal to one.", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        this.eutStorage = Jt;
        this.applyProperty(EvaporationEnergyProperty.getInstance(), Jt);
        return this;
    }

    public boolean applyProperty(@NotNull String key, Object value) {
        if (key.equals("evaporation_energy")) {
            this.Jt((Integer)value);
            return true;
        }
        return super.applyProperty(key, value);
    }

    public EvaporationPoolRecipeBuilder EUt(int EUt) {
        this.eutStorage = EUt * 10;
        return (EvaporationPoolRecipeBuilder)super.EUt(EUt);
    }

    public ValidationResult<Recipe> build() {
        if (this.recipePropertyStorage == null || !this.recipePropertyStorage.hasRecipeProperty((RecipeProperty)EvaporationEnergyProperty.getInstance())) {
            if (this.eutStorage <= 0) {
                this.Jt(22440 * ((GTRecipeInput)this.getFluidInputs().get(0)).getAmount() / (100 * (this.getDuration() == 0 ? 200 : this.getDuration())));
            } else {
                this.Jt(this.eutStorage * 10);
            }
        }
        this.EUt(-1);
        this.applyProperty((RecipeProperty)PrimitiveProperty.getInstance(), true);
        return super.build();
    }
}

