/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.recipes.builders;

import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import supersymmetry.api.recipes.properties.DroneDimensionProperty;

public class DronePadRecipeBuilder
extends RecipeBuilder<DronePadRecipeBuilder> {
    public DronePadRecipeBuilder() {
    }

    public DronePadRecipeBuilder(Recipe recipe, RecipeMap<DronePadRecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
    }

    public DronePadRecipeBuilder(RecipeBuilder<DronePadRecipeBuilder> recipeBuilder) {
        super(recipeBuilder);
    }

    public DronePadRecipeBuilder copy() {
        return new DronePadRecipeBuilder(this);
    }

    public boolean applyProperty(@Nonnull String key, Object value) {
        if (key.equals("dimension")) {
            if (value instanceof Integer) {
                this.dimension((Integer)value);
            } else if (value instanceof List && !((List)value).isEmpty() && ((List)value).get(0) instanceof Integer) {
                IntList dimensionIDs = this.getDimensionIDs();
                if (dimensionIDs == IntLists.EMPTY_LIST) {
                    dimensionIDs = new IntArrayList();
                    this.applyProperty(DroneDimensionProperty.getInstance(), dimensionIDs);
                }
                dimensionIDs.addAll((Collection)((List)value));
            } else {
                throw new IllegalArgumentException("Invalid Dimension Property Type! (Drone)");
            }
            return true;
        }
        return super.applyProperty(key, value);
    }

    public DronePadRecipeBuilder dimension(int dimensionID) {
        IntList dimensionIDs = this.getDimensionIDs();
        if (dimensionIDs == IntLists.EMPTY_LIST) {
            dimensionIDs = new IntArrayList();
            this.applyProperty(DroneDimensionProperty.getInstance(), dimensionIDs);
        }
        dimensionIDs.add(dimensionID);
        return this;
    }

    public DronePadRecipeBuilder duration(int duration) {
        return (DronePadRecipeBuilder)super.duration(Math.max(duration, 800));
    }

    public IntList getDimensionIDs() {
        return this.recipePropertyStorage == null ? IntLists.EMPTY_LIST : (IntList)this.recipePropertyStorage.getRecipePropertyValue((RecipeProperty)DroneDimensionProperty.getInstance(), (Object)IntLists.EMPTY_LIST);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append(DroneDimensionProperty.getInstance().getKey(), (Object)this.getDimensionIDs().toString()).toString();
    }
}

