/*
 * Decompiled with CFR 0.152.
 */
package supersymmetry.api.recipes.builders;

import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import supersymmetry.api.recipes.properties.BiomeProperty;

public class BiomeRecipeBuilder
extends RecipeBuilder<BiomeRecipeBuilder> {
    public BiomeRecipeBuilder() {
    }

    public BiomeRecipeBuilder(Recipe recipe, RecipeMap<BiomeRecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
    }

    public BiomeRecipeBuilder(RecipeBuilder<BiomeRecipeBuilder> recipeBuilder) {
        super(recipeBuilder);
    }

    public BiomeRecipeBuilder copy() {
        return new BiomeRecipeBuilder(this);
    }

    public boolean applyProperty(@NotNull String key, Object value) {
        if (key.equals("biome")) {
            if (value instanceof BiomeProperty.BiomePropertyList) {
                BiomeProperty.BiomePropertyList list = (BiomeProperty.BiomePropertyList)value;
                BiomeProperty.BiomePropertyList biomes = this.getBiomePropertyList();
                if (biomes == BiomeProperty.BiomePropertyList.EMPTY_LIST) {
                    biomes = new BiomeProperty.BiomePropertyList();
                    this.applyProperty(BiomeProperty.getInstance(), biomes);
                }
                biomes.merge(list);
                return true;
            }
            return false;
        }
        return super.applyProperty(key, value);
    }

    public BiomeRecipeBuilder biomes(String ... biomes) {
        return this.biomes(false, biomes);
    }

    private BiomeRecipeBuilder biomes(boolean toBlacklist, String ... biomeRLs) {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        for (String biomeRL : biomeRLs) {
            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biomeRL));
            if (biome == null) {
                throw new NoSuchElementException("No biome with ResouceLocation \"" + biomeRL + "\" found");
            }
            biomes.add(biome);
        }
        return this.biomesInternal(toBlacklist, biomes);
    }

    private BiomeRecipeBuilder biomesInternal(boolean toBlacklist, List<Biome> biomes) {
        BiomeProperty.BiomePropertyList biomePropertyList = this.getBiomePropertyList();
        if (biomePropertyList == BiomeProperty.BiomePropertyList.EMPTY_LIST) {
            biomePropertyList = new BiomeProperty.BiomePropertyList();
            this.applyProperty(BiomeProperty.getInstance(), biomePropertyList);
        }
        for (Biome biome : biomes) {
            biomePropertyList.add(biome, toBlacklist);
        }
        return this;
    }

    public BiomeProperty.BiomePropertyList getBiomePropertyList() {
        return this.recipePropertyStorage == null ? BiomeProperty.BiomePropertyList.EMPTY_LIST : (BiomeProperty.BiomePropertyList)this.recipePropertyStorage.getRecipePropertyValue((RecipeProperty)BiomeProperty.getInstance(), (Object)BiomeProperty.BiomePropertyList.EMPTY_LIST);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("biomes", (Object)this.getBiomePropertyList()).toString();
    }
}

